/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.ImageProcessor;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProcessorImpl
extends DLPreviewableProcessor
implements ImageProcessor {
    private static Log _log = LogFactoryUtil.getLog(ImageProcessorImpl.class);
    private static ImageProcessorImpl _instance = new ImageProcessorImpl();
    private List<Long> _fileVersionIds = new Vector<Long>();
    private Set<String> _imageMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES);

    static {
        InstancePool.put((String)ImageProcessorImpl.class.getName(), (Object)((Object)_instance));
    }

    public static ImageProcessorImpl getInstance() {
        return _instance;
    }

    public void cleanUp(FileEntry fileEntry) {
        ImageProcessorImpl.deleteFiles((FileEntry)fileEntry, null);
    }

    public void cleanUp(FileVersion fileVersion) {
        String type = _instance.getThumbnailType(fileVersion);
        ImageProcessorImpl.deleteFiles((FileVersion)fileVersion, (String)type);
    }

    public void generateImages(FileVersion fileVersion) {
        _instance._generateImages(fileVersion);
    }

    public Set<String> getImageMimeTypes() {
        return ImageProcessorImpl._instance._imageMimeTypes;
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion) throws Exception {
        if (this._previewGenerationRequired(fileVersion)) {
            String type = this.getPreviewType(fileVersion);
            return _instance.doGetPreviewAsStream(fileVersion, type);
        }
        return fileVersion.getContentStream(false);
    }

    public long getPreviewFileSize(FileVersion fileVersion) throws Exception {
        if (this._previewGenerationRequired(fileVersion)) {
            String type = this.getPreviewType(fileVersion);
            return _instance.doGetPreviewFileSize(fileVersion, type);
        }
        return fileVersion.getSize();
    }

    public String getPreviewType(FileVersion fileVersion) {
        return this._getType(fileVersion);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return _instance.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return _instance.doGetThumbnailFileSize(fileVersion, index);
    }

    public String getThumbnailType(FileVersion fileVersion) {
        return this._getType(fileVersion);
    }

    public boolean hasImages(FileVersion fileVersion) {
        if (!PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && !PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            return false;
        }
        boolean hasImages = false;
        try {
            if (_instance._hasPreview(fileVersion) && this.hasThumbnails(fileVersion)) {
                hasImages = true;
            }
            if (!hasImages && _instance.isSupported(fileVersion)) {
                _instance._queueGeneration(fileVersion);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return hasImages;
    }

    public boolean isImageSupported(FileVersion fileVersion) {
        return _instance.isSupported(fileVersion);
    }

    public boolean isImageSupported(String mimeType) {
        return _instance.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        return this._imageMimeTypes.contains(mimeType);
    }

    public void storeThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long custom1ImageId, long custom2ImageId, InputStream is, String type) throws Exception {
        _instance._storeThumbnail(companyId, groupId, fileEntryId, fileVersionId, custom1ImageId, custom2ImageId, is, type);
    }

    public void trigger(FileVersion fileVersion) {
        _instance._queueGeneration(fileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "image");
        this.exportPreview(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "image");
        FileVersion importedFileVersion = importedFileEntry.getFileVersion();
        if (!this._previewGenerationRequired(importedFileVersion)) {
            return;
        }
        this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "image", this.getPreviewType(importedFileVersion));
    }

    protected void exportPreview(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!(this.isSupported(fileVersion) && this._previewGenerationRequired(fileVersion) && this._hasPreview(fileVersion))) {
            return;
        }
        this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "image", this.getPreviewType(fileVersion));
    }

    private ImageProcessorImpl() {
    }

    private void _generateImages(FileVersion fileVersion) {
        InputStream inputStream;
        block11: {
            RenderedImage renderedImage;
            block10: {
                block9: {
                    inputStream = null;
                    if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED || PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) break block9;
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(fileVersion.getFileVersionId());
                    return;
                }
                inputStream = fileVersion.getContentStream(false);
                byte[] bytes = FileUtil.getBytes((InputStream)inputStream);
                ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
                renderedImage = imageBag.getRenderedImage();
                if (renderedImage != null) break block10;
                StreamUtil.cleanUp((InputStream)inputStream);
                this._fileVersionIds.remove(fileVersion.getFileVersionId());
                return;
            }
            try {
                if (!this._hasPreview(fileVersion)) {
                    this._storePreviewImage(fileVersion, renderedImage);
                }
                if (this.hasThumbnails(fileVersion)) break block11;
                this.storeThumbnailImages(fileVersion, renderedImage);
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                StreamUtil.cleanUp(inputStream);
                this._fileVersionIds.remove(fileVersion.getFileVersionId());
            }
            catch (Exception e2) {
                try {
                    _log.error((Object)e2, (Throwable)e2);
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(fileVersion.getFileVersionId());
                    throw throwable;
                }
                StreamUtil.cleanUp((InputStream)inputStream);
                this._fileVersionIds.remove(fileVersion.getFileVersionId());
            }
        }
        StreamUtil.cleanUp((InputStream)inputStream);
        this._fileVersionIds.remove(fileVersion.getFileVersionId());
    }

    private String _getType(FileVersion fileVersion) {
        String type = "png";
        if (fileVersion == null) {
            return type;
        }
        String extension = fileVersion.getExtension();
        if (extension.equals("jpeg")) {
            type = "jpg";
        } else if (!this._previewGenerationRequired(fileVersion)) {
            type = extension;
        }
        return type;
    }

    private boolean _hasPreview(FileVersion fileVersion) throws PortalException, SystemException {
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED && this._previewGenerationRequired(fileVersion)) {
            String type = this.getPreviewType(fileVersion);
            String previewFilePath = this.getPreviewFilePath(fileVersion, type);
            if (!DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath)) {
                return false;
            }
        }
        return true;
    }

    private boolean _previewGenerationRequired(FileVersion fileVersion) {
        String type = fileVersion.getExtension();
        return type.equals("tiff") || type.equals("tif");
    }

    private void _queueGeneration(FileVersion fileVersion) {
        if (!this._fileVersionIds.contains(fileVersion.getFileVersionId()) && this.isSupported(fileVersion) && !this.hasThumbnails(fileVersion)) {
            this._fileVersionIds.add(fileVersion.getFileVersionId());
            if (PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
                try {
                    MessageBusUtil.sendSynchronousMessage((String)"liferay/document_library_image_processor", (Object)fileVersion);
                }
                catch (MessageBusException mbe) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)mbe, (Throwable)mbe);
                    }
                }
            } else {
                MessageBusUtil.sendMessage((String)"liferay/document_library_image_processor", (Object)fileVersion);
            }
        }
    }

    private void _storePreviewImage(FileVersion fileVersion, RenderedImage renderedImage) throws Exception {
        String type = this.getPreviewType(fileVersion);
        File file = null;
        try {
            file = FileUtil.createTempFile((String)type);
            FileOutputStream fos = new FileOutputStream(file);
            try {
                ImageToolUtil.write((RenderedImage)renderedImage, (String)type, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
            this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, type), file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    private void _storeThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long custom1ImageId, long custom2ImageId, InputStream is, String type) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append(ImageProcessorImpl.getPathSegment((long)groupId, (long)fileEntryId, (long)fileVersionId, (boolean)false));
        if (custom1ImageId != 0L) {
            sb.append("-");
            sb.append(1);
        } else if (custom2ImageId != 0L) {
            sb.append("-");
            sb.append(2);
        }
        sb.append(".");
        sb.append(type);
        String filePath = sb.toString();
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)is);
            this.addFileToStore(companyId, "document_thumbnail/", filePath, file);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }
}

