/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.BaseDLProcessorImpl;
import com.liferay.portlet.documentlibrary.util.RawMetadataProcessor;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class RawMetadataProcessorImpl
extends BaseDLProcessorImpl
implements RawMetadataProcessor {
    private static Log _log = LogFactoryUtil.getLog(RawMetadataProcessorImpl.class);
    private static RawMetadataProcessorImpl _instance = new RawMetadataProcessorImpl();

    static {
        InstancePool.put((String)RawMetadataProcessorImpl.class.getName(), (Object)((Object)_instance));
    }

    public static RawMetadataProcessorImpl getInstance() {
        return _instance;
    }

    public void cleanUp(FileEntry fileEntry) {
    }

    public void cleanUp(FileVersion fileVersion) {
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
    }

    public void generateMetadata(FileVersion fileVersion) throws SystemException {
        if (!this.isEnabled()) {
            return;
        }
        long fileEntryMetadataCount = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadataCount((long)fileVersion.getFileEntryId(), (long)fileVersion.getFileVersionId());
        if (fileEntryMetadataCount == 0L) {
            _instance.trigger(fileVersion);
        }
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
    }

    public boolean isSupported(FileVersion fileVersion) {
        return true;
    }

    public boolean isSupported(String mimeType) {
        return true;
    }

    public void saveMetadata(FileVersion fileVersion) throws PortalException, SystemException {
        if (!this.isEnabled()) {
            return;
        }
        Map rawMetadataMap = null;
        if (fileVersion instanceof LiferayFileVersion) {
            try {
                LiferayFileVersion liferayFileVersion = (LiferayFileVersion)fileVersion;
                File file = liferayFileVersion.getFile(false);
                rawMetadataMap = RawMetadataProcessorUtil.getRawMetadataMap((String)fileVersion.getExtension(), (String)fileVersion.getMimeType(), (File)file);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        if (rawMetadataMap == null) {
            InputStream inputStream = null;
            try {
                inputStream = fileVersion.getContentStream(false);
                rawMetadataMap = RawMetadataProcessorUtil.getRawMetadataMap((String)fileVersion.getExtension(), (String)fileVersion.getMimeType(), (InputStream)inputStream);
            }
            finally {
                StreamUtil.cleanUp((InputStream)inputStream);
            }
        }
        List ddmStructures = DDMStructureLocalServiceUtil.getClassStructures((long)PortalUtil.getClassNameId(DLFileEntry.class), (int)-1, (int)-1);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(fileVersion.getGroupId());
        serviceContext.setUserId(fileVersion.getUserId());
        DLFileEntryMetadataLocalServiceUtil.updateFileEntryMetadata((long)fileVersion.getCompanyId(), (List)ddmStructures, (long)0L, (long)fileVersion.getFileEntryId(), (long)fileVersion.getFileVersionId(), (Map)rawMetadataMap, (ServiceContext)serviceContext);
        FileEntry fileEntry = fileVersion.getFileEntry();
        if (fileEntry instanceof LiferayFileEntry) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)DLFileEntryConstants.getClassName());
            LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
            indexer.reindex((Object)liferayFileEntry.getDLFileEntry());
        }
    }

    public void trigger(FileVersion fileVersion) {
        if (!this.isEnabled()) {
            return;
        }
        if (PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
            try {
                MessageBusUtil.sendSynchronousMessage((String)"liferay/document_library_raw_metadata_processor", (Object)fileVersion);
            }
            catch (MessageBusException mbe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)mbe, (Throwable)mbe);
                }
            }
        } else {
            MessageBusUtil.sendMessage((String)"liferay/document_library_raw_metadata_processor", (Object)fileVersion);
        }
    }

    private RawMetadataProcessorImpl() {
    }
}

