/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.LiferayConverter;
import com.liferay.portlet.documentlibrary.util.LiferayVideoConverter;
import com.liferay.portlet.documentlibrary.util.LiferayVideoThumbnailConverter;
import com.liferay.portlet.documentlibrary.util.VideoProcessor;
import com.liferay.util.log4j.Log4JUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoProcessorImpl
extends DLPreviewableProcessor
implements VideoProcessor {
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_CONTAINERS;
    private static Log _log = LogFactoryUtil.getLog(VideoProcessorImpl.class);
    private static VideoProcessorImpl _instance = new VideoProcessorImpl();
    private List<Long> _fileVersionIds = new Vector<Long>();
    private Set<String> _videoMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_MIME_TYPES);

    static {
        InstancePool.put((String)VideoProcessorImpl.class.getName(), (Object)((Object)_instance));
    }

    public static VideoProcessorImpl getInstance() {
        return _instance;
    }

    public void generateVideo(FileVersion fileVersion) throws Exception {
        _instance._generateVideo(fileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return _instance.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return _instance.doGetPreviewFileSize(fileVersion, type);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return _instance.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return _instance.doGetThumbnailFileSize(fileVersion, index);
    }

    public Set<String> getVideoMimeTypes() {
        return VideoProcessorImpl._instance._videoMimeTypes;
    }

    public boolean hasVideo(FileVersion fileVersion) {
        boolean hasVideo = false;
        try {
            hasVideo = _instance._hasVideo(fileVersion);
            if (!hasVideo && _instance.isSupported(fileVersion)) {
                _instance._queueGeneration(fileVersion);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return hasVideo;
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        try {
            if (XugglerUtil.isEnabled()) {
                return this._videoMimeTypes.contains(mimeType);
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isVideoSupported(FileVersion fileVersion) {
        return _instance.isSupported(fileVersion);
    }

    public boolean isVideoSupported(String mimeType) {
        return _instance.isSupported(mimeType);
    }

    public void trigger(FileVersion fileVersion) {
        _instance._queueGeneration(fileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "video");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "video");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
                return;
            }
            String[] stringArray = _PREVIEW_TYPES;
            int n = _PREVIEW_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String previewType = stringArray[n2];
                if (previewType.equals("mp4") || previewType.equals("ogv")) {
                    this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "video", previewType);
                }
                ++n2;
            }
        }
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "jpg";
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            return;
        }
        String[] stringArray = _PREVIEW_TYPES;
        int n = _PREVIEW_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String previewType = stringArray[n2];
            if (previewType.equals("mp4") || previewType.equals("ogv")) {
                this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "video", previewType);
            }
            ++n2;
        }
    }

    protected void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
        if (!this.hasThumbnail(fileVersion, 0)) {
            this.addFileToStore(fileVersion.getCompanyId(), "document_thumbnail/", this.getThumbnailFilePath(fileVersion, 0), file);
        }
        if (this.isThumbnailEnabled(1) || this.isThumbnailEnabled(2)) {
            ImageBag imageBag = ImageToolUtil.read((File)file);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            this.storeThumbnailmage(fileVersion, renderedImage, 1);
            this.storeThumbnailmage(fileVersion, renderedImage, 2);
        }
    }

    private VideoProcessorImpl() {
        boolean valid = true;
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            valid = false;
        } else {
            String[] stringArray = _PREVIEW_TYPES;
            int n = _PREVIEW_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String previewType = stringArray[n2];
                if (!previewType.equals("mp4") && !previewType.equals("ogv")) {
                    valid = false;
                    break;
                }
                ++n2;
            }
        }
        if (!valid && _log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Liferay is incorrectly configured to generate video ");
            sb.append("previews using video containers other than MP4 or ");
            sb.append("OGV. Please change the property ");
            sb.append("dl.file.entry.preview.video.containers");
            sb.append(" in portal-ext.properties.");
            _log.warn((Object)sb.toString());
        }
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    private void _generateThumbnailXuggler(FileVersion fileVersion, File file, int height, int width) throws Exception {
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
        try {
            try {
                try {
                    if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
                        LiferayVideoThumbnailProcessCallable processCallable = new LiferayVideoThumbnailProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), file.getCanonicalPath(), thumbnailTempFile, "jpg", height, width, PropsValues.DL_FILE_ENTRY_THUMBNAIL_VIDEO_FRAME_PERCENTAGE);
                        ProcessExecutor.execute((ProcessCallable)processCallable, (String)ClassPathUtil.getPortalClassPath());
                    } else {
                        LiferayVideoThumbnailConverter liferayConverter = new LiferayVideoThumbnailConverter(file.getCanonicalPath(), thumbnailTempFile, "jpg", height, width, PropsValues.DL_FILE_ENTRY_THUMBNAIL_VIDEO_FRAME_PERCENTAGE);
                        ((LiferayConverter)liferayConverter).convert();
                    }
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                }
                this.storeThumbnailImages(fileVersion, thumbnailTempFile);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Xuggler generated a thumbnail for " + fileVersion.getTitle() + " in " + stopWatch));
                }
            }
            catch (Exception e3) {
                throw new SystemException((Throwable)e3);
            }
        }
        finally {
            FileUtil.delete((File)thumbnailTempFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _generateVideo(FileVersion fileVersion) throws Exception {
        File videoTempFile;
        File[] previewTempFiles;
        InputStream inputStream;
        block24: {
            int i2;
            int i3;
            if (!XugglerUtil.isEnabled()) return;
            if (this._hasVideo(fileVersion)) {
                return;
            }
            inputStream = null;
            previewTempFiles = new File[_PREVIEW_TYPES.length];
            videoTempFile = null;
            try {
                try {
                    File file = null;
                    if (!this.hasPreviews(fileVersion) || !this.hasThumbnails(fileVersion)) {
                        if (fileVersion instanceof LiferayFileVersion) {
                            try {
                                LiferayFileVersion liferayFileVersion = (LiferayFileVersion)fileVersion;
                                file = liferayFileVersion.getFile(false);
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {}
                        }
                        if (file == null) {
                            inputStream = fileVersion.getContentStream(false);
                            videoTempFile = FileUtil.createTempFile((String)fileVersion.getExtension());
                            FileUtil.write((File)videoTempFile, (InputStream)inputStream);
                            file = videoTempFile;
                        }
                    }
                    if (!this.hasPreviews(fileVersion)) {
                        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
                        int i4 = 0;
                        while (true) {
                            if (i4 >= _PREVIEW_TYPES.length) {
                                try {
                                    this._generateVideoXuggler(fileVersion, file, previewTempFiles, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_WIDTH);
                                }
                                catch (Exception e2) {
                                    _log.error((Object)e2, (Throwable)e2);
                                }
                                break;
                            }
                            previewTempFiles[i4] = this.getPreviewTempFile(tempFileId, _PREVIEW_TYPES[i4]);
                            ++i4;
                        }
                    }
                    if (!this.hasThumbnails(fileVersion)) {
                        try {
                            this._generateThumbnailXuggler(fileVersion, file, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_WIDTH);
                        }
                        catch (Exception e3) {
                            _log.error((Object)e3, (Throwable)e3);
                        }
                    }
                    break block24;
                }
                catch (NoSuchFileEntryException noSuchFileEntryException) {
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(fileVersion.getFileVersionId());
                    i3 = 0;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                this._fileVersionIds.remove(fileVersion.getFileVersionId());
                i2 = 0;
            }
            while (true) {
                if (i3 >= previewTempFiles.length) {
                    FileUtil.delete((File)videoTempFile);
                    return;
                }
                FileUtil.delete((File)previewTempFiles[i3]);
                ++i3;
            }
            while (true) {
                if (i2 >= previewTempFiles.length) {
                    FileUtil.delete((File)videoTempFile);
                    throw throwable;
                }
                FileUtil.delete((File)previewTempFiles[i2]);
                ++i2;
            }
        }
        StreamUtil.cleanUp((InputStream)inputStream);
        this._fileVersionIds.remove(fileVersion.getFileVersionId());
        int i5 = 0;
        while (true) {
            if (i5 >= previewTempFiles.length) {
                FileUtil.delete((File)videoTempFile);
                return;
            }
            FileUtil.delete((File)previewTempFiles[i5]);
            ++i5;
        }
    }

    private void _generateVideoXuggler(FileVersion fileVersion, File srcFile, File destFile, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_FORK_PROCESS_ENABLED) {
            LiferayVideoProcessCallable processCallable = new LiferayVideoProcessCallable(ServerDetector.getServerId(), PropsUtil.get("liferay.home"), Log4JUtil.getCustomLogSettings(), srcFile.getCanonicalPath(), destFile.getCanonicalPath(), containerType, PropsUtil.getProperties("dl.file.entry.preview.video.", false), PropsUtil.getProperties("xuggler.ffpreset.", true));
            ProcessExecutor.execute((ProcessCallable)processCallable, (String)ClassPathUtil.getPortalClassPath());
        } else {
            LiferayVideoConverter liferayConverter = new LiferayVideoConverter(srcFile.getCanonicalPath(), destFile.getCanonicalPath(), containerType, PropsUtil.getProperties("dl.file.entry.preview.video.", false), PropsUtil.getProperties("xuggler.ffpreset.", true));
            ((LiferayConverter)liferayConverter).convert();
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Xuggler generated a " + containerType + " preview video for " + fileVersion.getTitle() + " in " + stopWatch));
        }
    }

    private void _generateVideoXuggler(FileVersion fileVersion, File srcFile, File[] destFiles, int height, int width) {
        try {
            int i2 = 0;
            while (i2 < destFiles.length) {
                this._generateVideoXuggler(fileVersion, srcFile, destFiles[i2], _PREVIEW_TYPES[i2]);
                ++i2;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    private boolean _hasVideo(FileVersion fileVersion) throws Exception {
        if (!this.isSupported(fileVersion)) {
            return false;
        }
        return this.hasPreviews(fileVersion) && this.hasThumbnails(fileVersion);
    }

    private void _queueGeneration(FileVersion fileVersion) {
        if (this._fileVersionIds.contains(fileVersion.getFileVersionId()) || !this.isSupported(fileVersion)) {
            return;
        }
        this._fileVersionIds.add(fileVersion.getFileVersionId());
        if (PropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
            try {
                MessageBusUtil.sendSynchronousMessage((String)"liferay/document_library_video_processor", (Object)fileVersion);
            }
            catch (MessageBusException mbe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)mbe, (Throwable)mbe);
                }
            }
        } else {
            MessageBusUtil.sendMessage((String)"liferay/document_library_video_processor", (Object)fileVersion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LiferayVideoProcessCallable
    implements ProcessCallable<String> {
        private Map<String, String> _customLogSettings;
        private Properties _ffpresetProperties;
        private String _inputURL;
        private String _liferayHome;
        private String _outputURL;
        private String _serverId;
        private String _videoContainer;
        private Properties _videoProperties;

        public LiferayVideoProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, String inputURL, String outputURL, String videoContainer, Properties videoProperties, Properties ffpresetProperties) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputURL = inputURL;
            this._outputURL = outputURL;
            this._videoContainer = videoContainer;
            this._videoProperties = videoProperties;
            this._ffpresetProperties = ffpresetProperties;
        }

        public String call() throws ProcessException {
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties((Properties)systemProperties);
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayVideoConverter liferayConverter = new LiferayVideoConverter(this._inputURL, this._outputURL, this._videoContainer, this._videoProperties, this._ffpresetProperties);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e2) {
                throw new ProcessException((Throwable)e2);
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LiferayVideoThumbnailProcessCallable
    implements ProcessCallable<String> {
        private Map<String, String> _customLogSettings;
        private String _extension;
        private int _height;
        private String _inputURL;
        private String _liferayHome;
        private File _outputFile;
        private int _percentage;
        private String _serverId;
        private int _width;

        public LiferayVideoThumbnailProcessCallable(String serverId, String liferayHome, Map<String, String> customLogSettings, String inputURL, File outputFile, String extension, int height, int width, int percentage) {
            this._serverId = serverId;
            this._liferayHome = liferayHome;
            this._customLogSettings = customLogSettings;
            this._inputURL = inputURL;
            this._outputFile = outputFile;
            this._extension = extension;
            this._height = height;
            this._width = width;
            this._percentage = percentage;
        }

        public String call() throws ProcessException {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Properties systemProperties = System.getProperties();
            SystemEnv.setProperties((Properties)systemProperties);
            Log4JUtil.initLog4J((String)this._serverId, (String)this._liferayHome, (ClassLoader)classLoader, (LogFactory)new Log4jLogFactoryImpl(), this._customLogSettings);
            try {
                LiferayVideoThumbnailConverter liferayConverter = new LiferayVideoThumbnailConverter(this._inputURL, this._outputFile, this._extension, this._height, this._width, this._percentage);
                ((LiferayConverter)liferayConverter).convert();
            }
            catch (Exception e2) {
                throw new ProcessException((Throwable)e2);
            }
            return "";
        }
    }
}

