/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.dynamicdatalists.asset.DDLRecordAssetRenderer;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.permission.DDLRecordSetPermission;

public class DDLRecordAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = DDLRecord.class.getName();
    public static final String TYPE = "record";
    private static final boolean _CATEGORIZABLE = false;
    private static final boolean _SELECTABLE = false;

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        DDLRecord record = null;
        DDLRecordVersion recordVersion = null;
        if (type == 0) {
            recordVersion = DDLRecordLocalServiceUtil.getRecordVersion((long)classPK);
            record = recordVersion.getRecord();
        } else {
            record = DDLRecordLocalServiceUtil.getRecord((long)classPK);
            recordVersion = record.getRecordVersion();
        }
        return new DDLRecordAssetRenderer(record, recordVersion);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        DDLRecord record = DDLRecordLocalServiceUtil.getRecord((long)classPK);
        return DDLRecordSetPermission.contains(permissionChecker, record.getRecordSet(), actionId);
    }

    public boolean isCategorizable() {
        return false;
    }

    public boolean isSelectable() {
        return false;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

