/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatalists.lar.DDLPortletDataHandler;
import com.liferay.portlet.dynamicdatalists.lar.DDLPortletDataHandlerUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DDLDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final boolean _DATA_LOCALIZED = true;
    private static Log _log = LogFactoryUtil.getLog(DDLDisplayPortletDataHandlerImpl.class);

    public String[] getDataPortletPreferences() {
        return new String[]{"recordSetId", "detailDDMTemplateId", "listDDMTemplateId"};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isDataLocalized() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletPreferences.setValue("recordSetId", "");
        portletPreferences.setValue("detailDDMTemplateId", "");
        portletPreferences.setValue("listDDMTemplateId", "");
        portletPreferences.setValue("editable", Boolean.TRUE.toString());
        portletPreferences.setValue("spreadsheet", Boolean.FALSE.toString());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.dynamicdatalist", portletDataContext.getScopeGroupId());
        long recordSetId = GetterUtil.getLong((String)portletPreferences.getValue("recordSetId", null), (long)0L);
        if (recordSetId == 0L) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No record set found for " + portletId));
            }
            return "";
        }
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("record-set-data");
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getRecordSet((long)recordSetId);
        DDLPortletDataHandler ddlPortletDataHandler = DDLPortletDataHandlerUtil.getDDLPortletDataHandler();
        ddlPortletDataHandler.exportRecordSet(portletDataContext, rootElement, recordSet);
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.dynamicdatalist", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        if (Validator.isNull((String)data)) {
            return null;
        }
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element recordSetElement = rootElement.element("record-set");
        if (recordSetElement != null) {
            DDLPortletDataHandler ddlPortletDataHandler = DDLPortletDataHandlerUtil.getDDLPortletDataHandler();
            ddlPortletDataHandler.importRecordSet(portletDataContext, recordSetElement);
        }
        long importedRecordSetId = GetterUtil.getLong((String)portletPreferences.getValue("recordSetId", null));
        long importedDetailDDMTemplateId = GetterUtil.getLong((String)portletPreferences.getValue("detailDDMTemplateId", null));
        long importedListDDMTemplateId = GetterUtil.getLong((String)portletPreferences.getValue("listDDMTemplateId", null));
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        long recordSetId = MapUtil.getLong((Map)recordSetIds, (long)importedRecordSetId, (long)importedRecordSetId);
        Map templateIds = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class);
        long detailDDMTemplateId = MapUtil.getLong((Map)templateIds, (long)importedDetailDDMTemplateId, (long)importedDetailDDMTemplateId);
        long listDDMTemplateId = MapUtil.getLong((Map)templateIds, (long)importedListDDMTemplateId, (long)importedListDDMTemplateId);
        portletPreferences.setValue("recordSetId", String.valueOf(recordSetId));
        portletPreferences.setValue("detailDDMTemplateId", String.valueOf(detailDDMTemplateId));
        portletPreferences.setValue("listDDMTemplateId", String.valueOf(listDDMTemplateId));
        return portletPreferences;
    }
}

