/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatalists.lar.DDLPortletDataHandler;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.persistence.DDLRecordSetUtil;
import com.liferay.portlet.dynamicdatamapping.lar.DDMPortletDataHandlerImpl;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DDLPortletDataHandlerImpl
extends BasePortletDataHandler
implements DDLPortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final boolean _DATA_LOCALIZED = true;
    private static final String _NAMESPACE = "ddl";

    public void exportRecordSet(PortletDataContext portletDataContext, Element recordSetsElement, DDLRecordSet recordSet) throws Exception {
        String path = this.getRecordSetPath(portletDataContext, recordSet);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element recordSetElement = recordSetsElement.addElement("record-set");
        portletDataContext.addClassedModel(recordSetElement, path, (ClassedModel)recordSet, _NAMESPACE);
        Element ddmStructuresElement = recordSetElement.addElement("ddm-structures");
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        DDMPortletDataHandlerImpl.exportStructure(portletDataContext, ddmStructuresElement, ddmStructure);
        Element ddmTemplatesElement = recordSetElement.addElement("ddm-templates");
        List ddmTemplates = ddmStructure.getTemplates();
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            DDMPortletDataHandlerImpl.exportTemplate(portletDataContext, ddmTemplatesElement, ddmTemplate);
        }
    }

    public void importRecordSet(PortletDataContext portletDataContext, Element recordSetElement) throws Exception {
        String path;
        Element ddmTemplatesElement;
        Element ddmStructuresElement = recordSetElement.element("ddm-structures");
        if (ddmStructuresElement != null) {
            this.importDDMStructures(portletDataContext, ddmStructuresElement);
        }
        if ((ddmTemplatesElement = recordSetElement.element("ddm-templates")) != null) {
            this.importDDMTemplates(portletDataContext, ddmTemplatesElement);
        }
        if (!portletDataContext.isPathNotProcessed(path = recordSetElement.attributeValue("path"))) {
            return;
        }
        DDLRecordSet recordSet = (DDLRecordSet)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(recordSet.getUserUuid());
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long structureId = MapUtil.getLong((Map)structureIds, (long)recordSet.getDDMStructureId(), (long)recordSet.getDDMStructureId());
        ServiceContext serviceContext = portletDataContext.createServiceContext(recordSetElement, (ClassedModel)recordSet, _NAMESPACE);
        DDLRecordSet importedRecordSet = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDLRecordSet existingRecordSet = DDLRecordSetUtil.fetchByUUID_G((String)recordSet.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingRecordSet == null) {
                serviceContext.setUuid(recordSet.getUuid());
                importedRecordSet = DDLRecordSetLocalServiceUtil.addRecordSet((long)userId, (long)portletDataContext.getScopeGroupId(), (long)structureId, (String)recordSet.getRecordSetKey(), (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (int)recordSet.getScope(), (ServiceContext)serviceContext);
            } else {
                importedRecordSet = DDLRecordSetLocalServiceUtil.updateRecordSet((long)existingRecordSet.getRecordSetId(), (long)structureId, (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (ServiceContext)serviceContext);
            }
        } else {
            importedRecordSet = DDLRecordSetLocalServiceUtil.addRecordSet((long)userId, (long)portletDataContext.getScopeGroupId(), (long)structureId, (String)recordSet.getRecordSetKey(), (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (int)recordSet.getScope(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)recordSet, (ClassedModel)importedRecordSet, _NAMESPACE);
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isDataLocalized() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(DDLPortletDataHandlerImpl.class, "deleteData")) {
            DDLRecordSetLocalServiceUtil.deleteRecordSets((long)portletDataContext.getScopeGroupId());
        }
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.dynamicdatalist", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("ddl-data");
        Element recordSetsElement = rootElement.addElement("record-sets");
        List recordSets = DDLRecordSetLocalServiceUtil.getRecordSets((long)portletDataContext.getScopeGroupId());
        for (DDLRecordSet recordSet : recordSets) {
            if (!portletDataContext.isWithinDateRange(recordSet.getModifiedDate())) continue;
            this.exportRecordSet(portletDataContext, recordSetsElement, recordSet);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.dynamicdatalist", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element recordSetsElement = rootElement.element("record-sets");
        List recordSetElements = recordSetsElement.elements("record-set");
        for (Element recordSetElement : recordSetElements) {
            this.importRecordSet(portletDataContext, recordSetElement);
        }
        return portletPreferences;
    }

    protected String getRecordSetPath(PortletDataContext portletDataContext, DDLRecordSet recordSet) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("167"));
        sb.append("/record-sets/");
        sb.append(recordSet.getRecordSetId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importDDMStructures(PortletDataContext portletDataContext, Element ddmStructureReferencesElement) throws Exception {
        List ddmStructureElements = ddmStructureReferencesElement.elements("structure");
        for (Element ddmStructureElement : ddmStructureElements) {
            DDMPortletDataHandlerImpl.importStructure(portletDataContext, ddmStructureElement);
        }
    }

    protected void importDDMTemplates(PortletDataContext portletDataContext, Element ddmTemplateReferencesElement) throws Exception {
        List ddmTemplateElements = ddmTemplateReferencesElement.elements("template");
        for (Element ddmTemplateElement : ddmTemplateElements) {
            DDMPortletDataHandlerImpl.importTemplate(portletDataContext, ddmTemplateElement);
        }
    }
}

