/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatalists.NoSuchRecordVersionException;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordConstants;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.base.DDLRecordLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatalists.util.comparator.DDLRecordVersionVersionComparator;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLRecordLocalServiceImpl
extends DDLRecordLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DDLRecordLocalServiceImpl.class);

    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, Fields fields, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        long recordId = this.counterLocalService.increment();
        DDLRecord record = this.ddlRecordPersistence.create(recordId);
        record.setUuid(serviceContext.getUuid());
        record.setGroupId(groupId);
        record.setCompanyId(user.getCompanyId());
        record.setUserId(user.getUserId());
        record.setUserName(user.getFullName());
        record.setVersionUserId(user.getUserId());
        record.setVersionUserName(user.getFullName());
        record.setCreateDate(serviceContext.getCreateDate(now));
        record.setModifiedDate(serviceContext.getModifiedDate(now));
        long ddmStorageId = StorageEngineUtil.create((long)recordSet.getCompanyId(), (long)recordSet.getDDMStructureId(), (Fields)fields, (ServiceContext)serviceContext);
        record.setDDMStorageId(ddmStorageId);
        record.setRecordSetId(recordSetId);
        record.setVersion("1.0");
        record.setDisplayIndex(displayIndex);
        this.ddlRecordPersistence.update((BaseModel)record, false);
        DDLRecordVersion recordVersion = this.addRecordVersion(user, record, ddmStorageId, "1.0", displayIndex, 2);
        Locale locale = serviceContext.getLocale();
        this.updateAsset(userId, record, recordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), locale);
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)DDLRecord.class.getName(), (long)recordVersion.getRecordVersionId(), (Object)recordVersion, (ServiceContext)serviceContext);
        return record;
    }

    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, Map<String, Serializable> fieldsMap, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.toFields(ddmStructure.getStructureId(), fieldsMap);
        return this.addRecord(userId, groupId, recordSetId, displayIndex, fields, serviceContext);
    }

    public void deleteRecord(DDLRecord record) throws PortalException, SystemException {
        block3: {
            this.ddlRecordPersistence.remove((BaseModel)record);
            List recordVersions = this.ddlRecordVersionPersistence.findByRecordId(record.getRecordId());
            for (DDLRecordVersion recordVersion : recordVersions) {
                this.ddlRecordVersionPersistence.remove((BaseModel)recordVersion);
                StorageEngineUtil.deleteByClass((long)recordVersion.getDDMStorageId());
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(record.getCompanyId(), record.getGroupId(), DDLRecord.class.getName(), recordVersion.getPrimaryKey());
            }
            try {
                DLStoreUtil.deleteDirectory((long)record.getCompanyId(), (long)0L, (String)DDMUtil.getFileUploadPath((BaseModel)record));
            }
            catch (NoSuchDirectoryException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    public void deleteRecord(long recordId) throws PortalException, SystemException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        this.deleteRecord(record);
    }

    public void deleteRecords(long recordSetId) throws PortalException, SystemException {
        List records = this.ddlRecordPersistence.findByRecordSetId(recordSetId);
        for (DDLRecord record : records) {
            this.deleteRecord(record);
        }
    }

    public DDLRecord fetchRecord(long recordId) throws SystemException {
        return this.ddlRecordPersistence.fetchByPrimaryKey(recordId);
    }

    public DDLRecordVersion getLatestRecordVersion(long recordId) throws PortalException, SystemException {
        List recordVersions = this.ddlRecordVersionPersistence.findByRecordId(recordId);
        if (recordVersions.isEmpty()) {
            throw new NoSuchRecordVersionException("No record versions found for recordId " + recordId);
        }
        recordVersions = ListUtil.copy((List)recordVersions);
        Collections.sort(recordVersions, new DDLRecordVersionVersionComparator());
        return (DDLRecordVersion)recordVersions.get(0);
    }

    public DDLRecord getRecord(long recordId) throws PortalException, SystemException {
        return this.ddlRecordPersistence.findByPrimaryKey(recordId);
    }

    public List<DDLRecord> getRecords(long recordSetId) throws SystemException {
        return this.ddlRecordPersistence.findByRecordSetId(recordSetId);
    }

    public List<DDLRecord> getRecords(long recordSetId, int status, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordFinder.findByR_S(recordSetId, status, start, end, orderByComparator);
    }

    public List<DDLRecord> getRecords(long recordSetId, long userId) throws SystemException {
        return this.ddlRecordPersistence.findByR_U(recordSetId, userId);
    }

    public int getRecordsCount(long recordSetId, int status) throws SystemException {
        return this.ddlRecordFinder.countByR_S(recordSetId, status);
    }

    public DDLRecordVersion getRecordVersion(long recordVersionId) throws PortalException, SystemException {
        return this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
    }

    public DDLRecordVersion getRecordVersion(long recordId, String version) throws PortalException, SystemException {
        return this.ddlRecordVersionPersistence.findByR_V(recordId, version);
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordVersionPersistence.findByRecordId(recordId, start, end, orderByComparator);
    }

    public int getRecordVersionsCount(long recordId) throws SystemException {
        return this.ddlRecordVersionPersistence.countByRecordId(recordId);
    }

    public void revertRecordVersion(long userId, long recordId, String version, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordVersion recordVersion = this.getRecordVersion(recordId, version);
        if (!recordVersion.isApproved()) {
            return;
        }
        Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
        this.updateRecord(userId, recordId, true, recordVersion.getDisplayIndex(), fields, false, serviceContext);
    }

    public void updateAsset(long userId, DDLRecord record, DDLRecordVersion recordVersion, long[] assetCategoryIds, String[] assetTagNames, Locale locale) throws PortalException, SystemException {
        int approvedRecordVersionsCount;
        String version;
        boolean addDraftAssetEntry = false;
        if (recordVersion != null && !recordVersion.isApproved() && !(version = recordVersion.getVersion()).equals("1.0") && (approvedRecordVersionsCount = this.ddlRecordVersionPersistence.countByR_S(record.getRecordId(), 0)) > 0) {
            addDraftAssetEntry = true;
        }
        boolean visible = false;
        if (recordVersion != null && !recordVersion.isApproved()) {
            visible = false;
        }
        DDLRecordSet recordSet = record.getRecordSet();
        String title = LanguageUtil.format((Locale)locale, (String)"new-record-for-list-x", (Object)recordSet.getName(locale));
        if (addDraftAssetEntry) {
            this.assetEntryLocalService.updateEntry(userId, record.getGroupId(), DDLRecordConstants.getClassName(), recordVersion.getRecordVersionId(), record.getUuid(), 0L, assetCategoryIds, assetTagNames, false, null, null, null, null, "text/html", title, null, "", null, null, 0, 0, null, false);
        } else {
            this.assetEntryLocalService.updateEntry(userId, record.getGroupId(), DDLRecordConstants.getClassName(), record.getRecordId(), record.getUuid(), 0L, assetCategoryIds, assetTagNames, visible, null, null, null, null, "text/html", title, null, "", null, null, 0, 0, null, false);
        }
    }

    public DDLRecord updateRecord(long userId, long recordId, boolean majorVersion, int displayIndex, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        record.setModifiedDate(serviceContext.getModifiedDate(null));
        this.ddlRecordPersistence.update((BaseModel)record, false);
        DDLRecordVersion recordVersion = record.getLatestRecordVersion();
        if (recordVersion.isApproved()) {
            DDLRecordSet recordSet = record.getRecordSet();
            long ddmStorageId = StorageEngineUtil.create((long)recordSet.getCompanyId(), (long)recordSet.getDDMStructureId(), (Fields)fields, (ServiceContext)serviceContext);
            String version = this.getNextVersion(recordVersion.getVersion(), majorVersion, serviceContext.getWorkflowAction());
            recordVersion = this.addRecordVersion(user, record, ddmStorageId, version, displayIndex, 2);
        } else {
            StorageEngineUtil.update((long)recordVersion.getDDMStorageId(), (Fields)fields, (boolean)mergeFields, (ServiceContext)serviceContext);
            String version = recordVersion.getVersion();
            this.updateRecordVersion(user, recordVersion, version, displayIndex, recordVersion.getStatus(), serviceContext);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)record.getGroupId(), (long)userId, (String)DDLRecord.class.getName(), (long)recordVersion.getRecordVersionId(), (Object)recordVersion, (ServiceContext)serviceContext);
        return record;
    }

    public DDLRecord updateRecord(long userId, long recordId, int displayIndex, Map<String, Serializable> fieldsMap, boolean mergeFields, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.toFields(ddmStructure.getStructureId(), fieldsMap);
        return this.updateRecord(userId, recordId, false, displayIndex, fields, mergeFields, serviceContext);
    }

    public DDLRecord updateStatus(long userId, long recordVersionId, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(new Date());
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion, false);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordVersion.getRecordId());
        if (status == 0) {
            if (DLUtil.compareVersions((String)record.getVersion(), (String)recordVersion.getVersion()) <= 0) {
                record.setDDMStorageId(recordVersion.getDDMStorageId());
                record.setVersion(recordVersion.getVersion());
                record.setRecordSetId(recordVersion.getRecordSetId());
                record.setDisplayIndex(recordVersion.getDisplayIndex());
                record.setVersion(recordVersion.getVersion());
                record.setVersionUserId(recordVersion.getUserId());
                record.setVersionUserName(recordVersion.getUserName());
                record.setModifiedDate(recordVersion.getCreateDate());
                this.ddlRecordPersistence.update((BaseModel)record, false);
            }
        } else if (record.getVersion().equals(recordVersion.getVersion())) {
            String newVersion = "1.0";
            List approvedRecordVersions = this.ddlRecordVersionPersistence.findByR_S(record.getRecordId(), 0);
            if (!approvedRecordVersions.isEmpty()) {
                newVersion = ((DDLRecordVersion)approvedRecordVersions.get(0)).getVersion();
            }
            record.setVersion(newVersion);
            this.ddlRecordPersistence.update((BaseModel)record, false);
        }
        return record;
    }

    protected DDLRecordVersion addRecordVersion(User user, DDLRecord record, long ddmStorageId, String version, int displayIndex, int status) throws SystemException {
        long recordVersionId = this.counterLocalService.increment();
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.create(recordVersionId);
        recordVersion.setGroupId(record.getGroupId());
        recordVersion.setCompanyId(record.getCompanyId());
        long versionUserId = record.getVersionUserId();
        if (versionUserId <= 0L) {
            versionUserId = record.getUserId();
        }
        recordVersion.setUserId(versionUserId);
        String versionUserName = GetterUtil.getString((String)record.getVersionUserName(), (String)record.getUserName());
        recordVersion.setUserName(versionUserName);
        recordVersion.setCreateDate(record.getModifiedDate());
        recordVersion.setDDMStorageId(ddmStorageId);
        recordVersion.setRecordSetId(record.getRecordSetId());
        recordVersion.setRecordId(record.getRecordId());
        recordVersion.setVersion(version);
        recordVersion.setDisplayIndex(displayIndex);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(record.getModifiedDate());
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion, false);
        return recordVersion;
    }

    protected String getNextVersion(String version, boolean majorVersion, int workflowAction) {
        if (workflowAction == 2) {
            majorVersion = false;
        }
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return String.valueOf(versionParts[0]) + "." + versionParts[1];
    }

    protected Fields toFields(long ddmStructureId, Map<String, Serializable> fieldsMap) {
        Fields fields = new Fields();
        for (String name : fieldsMap.keySet()) {
            String value = String.valueOf(fieldsMap.get(name));
            Field field = new Field(ddmStructureId, name, (Serializable)((Object)value));
            fields.put(field);
        }
        return fields;
    }

    protected void updateRecordVersion(User user, DDLRecordVersion recordVersion, String version, int displayIndex, int status, ServiceContext serviceContext) throws SystemException {
        recordVersion.setVersion(version);
        recordVersion.setDisplayIndex(displayIndex);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(serviceContext.getModifiedDate(null));
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion, false);
    }
}

