/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.service.base.DDLRecordServiceBaseImpl;
import com.liferay.portlet.dynamicdatalists.service.permission.DDLRecordSetPermission;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLRecordServiceImpl
extends DDLRecordServiceBaseImpl {
    public DDLRecord addRecord(long groupId, long recordSetId, int displayIndex, Fields fields, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "ADD_RECORD");
        return this.ddlRecordLocalService.addRecord(this.getGuestOrUserId(), groupId, recordSetId, displayIndex, fields, serviceContext);
    }

    public DDLRecord addRecord(long groupId, long recordSetId, int displayIndex, Map<String, Serializable> fieldsMap, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "ADD_RECORD");
        return this.ddlRecordLocalService.addRecord(this.getGuestOrUserId(), groupId, recordSetId, displayIndex, fieldsMap, serviceContext);
    }

    public DDLRecord getRecord(long recordId) throws PortalException, SystemException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordSetPermission.check(this.getPermissionChecker(), record.getRecordSetId(), "VIEW");
        return record;
    }

    public DDLRecord updateRecord(long recordId, boolean majorVersion, int displayIndex, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordSetPermission.check(this.getPermissionChecker(), record.getRecordSetId(), "UPDATE");
        return this.ddlRecordLocalService.updateRecord(this.getUserId(), recordId, majorVersion, displayIndex, fields, mergeFields, serviceContext);
    }

    public DDLRecord updateRecord(long recordId, int displayIndex, Map<String, Serializable> fieldsMap, boolean mergeFields, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecord record = this.ddlRecordLocalService.getDDLRecord(recordId);
        DDLRecordSetPermission.check(this.getPermissionChecker(), record.getRecordSetId(), "UPDATE");
        return this.ddlRecordLocalService.updateRecord(this.getUserId(), recordId, displayIndex, fieldsMap, mergeFields, serviceContext);
    }
}

