/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.templateparser.Transformer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.DDL;
import com.liferay.portlet.dynamicdatalists.util.DDLTransformer;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.util.portlet.PortletRequestUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLImpl
implements DDL {
    private Transformer _transformer = new DDLTransformer();

    public void addAllReservedEls(Element rootElement, Map<String, String> tokens, DDLRecordSet recordSet) {
        JournalUtil.addReservedEl(rootElement, tokens, "reserved_record_set_id", String.valueOf(recordSet.getRecordSetId()));
        JournalUtil.addReservedEl(rootElement, tokens, "reserved_record_set_name", recordSet.getName());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved_record_set_description", recordSet.getDescription());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved_ddm_structure_id", String.valueOf(recordSet.getDDMStructureId()));
    }

    public JSONObject getRecordJSONObject(DDLRecord record) throws Exception {
        return this.getRecordJSONObject(record, false);
    }

    public JSONObject getRecordJSONObject(DDLRecord record, boolean latestRecordVersion) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (String fieldName : ddmStructure.getFieldNames()) {
            jsonObject.put(fieldName, "");
        }
        jsonObject.put("displayIndex", record.getDisplayIndex());
        jsonObject.put("recordId", record.getRecordId());
        DDLRecordVersion recordVersion = record.getRecordVersion();
        if (latestRecordVersion) {
            recordVersion = record.getLatestRecordVersion();
        }
        Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
        for (Field field : fields) {
            String fieldName = field.getName();
            String fieldType = field.getType();
            Serializable fieldValue = field.getValue();
            if (fieldValue instanceof Date) {
                jsonObject.put(fieldName, ((Date)fieldValue).getTime());
                continue;
            }
            if (fieldType.equals("ddm-documentlibrary") && Validator.isNotNull((Object)fieldValue)) {
                JSONObject fieldValueJSONObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(fieldValue));
                String uuid = fieldValueJSONObject.getString("uuid");
                long groupId = fieldValueJSONObject.getLong("groupId");
                fieldValueJSONObject.put("title", this.getFileEntryTitle(uuid, groupId));
                jsonObject.put(fieldName, fieldValueJSONObject.toString());
                continue;
            }
            if ((fieldType.equals("radio") || fieldType.equals("select")) && Validator.isNotNull((Object)fieldValue)) {
                fieldValue = JSONFactoryUtil.createJSONArray((String)String.valueOf(fieldValue));
                jsonObject.put(fieldName, (JSONArray)fieldValue);
                continue;
            }
            jsonObject.put(fieldName, String.valueOf(fieldValue));
        }
        return jsonObject;
    }

    public JSONArray getRecordSetJSONArray(DDLRecordSet recordSet) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Map fieldsMap = ddmStructure.getFieldsMap();
        for (Map fields : fieldsMap.values()) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            String dataType = (String)fields.get("dataType");
            jsonObject.put("dataType", dataType);
            boolean editable = GetterUtil.getBoolean((String)((String)fields.get("editable")), (boolean)true);
            jsonObject.put("editable", editable);
            String label = (String)fields.get("label");
            jsonObject.put("label", label);
            String name = (String)fields.get("name");
            jsonObject.put("name", name);
            boolean required = GetterUtil.getBoolean((String)((String)fields.get("required")));
            jsonObject.put("required", required);
            boolean sortable = GetterUtil.getBoolean((String)((String)fields.get("sortable")), (boolean)true);
            jsonObject.put("sortable", sortable);
            String type = (String)fields.get("type");
            jsonObject.put("type", type);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getRecordsJSONArray(DDLRecordSet recordSet) throws Exception {
        return this.getRecordsJSONArray(recordSet.getRecords(), false);
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records, boolean latestRecordVersion) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDLRecord record : records) {
            JSONObject jsonObject = this.getRecordJSONObject(record, latestRecordVersion);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public String getTemplateContent(long ddmTemplateId, DDLRecordSet recordSet, ThemeDisplay themeDisplay, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        String viewMode = ParamUtil.getString((PortletRequest)renderRequest, (String)"viewMode");
        String languageId = LanguageUtil.getLanguageId((PortletRequest)renderRequest);
        String xmlRequest = PortletRequestUtil.toXML((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        if (Validator.isNull((String)xmlRequest)) {
            xmlRequest = "<request />";
        }
        Map<String, String> tokens = JournalUtil.getTokens(recordSet.getGroupId(), themeDisplay, xmlRequest);
        tokens.put("template_id", StringUtil.valueOf((Object)ddmTemplateId));
        String xml = "";
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        Document requestDocument = SAXReaderUtil.read((String)xmlRequest);
        rootElement.add(requestDocument.getRootElement().createCopy());
        this.addAllReservedEls(rootElement, tokens, recordSet);
        xml = DDMXMLUtil.formatXML((Document)document);
        DDMTemplate template = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
        return this._transformer.transform(themeDisplay, tokens, viewMode, languageId, xml, template.getScript(), template.getLanguage());
    }

    public void sendRecordFileUpload(HttpServletRequest request, HttpServletResponse response, DDLRecord record, String fieldName) throws Exception {
        Field field = record.getField(fieldName);
        DDMUtil.sendFieldFile((HttpServletRequest)request, (HttpServletResponse)response, (Field)field);
    }

    public void sendRecordFileUpload(HttpServletRequest request, HttpServletResponse response, long recordId, String fieldName) throws Exception {
        DDLRecord record = DDLRecordServiceUtil.getRecord((long)recordId);
        this.sendRecordFileUpload(request, response, record, fieldName);
    }

    public DDLRecord updateRecord(long recordId, long recordSetId, boolean mergeFields, boolean checkPermission, ServiceContext serviceContext) throws Exception {
        boolean majorVersion = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"majorVersion");
        DDLRecord record = DDLRecordLocalServiceUtil.fetchRecord((long)recordId);
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getDDLRecordSet((long)recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = DDMUtil.getFields((long)ddmStructure.getStructureId(), (ServiceContext)serviceContext);
        record = record != null ? (checkPermission ? DDLRecordServiceUtil.updateRecord((long)recordId, (boolean)majorVersion, (int)0, (Fields)fields, (boolean)mergeFields, (ServiceContext)serviceContext) : DDLRecordLocalServiceUtil.updateRecord((long)serviceContext.getUserId(), (long)recordId, (boolean)majorVersion, (int)0, (Fields)fields, (boolean)mergeFields, (ServiceContext)serviceContext)) : (checkPermission ? DDLRecordServiceUtil.addRecord((long)serviceContext.getScopeGroupId(), (long)recordSetId, (int)0, (Fields)fields, (ServiceContext)serviceContext) : DDLRecordLocalServiceUtil.addRecord((long)serviceContext.getUserId(), (long)serviceContext.getScopeGroupId(), (long)recordSetId, (int)0, (Fields)fields, (ServiceContext)serviceContext));
        this.uploadRecordFieldFiles(record, serviceContext);
        return record;
    }

    public DDLRecord updateRecord(long recordId, long recordSetId, boolean mergeFields, ServiceContext serviceContext) throws Exception {
        return this.updateRecord(recordId, recordSetId, mergeFields, true, serviceContext);
    }

    public String uploadRecordFieldFile(DDLRecord record, String fieldName, ServiceContext serviceContext) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        DDLRecordVersion recordVersion = record.getLatestRecordVersion();
        return DDMUtil.uploadFieldFile((long)ddmStructure.getStructureId(), (long)recordVersion.getDDMStorageId(), (BaseModel)record, (String)fieldName, (ServiceContext)serviceContext);
    }

    protected String getFileEntryTitle(String uuid, long groupId) {
        try {
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            return fileEntry.getTitle();
        }
        catch (Exception exception) {
            return LanguageUtil.format((Locale)LocaleUtil.getDefault(), (String)"is-temporarily-unavailable", (Object)"content");
        }
    }

    protected void uploadRecordFieldFiles(DDLRecord record, ServiceContext serviceContext) throws Exception {
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        for (String fieldName : ddmStructure.getFieldNames()) {
            String fieldDataType = ddmStructure.getFieldDataType(fieldName);
            if (!fieldDataType.equals("file-upload")) continue;
            this.uploadRecordFieldFile(record, fieldName, serviceContext);
        }
    }
}

