/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.action;

import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureNameException;
import com.liferay.portlet.dynamicdatamapping.action.ActionUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateServiceUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CopyStructureAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            DDMStructure structure = this.copyStructure(actionRequest);
            String redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, structure);
            String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
            if (Validator.isNotNull((String)closeRedirect)) {
                LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".closeRedirect"), (Object)closeRedirect);
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchStructureException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_mapping.error");
            }
            if (e2 instanceof StructureNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getStructure((PortletRequest)renderRequest);
        }
        catch (NoSuchStructureException noSuchStructureException) {
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.dynamic_data_mapping.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_mapping.copy_structure"));
    }

    protected DDMStructure copyStructure(ActionRequest actionRequest) throws Exception {
        long structureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"structureId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMStructure.class.getName(), (PortletRequest)actionRequest);
        DDMStructure structure = DDMStructureServiceUtil.copyStructure((long)structureId, (Map)nameMap, null, (ServiceContext)serviceContext);
        this.copyTemplates(actionRequest, structureId, structure.getStructureId());
        return structure;
    }

    protected void copyTemplates(ActionRequest actionRequest, long structureId, long newStructureId) throws Exception {
        boolean copyListTemplates;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMTemplate.class.getName(), (PortletRequest)actionRequest);
        boolean copyDetailTemplates = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"copyDetailTemplates");
        if (copyDetailTemplates) {
            DDMTemplateServiceUtil.copyTemplates((long)structureId, (long)newStructureId, (String)"detail", (ServiceContext)serviceContext);
        }
        if (copyListTemplates = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"copyListTemplates")) {
            DDMTemplateServiceUtil.copyTemplates((long)structureId, (long)newStructureId, (String)"list", (ServiceContext)serviceContext);
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, DDMStructure structure) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(actionRequest.getWindowState());
        portletURL.setParameter("struts_action", "/dynamic_data_mapping/copy_structure");
        portletURL.setParameter("structureId", String.valueOf(structure.getStructureId()), false);
        portletURL.setParameter("copyDetailTemplates", ParamUtil.getString((PortletRequest)actionRequest, (String)"copyDetailTemplates"), false);
        portletURL.setParameter("copyListTemplates", ParamUtil.getString((PortletRequest)actionRequest, (String)"copyListTemplates"), false);
        return portletURL.toString();
    }
}

