/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.ContentException;
import com.liferay.portlet.dynamicdatamapping.ContentNameException;
import com.liferay.portlet.dynamicdatamapping.ContentXmlException;
import com.liferay.portlet.dynamicdatamapping.model.DDMContent;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMContentLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDMContentLocalServiceImpl
extends DDMContentLocalServiceBaseImpl {
    public DDMContent addContent(long userId, long groupId, String name, String description, String xml, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        try {
            xml = DDMXMLUtil.formatXML((String)xml);
        }
        catch (Exception e2) {
            throw new ContentXmlException((Throwable)e2);
        }
        Date now = new Date();
        this.validate(name, xml);
        long contentId = this.counterLocalService.increment();
        DDMContent content = this.ddmContentPersistence.create(contentId);
        content.setUuid(serviceContext.getUuid());
        content.setGroupId(serviceContext.getScopeGroupId());
        content.setCompanyId(user.getCompanyId());
        content.setUserId(user.getUserId());
        content.setUserName(user.getFullName());
        content.setCreateDate(serviceContext.getCreateDate(now));
        content.setModifiedDate(serviceContext.getModifiedDate(now));
        content.setName(name);
        content.setDescription(description);
        content.setXml(xml);
        this.ddmContentPersistence.update((BaseModel)content, false);
        return content;
    }

    public void deleteContent(DDMContent content) throws SystemException {
        this.ddmContentPersistence.remove((BaseModel)content);
    }

    public void deleteContents(long groupId) throws SystemException {
        List contents = this.ddmContentPersistence.findByGroupId(groupId);
        for (DDMContent content : contents) {
            this.deleteContent(content);
        }
    }

    public DDMContent getContent(long contentId) throws PortalException, SystemException {
        return this.ddmContentPersistence.findByPrimaryKey(contentId);
    }

    public List<DDMContent> getContents() throws SystemException {
        return this.ddmContentPersistence.findAll();
    }

    public List<DDMContent> getContents(long groupId) throws SystemException {
        return this.ddmContentPersistence.findByGroupId(groupId);
    }

    public List<DDMContent> getContents(long groupId, int start, int end) throws SystemException {
        return this.ddmContentPersistence.findByGroupId(groupId, start, end);
    }

    public int getContentsCount(long groupId) throws SystemException {
        return this.ddmContentPersistence.countByGroupId(groupId);
    }

    public DDMContent updateContent(long contentId, String name, String description, String xml, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            xml = DDMXMLUtil.formatXML((String)xml);
        }
        catch (Exception exception) {
            throw new ContentXmlException();
        }
        this.validate(name, xml);
        DDMContent content = this.ddmContentPersistence.findByPrimaryKey(contentId);
        content.setModifiedDate(serviceContext.getModifiedDate(null));
        content.setName(name);
        content.setDescription(description);
        content.setXml(xml);
        this.ddmContentPersistence.update((BaseModel)content, false);
        return content;
    }

    protected void validate(String name, String xml) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new ContentNameException();
        }
        if (Validator.isNull((String)xml)) {
            throw new ContentException();
        }
        try {
            SAXReaderUtil.read((String)xml);
        }
        catch (DocumentException documentException) {
            throw new ContentException();
        }
    }
}

