/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.TemplateNameException;
import com.liferay.portlet.dynamicdatamapping.TemplateScriptException;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMTemplateLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDMTemplateLocalServiceImpl
extends DDMTemplateLocalServiceBaseImpl {
    public DDMTemplate addTemplate(long userId, long groupId, long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(nameMap, script);
        long templateId = this.counterLocalService.increment();
        DDMTemplate template = this.ddmTemplatePersistence.create(templateId);
        template.setUuid(serviceContext.getUuid());
        template.setGroupId(groupId);
        template.setCompanyId(user.getCompanyId());
        template.setUserId(user.getUserId());
        template.setUserName(user.getFullName());
        template.setCreateDate(serviceContext.getCreateDate(now));
        template.setModifiedDate(serviceContext.getModifiedDate(now));
        template.setStructureId(structureId);
        template.setNameMap(nameMap);
        template.setDescriptionMap(descriptionMap);
        template.setType(type);
        template.setMode(mode);
        template.setLanguage(language);
        template.setScript(script);
        this.ddmTemplatePersistence.update((BaseModel)template, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addTemplateResources(template, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addTemplateResources(template, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return template;
    }

    public void addTemplateResources(DDMTemplate template, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), DDMTemplate.class.getName(), template.getTemplateId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addTemplateResources(DDMTemplate template, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(template.getCompanyId(), template.getGroupId(), template.getUserId(), DDMTemplate.class.getName(), template.getTemplateId(), groupPermissions, guestPermissions);
    }

    public List<DDMTemplate> copyTemplates(long userId, long structureId, long newStructureId, String type, ServiceContext serviceContext) throws PortalException, SystemException {
        ArrayList<DDMTemplate> newTemplates = new ArrayList<DDMTemplate>();
        List<DDMTemplate> oldTemplates = this.getTemplates(structureId, type);
        for (DDMTemplate oldTemplate : oldTemplates) {
            DDMTemplate newTemplate = this.addTemplate(userId, oldTemplate.getGroupId(), newStructureId, oldTemplate.getNameMap(), oldTemplate.getDescriptionMap(), oldTemplate.getType(), oldTemplate.getMode(), oldTemplate.getLanguage(), oldTemplate.getScript(), serviceContext);
            newTemplates.add(newTemplate);
        }
        return newTemplates;
    }

    public void deleteTemplate(DDMTemplate template) throws PortalException, SystemException {
        this.ddmTemplatePersistence.remove((BaseModel)template);
        this.resourceLocalService.deleteResource(template.getCompanyId(), DDMTemplate.class.getName(), 4, template.getTemplateId());
    }

    public void deleteTemplate(long templateId) throws PortalException, SystemException {
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        this.deleteTemplate(template);
    }

    public void deleteTemplates(long groupId) throws PortalException, SystemException {
        List templates = this.ddmTemplatePersistence.findByGroupId(groupId);
        for (DDMTemplate template : templates) {
            this.deleteTemplate(template);
        }
    }

    public DDMTemplate getTemplate(long templateId) throws PortalException, SystemException {
        return this.ddmTemplatePersistence.findByPrimaryKey(templateId);
    }

    public List<DDMTemplate> getTemplates(long structureId) throws SystemException {
        return this.ddmTemplatePersistence.findByStructureId(structureId);
    }

    public List<DDMTemplate> getTemplates(long structureId, String type) throws SystemException {
        return this.ddmTemplatePersistence.findByS_T(structureId, type);
    }

    public List<DDMTemplate> getTemplates(long structureId, String type, String mode) throws SystemException {
        return this.ddmTemplatePersistence.findByS_T_M(structureId, type, mode);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long structureId, String keywords, String type, String mode, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmTemplateFinder.findByKeywords(companyId, groupId, structureId, keywords, type, mode, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long structureId, String name, String description, String type, String mode, String language, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddmTemplateFinder.findByC_G_S_N_D_T_M_L(companyId, groupId, structureId, name, description, type, mode, language, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, long structureId, String keywords, String type, String mode) throws SystemException {
        return this.ddmTemplateFinder.countByKeywords(companyId, groupId, structureId, keywords, type, mode);
    }

    public int searchCount(long companyId, long groupId, long structureId, String name, String description, String type, String mode, String language, boolean andOperator) throws SystemException {
        return this.ddmTemplateFinder.countByC_G_S_N_D_T_M_L(companyId, groupId, structureId, name, description, type, mode, language, andOperator);
    }

    public DDMTemplate updateTemplate(long templateId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException, SystemException {
        this.validate(nameMap, script);
        DDMTemplate template = this.ddmTemplateLocalService.getDDMTemplate(templateId);
        template.setModifiedDate(serviceContext.getModifiedDate(null));
        template.setNameMap(nameMap);
        template.setDescriptionMap(descriptionMap);
        template.setType(type);
        template.setMode(mode);
        template.setLanguage(language);
        template.setScript(script);
        this.ddmTemplatePersistence.update((BaseModel)template, false);
        return template;
    }

    protected void validate(Map<Locale, String> nameMap, String script) throws PortalException {
        this.validateName(nameMap);
        if (Validator.isNull((String)script)) {
            throw new TemplateScriptException();
        }
    }

    protected void validateName(Map<Locale, String> nameMap) throws PortalException {
        String name = nameMap.get(LocaleUtil.getDefault());
        if (Validator.isNull((String)name)) {
            throw new TemplateNameException();
        }
    }
}

