/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.StorageException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStorageLinkLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageAdapter;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngine;
import com.liferay.portlet.dynamicdatamapping.storage.query.Condition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageEngineImpl
implements StorageEngine {
    private StorageAdapter _defaultStorageAdapter;
    private Map<String, StorageAdapter> _storageAdapters = new HashMap<String, StorageAdapter>();

    public long create(long companyId, long ddmStructureId, Fields fields, ServiceContext serviceContext) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.create(companyId, ddmStructureId, fields, serviceContext);
    }

    public void deleteByClass(long classPK) throws StorageException {
        StorageAdapter storageAdapter = this.getClassStorageAdapter(classPK);
        storageAdapter.deleteByClass(classPK);
    }

    public void deleteByDDMStructure(long ddmStructureId) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        storageAdapter.deleteByDDMStructure(ddmStructureId);
    }

    public Fields getFields(long classPK) throws StorageException {
        return this.getFields(classPK, null);
    }

    public Fields getFields(long classPK, List<String> fieldNames) throws StorageException {
        StorageAdapter storageAdapter = this.getClassStorageAdapter(classPK);
        return storageAdapter.getFields(classPK, fieldNames);
    }

    public List<Fields> getFieldsList(long ddmStructureId, List<String> fieldNames) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.getFieldsList(ddmStructureId, fieldNames);
    }

    public List<Fields> getFieldsList(long ddmStructureId, List<String> fieldNames, OrderByComparator orderByComparator) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.getFieldsList(ddmStructureId, fieldNames, orderByComparator);
    }

    public List<Fields> getFieldsList(long ddmStructureId, long[] classPKs, List<String> fieldNames, OrderByComparator orderByComparator) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.getFieldsList(ddmStructureId, classPKs, fieldNames, orderByComparator);
    }

    public List<Fields> getFieldsList(long ddmStructureId, long[] classPKs, OrderByComparator orderByComparator) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.getFieldsList(ddmStructureId, classPKs, orderByComparator);
    }

    public Map<Long, Fields> getFieldsMap(long ddmStructureId, long[] classPKs) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.getFieldsMap(ddmStructureId, classPKs);
    }

    public Map<Long, Fields> getFieldsMap(long ddmStructureId, long[] classPKs, List<String> fieldNames) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.getFieldsMap(ddmStructureId, classPKs, fieldNames);
    }

    public List<Fields> query(long ddmStructureId, List<String> fieldNames, Condition condition, OrderByComparator orderByComparator) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.query(ddmStructureId, fieldNames, condition, orderByComparator);
    }

    public int queryCount(long ddmStructureId, Condition condition) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.queryCount(ddmStructureId, condition);
    }

    public void setDefaultStorageAdapter(StorageAdapter defaultStorageAdapter) {
        this._defaultStorageAdapter = defaultStorageAdapter;
    }

    public void setStorageAdapters(Map<String, StorageAdapter> storageAdapters) {
        this._storageAdapters = storageAdapters;
    }

    public void update(long classPK, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws StorageException {
        StorageAdapter storageAdapter = this.getClassStorageAdapter(classPK);
        storageAdapter.update(classPK, fields, mergeFields, serviceContext);
    }

    public void update(long classPK, Fields fields, ServiceContext serviceContext) throws StorageException {
        StorageAdapter storageAdapter = this.getClassStorageAdapter(classPK);
        storageAdapter.update(classPK, fields, serviceContext);
    }

    protected StorageAdapter getClassStorageAdapter(long classPK) throws StorageException {
        try {
            DDMStorageLink ddmStorageLink = DDMStorageLinkLocalServiceUtil.getClassStorageLink((long)classPK);
            return this.getStorageAdapter(ddmStorageLink.getStorageType());
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new StorageException((Throwable)e2);
        }
    }

    protected StorageAdapter getStorageAdapter(String storageType) {
        StorageAdapter storageAdapter = this._storageAdapters.get(storageType);
        if (storageAdapter == null) {
            storageAdapter = this._defaultStorageAdapter;
        }
        return storageAdapter;
    }

    protected StorageAdapter getStructureStorageAdapter(long ddmStructureId) throws StorageException {
        try {
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)ddmStructureId);
            return this.getStorageAdapter(ddmStructure.getStorageType());
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new StorageException((Throwable)e2);
        }
    }
}

