/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.BaseFieldRenderer;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import java.util.Locale;
import java.util.Map;

public class StringFieldRenderer
extends BaseFieldRenderer {
    protected String doRender(Field field, Locale locale) throws Exception {
        String value = String.valueOf(field.getValue());
        if (Validator.isNull((String)value)) {
            return "";
        }
        DDMStructure ddmStructure = field.getDDMStructure();
        String fieldType = ddmStructure.getFieldType(field.getName());
        if (!fieldType.equals("radio") && !fieldType.equals("select")) {
            return value;
        }
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray((String)value);
        StringBundler sb = new StringBundler(valuesJSONArray.length() * 2);
        int i2 = 0;
        while (i2 < valuesJSONArray.length()) {
            Map fieldsMap = ddmStructure.getFields(field.getName(), "value", valuesJSONArray.getString(i2), LocaleUtil.toLanguageId((Locale)locale));
            if (fieldsMap != null) {
                sb.append((String)fieldsMap.get("label"));
                if (i2 + 1 < valuesJSONArray.length()) {
                    sb.append(", ");
                }
            }
            ++i2;
        }
        return sb.toString();
    }
}

