/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.upload.UploadRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadataModel;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordModel;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.FieldConstants;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDM;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDMImpl
implements DDM {
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_DDM_DOCUMENTLIBRARY = "ddm-documentlibrary";
    public static final String TYPE_DDM_FILEUPLOAD = "ddm-fileupload";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_SELECT = "select";

    public Fields getFields(long ddmStructureId, long ddmTemplateId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.getFields(ddmStructureId, ddmTemplateId, "", serviceContext);
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, String fieldNamespace, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        try {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
            ddmStructure.setXsd(ddmTemplate.getScript());
        }
        catch (NoSuchTemplateException noSuchTemplateException) {}
        Set fieldNames = ddmStructure.getFieldNames();
        Fields fields = new Fields();
        for (String fieldName : fieldNames) {
            Field field = new Field();
            field.setName(fieldName);
            String fieldDataType = ddmStructure.getFieldDataType(fieldName);
            String fieldType = ddmStructure.getFieldType(fieldName);
            Object fieldValue = serviceContext.getAttribute(String.valueOf(fieldNamespace) + fieldName);
            if (fieldDataType.equals("date")) {
                int fieldValueMonth = GetterUtil.getInteger((Object)serviceContext.getAttribute(String.valueOf(fieldNamespace) + fieldName + "Month"));
                int fieldValueYear = GetterUtil.getInteger((Object)serviceContext.getAttribute(String.valueOf(fieldNamespace) + fieldName + "Year"));
                int fieldValueDay = GetterUtil.getInteger((Object)serviceContext.getAttribute(String.valueOf(fieldNamespace) + fieldName + "Day"));
                Date fieldValueDate = PortalUtil.getDate((int)fieldValueMonth, (int)fieldValueDay, (int)fieldValueYear);
                if (fieldValueDate != null) {
                    fieldValue = String.valueOf(fieldValueDate.getTime());
                }
            }
            if (fieldValue == null || fieldDataType.equals("file-upload")) continue;
            if (fieldType.equals(TYPE_RADIO) || fieldType.equals(TYPE_SELECT)) {
                if (fieldValue instanceof String) {
                    fieldValue = new String[]{String.valueOf(fieldValue)};
                }
                fieldValue = JSONFactoryUtil.serialize((Object)fieldValue);
            }
            Serializable fieldValueSerializable = FieldConstants.getSerializable((String)fieldDataType, (String)GetterUtil.getString((Object)fieldValue));
            field.setValue(fieldValueSerializable);
            fields.put(field);
        }
        return fields;
    }

    public Fields getFields(long ddmStructureId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.getFields(ddmStructureId, 0L, serviceContext);
    }

    public Fields getFields(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.getFields(ddmStructureId, 0L, fieldNamespace, serviceContext);
    }

    public String getFileUploadPath(BaseModel<?> baseModel) {
        StringBundler sb = new StringBundler(7);
        try {
            long primaryKey = 0L;
            String version = "";
            if (baseModel instanceof DDLRecordModel) {
                DDLRecord record = (DDLRecord)baseModel;
                primaryKey = record.getPrimaryKey();
                DDLRecordVersion recordVersion = record.getLatestRecordVersion();
                version = recordVersion.getVersion();
            } else if (baseModel instanceof DLFileEntryMetadataModel) {
                DLFileEntryMetadata fileEntryMetadata = (DLFileEntryMetadata)baseModel;
                primaryKey = fileEntryMetadata.getPrimaryKey();
                DLFileVersion fileVersion = fileEntryMetadata.getFileVersion();
                version = fileVersion.getVersion();
            }
            sb.append("ddm");
            sb.append("/");
            sb.append(baseModel.getModelClassName());
            sb.append("/");
            sb.append(primaryKey);
            sb.append("/");
            sb.append(version);
        }
        catch (Exception exception) {}
        return sb.toString();
    }

    public void sendFieldFile(HttpServletRequest request, HttpServletResponse response, Field field) throws Exception {
        if (field == null) {
            return;
        }
        DDMStructure structure = field.getDDMStructure();
        Serializable fieldValue = field.getValue();
        JSONObject fileJSONObject = JSONFactoryUtil.createJSONObject((String)String.valueOf(fieldValue));
        String fileName = fileJSONObject.getString("name");
        String filePath = fileJSONObject.getString("path");
        InputStream is = DLStoreUtil.getFileAsStream((long)structure.getCompanyId(), (long)0L, (String)filePath);
        long contentLength = DLStoreUtil.getFileSize((long)structure.getCompanyId(), (long)0L, (String)filePath);
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (long)contentLength, (String)contentType);
    }

    public String uploadFieldFile(long structureId, long storageId, BaseModel<?> baseModel, String fieldName, ServiceContext serviceContext) throws Exception {
        return this.uploadFieldFile(structureId, storageId, baseModel, fieldName, "", serviceContext);
    }

    public String uploadFieldFile(long structureId, long storageId, BaseModel<?> baseModel, String fieldName, String fieldNamespace, ServiceContext serviceContext) throws Exception {
        Fields fields;
        InputStream inputStream;
        String fieldValue;
        block5: {
            HttpServletRequest request = serviceContext.getRequest();
            if (!(request instanceof UploadRequest)) {
                return "";
            }
            UploadRequest uploadRequest = (UploadRequest)request;
            String fileName = uploadRequest.getFileName(String.valueOf(fieldNamespace) + fieldName);
            fieldValue = "";
            inputStream = null;
            fields = StorageEngineUtil.getFields((long)storageId);
            try {
                inputStream = uploadRequest.getFileAsStream(String.valueOf(fieldNamespace) + fieldName, true);
                if (inputStream != null) {
                    String filePath = this.storeFieldFile(baseModel, fieldName, inputStream, serviceContext);
                    JSONObject recordFileJSONObject = JSONFactoryUtil.createJSONObject();
                    recordFileJSONObject.put("name", fileName);
                    recordFileJSONObject.put("path", filePath);
                    recordFileJSONObject.put("className", baseModel.getModelClassName());
                    recordFileJSONObject.put("classPK", String.valueOf(baseModel.getPrimaryKeyObj()));
                    fieldValue = recordFileJSONObject.toString();
                    break block5;
                }
                if (!fields.contains(fieldName)) break block5;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                throw throwable;
            }
            StreamUtil.cleanUp((InputStream)inputStream);
            return "";
        }
        Field field = new Field(structureId, fieldName, (Serializable)((Object)fieldValue));
        fields.put(field);
        StorageEngineUtil.update((long)storageId, (Fields)fields, (boolean)true, (ServiceContext)serviceContext);
        StreamUtil.cleanUp((InputStream)inputStream);
        return fieldValue;
    }

    protected String storeFieldFile(BaseModel<?> baseModel, String fieldName, InputStream inputStream, ServiceContext serviceContext) throws Exception {
        String dirName = this.getFileUploadPath(baseModel);
        try {
            DLStoreUtil.addDirectory((long)serviceContext.getCompanyId(), (long)0L, (String)dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        String fileName = String.valueOf(dirName) + "/" + fieldName;
        try {
            DLStoreUtil.addFile((long)serviceContext.getCompanyId(), (long)0L, (String)fileName, (InputStream)inputStream);
        }
        catch (DuplicateFileException duplicateFileException) {}
        return fileName;
    }
}

