/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexer;
import java.io.Serializable;
import java.util.Date;

public class DDMIndexerImpl
implements DDMIndexer {
    private static final String _FIELD_NAMESPACE = "ddm";

    public void addAttributes(Document document, DDMStructure ddmStructure, Fields fields) {
        for (Field field : fields) {
            String name = this.encodeName(ddmStructure.getStructureId(), field.getName());
            Serializable value = field.getValue();
            if (value instanceof Boolean) {
                document.addKeyword(name, (Boolean)value);
                continue;
            }
            if (value instanceof Date) {
                document.addDate(name, (Date)value);
                continue;
            }
            if (value instanceof Double) {
                document.addKeyword(name, (Double)value);
                continue;
            }
            if (value instanceof Integer) {
                document.addKeyword(name, (Integer)value);
                continue;
            }
            String valueString = String.valueOf(value);
            document.addText(name, valueString);
        }
    }

    public String encodeName(long ddmStructureId, String fieldName) {
        StringBundler sb = new StringBundler(5);
        sb.append(_FIELD_NAMESPACE);
        sb.append("/");
        sb.append(ddmStructureId);
        sb.append("/");
        sb.append(fieldName);
        return sb.toString();
    }
}

