/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXML;
import com.liferay.util.xml.XMLFormatter;
import java.io.IOException;
import java.util.Locale;

public class DDMXMLImpl
implements DDMXML {
    private static final String _AVAILABLE_LOCALES = "available-locales";
    private static final String _DEFAULT_LOCALE = "default-locale";
    private static final String _DYNAMIC_ELEMENT = "dynamic-element";
    private static final String _LOCALE = "locale";
    private static final String _XML_INDENT = "  ";

    public String formatXML(Document document) throws IOException {
        return document.formattedString(_XML_INDENT);
    }

    public String formatXML(String xml) throws DocumentException, IOException {
        xml = StringUtil.replace((String)xml, (String)"&#", (String)"[$SPECIAL_CHARACTER$]");
        try {
            xml = XMLFormatter.toString((String)xml, (String)_XML_INDENT);
        }
        catch (org.dom4j.DocumentException de) {
            throw new DocumentException(de.getMessage());
        }
        xml = StringUtil.replace((String)xml, (String)"[$SPECIAL_CHARACTER$]", (String)"&#");
        return xml;
    }

    public String updateXMLDefaultLocale(String xml, Locale contentDefaultLocale, Locale contentNewDefaultLocale) throws DocumentException, IOException {
        if (LocaleUtil.equals((Locale)contentDefaultLocale, (Locale)contentNewDefaultLocale)) {
            return xml;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        Attribute availableLocalesAttribute = rootElement.attribute(_AVAILABLE_LOCALES);
        String contentNewDefaultLanguageId = LocaleUtil.toLanguageId((Locale)contentNewDefaultLocale);
        String availableLocalesAttributeValue = availableLocalesAttribute.getValue();
        if (!availableLocalesAttributeValue.contains(contentNewDefaultLanguageId)) {
            StringBundler sb = new StringBundler(3);
            sb.append(availableLocalesAttribute.getValue());
            sb.append(",");
            sb.append(contentNewDefaultLanguageId);
            availableLocalesAttribute.setValue(sb.toString());
        }
        Attribute defaultLocaleAttribute = rootElement.attribute(_DEFAULT_LOCALE);
        defaultLocaleAttribute.setValue(contentNewDefaultLanguageId);
        this.fixElementsDefaultLocale(rootElement, contentDefaultLocale, contentNewDefaultLocale);
        return document.formattedString();
    }

    protected void fixElementsDefaultLocale(Element element, Locale contentDefaultLocale, Locale contentNewDefaultLocale) {
        for (Element dynamicElementElement : element.elements(_DYNAMIC_ELEMENT)) {
            Element importMetaDataElement = (Element)dynamicElementElement.selectSingleNode("meta-data[@locale='" + contentNewDefaultLocale.toString() + "']");
            if (importMetaDataElement == null) {
                Element metaDataElement = (Element)dynamicElementElement.selectSingleNode("meta-data[@locale='" + contentDefaultLocale.toString() + "']");
                Element copiedMetadataElement = metaDataElement.createCopy();
                Attribute localeAttribute = copiedMetadataElement.attribute(_LOCALE);
                String contentNewDefaultLanguageId = LocaleUtil.toLanguageId((Locale)contentNewDefaultLocale);
                localeAttribute.setValue(contentNewDefaultLanguageId);
                dynamicElementElement.add(copiedMetadataElement);
            }
            this.fixElementsDefaultLocale(dynamicElementElement, contentDefaultLocale, contentNewDefaultLocale);
        }
    }
}

