/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.freemarker.FreeMarkerContext;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngineUtil;
import com.liferay.portal.kernel.freemarker.FreeMarkerVariablesUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMXSD;
import com.liferay.util.freemarker.FreeMarkerTaglibFactoryUtil;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDMXSDImpl
implements DDMXSD {
    private static final String _DEFAULT_NAMESPACE = "alloy";
    private static final String _DEFAULT_READ_ONLY_NAMESPACE = "readonly";
    private static final String _TPL_DEFAULT_PATH = "com/liferay/portlet/dynamicdatamapping/dependencies/alloy/text.ftl";
    private static final String _TPL_DEFAULT_READ_ONLY_PATH = "com/liferay/portlet/dynamicdatamapping/dependencies/readonly/default.ftl";
    private static final String _TPL_EXT = ".ftl";
    private static final String _TPL_PATH = "com/liferay/portlet/dynamicdatamapping/dependencies/";

    public String getHTML(PageContext pageContext, DDMStructure ddmStructure, Fields fields, String namespace, boolean readOnly, Locale locale) throws Exception {
        return this.getHTML(pageContext, ddmStructure.getXsd(), fields, namespace, readOnly, locale);
    }

    public String getHTML(PageContext pageContext, DDMTemplate ddmTemplate, Fields fields, String namespace, boolean readOnly, Locale locale) throws Exception {
        return this.getHTML(pageContext, ddmTemplate.getScript(), fields, namespace, ddmTemplate.getMode(), readOnly, locale);
    }

    public String getHTML(PageContext pageContext, Element element, Fields fields, Locale locale) throws Exception {
        return this.getHTML(pageContext, element, fields, "", null, false, locale);
    }

    public String getHTML(PageContext pageContext, Element element, Fields fields, String namespace, String mode, boolean readOnly, Locale locale) throws Exception {
        StringBundler sb = new StringBundler();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String portletId = PortalUtil.getPortletId((HttpServletRequest)request);
        String portletNamespace = PortalUtil.getPortletNamespace((String)portletId);
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            FreeMarkerContext freeMarkerContext = this.getFreeMarkerContext(dynamicElementElement, locale);
            freeMarkerContext.put("portletNamespace", (Object)portletNamespace);
            freeMarkerContext.put("namespace", (Object)namespace);
            if (fields != null) {
                freeMarkerContext.put("fields", (Object)fields);
            }
            Map field = (Map)freeMarkerContext.get("fieldStructure");
            String childrenHTML = this.getHTML(pageContext, dynamicElementElement, fields, namespace, mode, readOnly, locale);
            field.put("children", childrenHTML);
            String fieldNamespace = dynamicElementElement.attributeValue("fieldNamespace", _DEFAULT_NAMESPACE);
            String defaultResourcePath = _TPL_DEFAULT_PATH;
            boolean fieldReadOnly = GetterUtil.getBoolean(field.get("readOnly"));
            if (fieldReadOnly && Validator.isNotNull((String)mode) && mode.equalsIgnoreCase("edit") || readOnly) {
                fieldNamespace = _DEFAULT_READ_ONLY_NAMESPACE;
                defaultResourcePath = _TPL_DEFAULT_READ_ONLY_PATH;
            }
            String type = dynamicElementElement.attributeValue("type");
            String templateName = StringUtil.replaceFirst((String)type, (String)fieldNamespace.concat("-"), (String)"");
            StringBundler resourcePath = new StringBundler(5);
            resourcePath.append(_TPL_PATH);
            resourcePath.append(fieldNamespace.toLowerCase());
            resourcePath.append('/');
            resourcePath.append(templateName);
            resourcePath.append(_TPL_EXT);
            sb.append(this.processFTL(pageContext, freeMarkerContext, resourcePath.toString(), defaultResourcePath));
        }
        return sb.toString();
    }

    public String getHTML(PageContext pageContext, Element element, Locale locale) throws Exception {
        return this.getHTML(pageContext, element, null, locale);
    }

    public String getHTML(PageContext pageContext, String xml, Fields fields, Locale locale) throws Exception {
        return this.getHTML(pageContext, xml, fields, "", locale);
    }

    public String getHTML(PageContext pageContext, String xml, Fields fields, String namespace, boolean readOnly, Locale locale) throws Exception {
        return this.getHTML(pageContext, xml, fields, namespace, null, readOnly, locale);
    }

    public String getHTML(PageContext pageContext, String xml, Fields fields, String namespace, Locale locale) throws Exception {
        return this.getHTML(pageContext, xml, fields, namespace, false, locale);
    }

    public String getHTML(PageContext pageContext, String xml, Fields fields, String namespace, String mode, boolean readOnly, Locale locale) throws Exception {
        Document document = SAXReaderUtil.read((String)xml);
        return this.getHTML(pageContext, document.getRootElement(), fields, namespace, mode, readOnly, locale);
    }

    public String getHTML(PageContext pageContext, String xml, Locale locale) throws Exception {
        return this.getHTML(pageContext, xml, null, locale);
    }

    public JSONArray getJSONArray(Document document) throws JSONException {
        return this.getJSONArray(document.getRootElement());
    }

    public JSONArray getJSONArray(Element element) throws JSONException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Document document = element.getDocument();
        String defaultLocale = LocalizationUtil.getDefaultLocale((String)document.asXML());
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            JSONObject localizationMapJSONObject = JSONFactoryUtil.createJSONObject();
            for (Attribute attribute : dynamicElementElement.attributes()) {
                jsonObject.put(attribute.getName(), attribute.getValue());
            }
            jsonObject.put("id", dynamicElementElement.attributeValue("name"));
            String type = jsonObject.getString("type");
            List metadataElements = dynamicElementElement.elements("meta-data");
            for (Element metadataElement : metadataElements) {
                if (metadataElement == null) continue;
                String locale = metadataElement.attributeValue("locale");
                JSONObject localeMap = JSONFactoryUtil.createJSONObject();
                for (Element metadataEntryElement : metadataElement.elements()) {
                    String attributeName = metadataEntryElement.attributeValue("name");
                    String attributeValue = metadataEntryElement.getText();
                    this.putMetadataValue(localeMap, attributeName, attributeValue, type);
                    if (!defaultLocale.equals(locale)) continue;
                    this.putMetadataValue(jsonObject, attributeName, attributeValue, type);
                }
                localizationMapJSONObject.put(locale, localeMap);
            }
            jsonObject.put("localizationMap", localizationMapJSONObject);
            JSONArray hiddenAttributesJSONArray = JSONFactoryUtil.createJSONArray();
            if (type.equals("checkbox")) {
                hiddenAttributesJSONArray.put("required");
            }
            if (type.equals("ddm-fileupload")) {
                hiddenAttributesJSONArray.put("predefinedValue");
            }
            hiddenAttributesJSONArray.put("readOnly");
            jsonObject.put("hiddenAttributes", hiddenAttributesJSONArray);
            String key = "fields";
            if (type.equals("radio") || type.equals("select")) {
                key = "options";
            }
            jsonObject.put(key, this.getJSONArray(dynamicElementElement));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getJSONArray(String xml) throws DocumentException, JSONException {
        return this.getJSONArray(SAXReaderUtil.read((String)xml));
    }

    protected Map<String, Object> getFieldContext(Element dynamicElementElement, Locale locale) {
        Document document = dynamicElementElement.getDocument();
        Object[] availableLocales = LocalizationUtil.getAvailableLocales((String)document.asXML());
        String defaultLanguageId = LocalizationUtil.getDefaultLocale((String)document.asXML());
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        if (!ArrayUtil.contains((Object[])availableLocales, (Object)languageId)) {
            languageId = defaultLanguageId;
        }
        Element metadataElement = (Element)dynamicElementElement.selectSingleNode("meta-data[@locale='" + languageId + "']");
        HashMap<String, Object> field = new HashMap<String, Object>();
        if (metadataElement != null) {
            for (Element metadataEntry : metadataElement.elements()) {
                field.put(metadataEntry.attributeValue("name"), metadataEntry.getText());
            }
        }
        for (Attribute attribute : dynamicElementElement.attributes()) {
            field.put(attribute.getName(), attribute.getValue());
        }
        return field;
    }

    protected FreeMarkerContext getFreeMarkerContext(Element dynamicElementElement, Locale locale) {
        FreeMarkerContext freeMarkerContext = FreeMarkerEngineUtil.getWrappedStandardToolsContext();
        Map<String, Object> fieldContext = this.getFieldContext(dynamicElementElement, locale);
        Map<Object, Object> parentFieldContext = new HashMap();
        Element parentElement = dynamicElementElement.getParent();
        if (parentElement != null) {
            parentFieldContext = this.getFieldContext(parentElement, locale);
        }
        freeMarkerContext.put("fieldStructure", fieldContext);
        freeMarkerContext.put("parentFieldStructure", parentFieldContext);
        return freeMarkerContext;
    }

    protected String processFTL(PageContext pageContext, FreeMarkerContext freeMarkerContext, String resourcePath, String defaultResourcePath) throws Exception {
        if (!FreeMarkerEngineUtil.resourceExists((String)resourcePath)) {
            resourcePath = defaultResourcePath;
        }
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        FreeMarkerVariablesUtil.insertVariables((FreeMarkerContext)freeMarkerContext, (HttpServletRequest)request);
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        UnsyncStringWriter writer = new UnsyncStringWriter();
        TemplateHashModel portalTaglib = FreeMarkerTaglibFactoryUtil.createTaglibFactory((ServletContext)pageContext.getServletContext());
        freeMarkerContext.put("PortalJspTagLibs", (Object)portalTaglib);
        final Servlet servlet = (Servlet)pageContext.getPage();
        GenericServlet genericServlet = null;
        if (servlet instanceof GenericServlet) {
            genericServlet = (GenericServlet)servlet;
        } else {
            genericServlet = new GenericServlet(){

                public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                    servlet.service(servletRequest, servletResponse);
                }
            };
            genericServlet.init(pageContext.getServletConfig());
        }
        ServletContextHashModel servletContextHashModel = new ServletContextHashModel(genericServlet, ObjectWrapper.DEFAULT_WRAPPER);
        freeMarkerContext.put("Application", (Object)servletContextHashModel);
        HttpRequestHashModel httpRequestHashModel = new HttpRequestHashModel(request, response, ObjectWrapper.DEFAULT_WRAPPER);
        freeMarkerContext.put("Request", (Object)httpRequestHashModel);
        FreeMarkerEngineUtil.mergeTemplate((String)resourcePath, (FreeMarkerContext)freeMarkerContext, (Writer)writer);
        return writer.toString();
    }

    protected void putMetadataValue(JSONObject jsonObject, String attributeName, String attributeValue, String type) {
        if ((type.equals("radio") || type.equals("select")) && attributeName.equals("predefinedValue")) {
            try {
                jsonObject.put(attributeName, JSONFactoryUtil.createJSONArray((String)attributeValue));
            }
            catch (Exception exception) {}
            return;
        }
        jsonObject.put(attributeName, attributeValue);
    }
}

