/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoColumnServiceUtil;
import com.liferay.portlet.expando.service.ExpandoTableLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoBridgeImpl
implements ExpandoBridge {
    private static Log _log = LogFactoryUtil.getLog(ExpandoBridgeImpl.class);
    private String _className;
    private long _classPK;
    private long _companyId;
    private boolean _indexEnabled;

    public ExpandoBridgeImpl(long companyId, String className) {
        this(companyId, className, 0L);
    }

    public ExpandoBridgeImpl(long companyId, String className, long classPK) {
        this._companyId = companyId;
        if (this._companyId == 0L) {
            this._companyId = CompanyThreadLocal.getCompanyId();
        }
        this._className = className;
        this._classPK = classPK;
        if (IndexerRegistryUtil.getIndexer((String)className) == null) {
            this.setIndexEnabled(true);
        }
    }

    public void addAttribute(String name) throws PortalException {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.addAttribute(name, 15, null, secure);
    }

    public void addAttribute(String name, boolean secure) throws PortalException {
        this.addAttribute(name, 15, null, secure);
    }

    public void addAttribute(String name, int type) throws PortalException {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.addAttribute(name, type, null, secure);
    }

    public void addAttribute(String name, int type, boolean secure) throws PortalException {
        this.addAttribute(name, type, null, secure);
    }

    public void addAttribute(String name, int type, Serializable defaultValue) throws PortalException {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.addAttribute(name, type, defaultValue, secure);
    }

    public void addAttribute(String name, int type, Serializable defaultValue, boolean secure) throws PortalException {
        try {
            ExpandoTable table = ExpandoTableLocalServiceUtil.fetchDefaultTable((long)this._companyId, (String)this._className);
            if (table == null) {
                table = ExpandoTableLocalServiceUtil.addDefaultTable((long)this._companyId, (String)this._className);
            }
            if (secure) {
                ExpandoColumnServiceUtil.addColumn((long)table.getTableId(), (String)name, (int)type, (Object)defaultValue);
            } else {
                ExpandoColumnLocalServiceUtil.addColumn((long)table.getTableId(), (String)name, (int)type, (Object)defaultValue);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof PortalException) {
                throw (PortalException)((Object)e2);
            }
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public Serializable getAttribute(String name) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_READ_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isExportInProcess()) {
            secure = false;
        }
        return this.getAttribute(name, secure);
    }

    public Serializable getAttribute(String name, boolean secure) {
        Serializable data;
        block2: {
            data = null;
            try {
                data = secure ? ExpandoValueServiceUtil.getData((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (String)name, (long)this._classPK) : ExpandoValueLocalServiceUtil.getData((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (String)name, (long)this._classPK);
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e2, (Throwable)e2);
            }
        }
        return data;
    }

    public Serializable getAttributeDefault(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            return column.getDefaultValue();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    public Enumeration<String> getAttributeNames() {
        List columns;
        block3: {
            columns = new ArrayList();
            try {
                columns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((long)this._companyId, (String)this._className);
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e2, (Throwable)e2);
            }
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ExpandoColumn column : columns) {
            columnNames.add(column.getName());
        }
        return Collections.enumeration(columnNames);
    }

    public UnicodeProperties getAttributeProperties(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            return column.getTypeSettingsProperties();
        }
        catch (Exception e2) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Properties for " + name), (Throwable)e2);
            }
            return new UnicodeProperties(true);
        }
    }

    public Map<String, Serializable> getAttributes() {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_READ_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isExportInProcess()) {
            secure = false;
        }
        return this.getAttributes(secure);
    }

    public Map<String, Serializable> getAttributes(boolean secure) {
        List columns;
        HashMap<String, Serializable> attributes;
        block3: {
            attributes = new HashMap<String, Serializable>();
            columns = new ArrayList();
            try {
                columns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((long)this._companyId, (String)this._className);
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e2, (Throwable)e2);
            }
        }
        for (ExpandoColumn column : columns) {
            attributes.put(column.getName(), this.getAttribute(column.getName(), secure));
        }
        return attributes;
    }

    public Map<String, Serializable> getAttributes(Collection<String> names) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_READ_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isExportInProcess()) {
            secure = false;
        }
        return this.getAttributes(names, secure);
    }

    public Map<String, Serializable> getAttributes(Collection<String> names, boolean secure) {
        Map attributeValues;
        block2: {
            attributeValues = null;
            try {
                attributeValues = secure ? ExpandoValueServiceUtil.getData((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", names, (long)this._classPK) : ExpandoValueLocalServiceUtil.getData((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", names, (long)this._classPK);
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e2, (Throwable)e2);
            }
        }
        return attributeValues;
    }

    public int getAttributeType(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            return column.getType();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return 0;
        }
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public boolean hasAttribute(String name) {
        ExpandoColumn column = null;
        try {
            column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
        }
        catch (Exception exception) {}
        return column != null;
    }

    public boolean isIndexEnabled() {
        return this._indexEnabled && this._classPK > 0L;
    }

    public void reindex() {
        if (!this.isIndexEnabled()) {
            return;
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)this._className);
        if (indexer != null) {
            try {
                indexer.reindex(this._className, this._classPK);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }

    public void setAttribute(String name, Serializable value) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.setAttribute(name, value, secure);
    }

    public void setAttribute(String name, Serializable value, boolean secure) {
        if (this._classPK <= 0L) {
            throw new UnsupportedOperationException("Class primary key is less than 0");
        }
        try {
            if (secure) {
                ExpandoValueServiceUtil.addValue((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (String)name, (long)this._classPK, (Object)value);
            } else {
                ExpandoValueLocalServiceUtil.addValue((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (String)name, (long)this._classPK, (Object)value);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void setAttributeDefault(String name, Serializable defaultValue) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            ExpandoColumnServiceUtil.updateColumn((long)column.getColumnId(), (String)column.getName(), (int)column.getType(), (Object)defaultValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void setAttributeProperties(String name, UnicodeProperties properties) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.setAttributeProperties(name, properties, secure);
    }

    public void setAttributeProperties(String name, UnicodeProperties properties, boolean secure) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((long)this._companyId, (String)this._className, (String)name);
            if (secure) {
                ExpandoColumnServiceUtil.updateTypeSettings((long)column.getColumnId(), (String)properties.toString());
            } else {
                ExpandoColumnLocalServiceUtil.updateTypeSettings((long)column.getColumnId(), (String)properties.toString());
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.setAttributes(attributes, secure);
    }

    public void setAttributes(Map<String, Serializable> attributes, boolean secure) {
        if (this._classPK <= 0L) {
            throw new UnsupportedOperationException("Class primary key is less than 0");
        }
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        try {
            if (secure) {
                ExpandoValueServiceUtil.addValues((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (long)this._classPK, attributes);
            } else {
                ExpandoValueLocalServiceUtil.addValues((long)this._companyId, (String)this._className, (String)"CUSTOM_FIELDS", (long)this._classPK, attributes);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void setAttributes(ServiceContext serviceContext) {
        boolean secure = PropsValues.PERMISSIONS_CUSTOM_ATTRIBUTE_WRITE_CHECK_BY_DEFAULT;
        if (ImportExportThreadLocal.isImportInProcess()) {
            secure = false;
        }
        this.setAttributes(serviceContext, secure);
    }

    public void setAttributes(ServiceContext serviceContext, boolean secure) {
        if (serviceContext == null) {
            return;
        }
        this.setAttributes(serviceContext.getExpandoBridgeAttributes(), secure);
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setIndexEnabled(boolean indexEnabled) {
        this._indexEnabled = indexEnabled;
    }
}

