/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.expando.ValueDataException;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoColumnConstants;
import com.liferay.portlet.expando.model.impl.ExpandoValueBaseImpl;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import java.io.Serializable;
import java.util.Date;

public class ExpandoValueImpl
extends ExpandoValueBaseImpl {
    private static final String _EXPANDO_COMMA = "[$LIFERAY_EXPANDO_COMMA$]";
    private transient ExpandoColumn _column;

    public boolean getBoolean() throws PortalException, SystemException {
        this.validate(1);
        return GetterUtil.getBoolean((String)this.getData());
    }

    public boolean[] getBooleanArray() throws PortalException, SystemException {
        this.validate(2);
        return GetterUtil.getBooleanValues((String[])StringUtil.split((String)this.getData()));
    }

    public ExpandoColumn getColumn() throws PortalException, SystemException {
        if (this._column != null) {
            return this._column;
        }
        long columnId = this.getColumnId();
        if (columnId <= 0L) {
            return null;
        }
        return ExpandoColumnLocalServiceUtil.getColumn((long)columnId);
    }

    public Date getDate() throws PortalException, SystemException {
        this.validate(3);
        return new Date(GetterUtil.getLong((String)this.getData()));
    }

    public Date[] getDateArray() throws PortalException, SystemException {
        this.validate(4);
        String[] data = StringUtil.split((String)this.getData());
        Date[] dateArray = new Date[data.length];
        int i2 = 0;
        while (i2 < data.length) {
            dateArray[i2] = new Date(GetterUtil.getLong((String)data[i2]));
            ++i2;
        }
        return dateArray;
    }

    public double getDouble() throws PortalException, SystemException {
        this.validate(5);
        return GetterUtil.getDouble((String)this.getData());
    }

    public double[] getDoubleArray() throws PortalException, SystemException {
        this.validate(6);
        return GetterUtil.getDoubleValues((String[])StringUtil.split((String)this.getData()));
    }

    public float getFloat() throws PortalException, SystemException {
        this.validate(7);
        return GetterUtil.getFloat((String)this.getData());
    }

    public float[] getFloatArray() throws PortalException, SystemException {
        this.validate(8);
        return GetterUtil.getFloatValues((String[])StringUtil.split((String)this.getData()));
    }

    public int getInteger() throws PortalException, SystemException {
        this.validate(9);
        return GetterUtil.getInteger((String)this.getData());
    }

    public int[] getIntegerArray() throws PortalException, SystemException {
        this.validate(10);
        return GetterUtil.getIntegerValues((String[])StringUtil.split((String)this.getData()));
    }

    public long getLong() throws PortalException, SystemException {
        this.validate(11);
        return GetterUtil.getLong((String)this.getData());
    }

    public long[] getLongArray() throws PortalException, SystemException {
        this.validate(12);
        return GetterUtil.getLongValues((String[])StringUtil.split((String)this.getData()));
    }

    public Number getNumber() throws PortalException, SystemException {
        this.validate(17);
        return GetterUtil.getNumber((String)this.getData());
    }

    public Number[] getNumberArray() throws PortalException, SystemException {
        this.validate(18);
        return GetterUtil.getNumberValues((String[])StringUtil.split((String)this.getData()));
    }

    public Serializable getSerializable() throws PortalException, SystemException {
        ExpandoColumn column = this.getColumn();
        int type = column.getType();
        if (type == 1) {
            return Boolean.valueOf(this.getBoolean());
        }
        if (type == 2) {
            return this.getBooleanArray();
        }
        if (type == 3) {
            return this.getDate();
        }
        if (type == 4) {
            return this.getDateArray();
        }
        if (type == 5) {
            return Double.valueOf(this.getDouble());
        }
        if (type == 6) {
            return this.getDoubleArray();
        }
        if (type == 7) {
            return Float.valueOf(this.getFloat());
        }
        if (type == 8) {
            return this.getFloatArray();
        }
        if (type == 9) {
            return Integer.valueOf(this.getInteger());
        }
        if (type == 10) {
            return this.getIntegerArray();
        }
        if (type == 11) {
            return Long.valueOf(this.getLong());
        }
        if (type == 12) {
            return this.getLongArray();
        }
        if (type == 17) {
            return this.getNumber();
        }
        if (type == 18) {
            return this.getNumberArray();
        }
        if (type == 13) {
            return Short.valueOf(this.getShort());
        }
        if (type == 14) {
            return this.getShortArray();
        }
        if (type == 16) {
            return this.getStringArray();
        }
        return this.getData();
    }

    public short getShort() throws PortalException, SystemException {
        this.validate(13);
        return GetterUtil.getShort((String)this.getData());
    }

    public short[] getShortArray() throws PortalException, SystemException {
        this.validate(14);
        return GetterUtil.getShortValues((String[])StringUtil.split((String)this.getData()));
    }

    public String getString() throws PortalException, SystemException {
        this.validate(15);
        return this.getData();
    }

    public String[] getStringArray() throws PortalException, SystemException {
        this.validate(16);
        String[] dataArray = StringUtil.split((String)this.getData());
        int i2 = 0;
        while (i2 < dataArray.length) {
            dataArray[i2] = StringUtil.replace((String)dataArray[i2], (String)_EXPANDO_COMMA, (String)",");
            ++i2;
        }
        return dataArray;
    }

    public void setBoolean(boolean data) throws PortalException, SystemException {
        this.validate(1);
        this.setData(String.valueOf(data));
    }

    public void setBooleanArray(boolean[] data) throws PortalException, SystemException {
        this.validate(2);
        this.setData(StringUtil.merge((boolean[])data));
    }

    public void setColumn(ExpandoColumn column) {
        this._column = column;
        this.setColumnId(this._column.getColumnId());
    }

    public void setDate(Date data) throws PortalException, SystemException {
        this.validate(3);
        this.setData(String.valueOf(data.getTime()));
    }

    public void setDateArray(Date[] data) throws PortalException, SystemException {
        this.validate(4);
        this.setData(StringUtil.merge((Object[])data));
    }

    public void setDouble(double data) throws PortalException, SystemException {
        this.validate(5);
        this.setData(String.valueOf(data));
    }

    public void setDoubleArray(double[] data) throws PortalException, SystemException {
        this.validate(6);
        this.setData(StringUtil.merge((double[])data));
    }

    public void setFloat(float data) throws PortalException, SystemException {
        this.validate(7);
        this.setData(String.valueOf(data));
    }

    public void setFloatArray(float[] data) throws PortalException, SystemException {
        this.validate(8);
        this.setData(StringUtil.merge((float[])data));
    }

    public void setInteger(int data) throws PortalException, SystemException {
        this.validate(9);
        this.setData(String.valueOf(data));
    }

    public void setIntegerArray(int[] data) throws PortalException, SystemException {
        this.validate(10);
        this.setData(StringUtil.merge((int[])data));
    }

    public void setLong(long data) throws PortalException, SystemException {
        this.validate(11);
        this.setData(String.valueOf(data));
    }

    public void setLongArray(long[] data) throws PortalException, SystemException {
        this.validate(12);
        this.setData(StringUtil.merge((long[])data));
    }

    public void setNumber(Number data) throws PortalException, SystemException {
        this.validate(17);
        this.setData(String.valueOf(data));
    }

    public void setNumberArray(Number[] data) throws PortalException, SystemException {
        this.validate(18);
        this.setData(StringUtil.merge((Object[])data));
    }

    public void setShort(short data) throws PortalException, SystemException {
        this.validate(13);
        this.setData(String.valueOf(data));
    }

    public void setShortArray(short[] data) throws PortalException, SystemException {
        this.validate(14);
        this.setData(StringUtil.merge((short[])data));
    }

    public void setString(String data) throws PortalException, SystemException {
        this.validate(15);
        this.setData(data);
    }

    public void setStringArray(String[] data) throws PortalException, SystemException {
        this.validate(16);
        if (data != null) {
            int i2 = 0;
            while (i2 < data.length) {
                data[i2] = StringUtil.replace((String)data[i2], (String)",", (String)_EXPANDO_COMMA);
                ++i2;
            }
        }
        this.setData(StringUtil.merge((Object[])data));
    }

    protected void validate(int type) throws PortalException, SystemException {
        ExpandoColumn column = this.getColumn();
        if (column == null) {
            return;
        }
        if (column.getType() == type) {
            return;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("Column ");
        sb.append(this.getColumnId());
        sb.append(" has type ");
        sb.append(ExpandoColumnConstants.getTypeLabel((int)column.getType()));
        sb.append(" and is not compatible with type ");
        sb.append(ExpandoColumnConstants.getTypeLabel((int)type));
        throw new ValueDataException(sb.toString());
    }
}

