/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.journal.DuplicateTemplateIdException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.RequiredTemplateException;
import com.liferay.portlet.journal.TemplateIdException;
import com.liferay.portlet.journal.TemplateNameException;
import com.liferay.portlet.journal.TemplateSmallImageNameException;
import com.liferay.portlet.journal.TemplateSmallImageSizeException;
import com.liferay.portlet.journal.TemplateXslException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalTemplateServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.util.JS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditTemplateAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(JournalTemplate.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        JournalTemplate template = null;
        try {
            boolean saveAndContinue;
            if (cmd.equals("add") || cmd.equals("update")) {
                template = this.updateTemplate(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteTemplates(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (template != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, template, redirect);
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchTemplateException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e2 instanceof DuplicateTemplateIdException || e2 instanceof RequiredTemplateException || e2 instanceof TemplateIdException || e2 instanceof TemplateNameException || e2 instanceof TemplateSmallImageNameException || e2 instanceof TemplateSmallImageSizeException || e2 instanceof TemplateXslException) {
                String redirect;
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                if (e2 instanceof RequiredTemplateException && Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getTemplate((PortletRequest)renderRequest);
            }
        }
        catch (NoSuchTemplateException noSuchTemplateException) {
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.journal.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_template"));
    }

    protected void deleteTemplates(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] deleteTemplateIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteTemplateIds"));
        int i2 = 0;
        while (i2 < deleteTemplateIds.length) {
            JournalTemplateServiceUtil.deleteTemplate((long)groupId, (String)deleteTemplateIds[i2]);
            JournalUtil.removeRecentTemplate((PortletRequest)actionRequest, deleteTemplateIds[i2]);
            ++i2;
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, JournalTemplate template, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String originalRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"originalRedirect");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(actionRequest.getWindowState());
        portletURL.setParameter("struts_action", "/journal/edit_template");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("originalRedirect", originalRedirect, false);
        portletURL.setParameter("groupId", String.valueOf(template.getGroupId()), false);
        portletURL.setParameter("templateId", template.getTemplateId(), false);
        return portletURL.toString();
    }

    protected String getXsl(UploadPortletRequest uploadPortletRequest) {
        String xsl;
        block3: {
            xsl = null;
            try {
                InputStream is = uploadPortletRequest.getFileAsStream("xsl");
                if (is != null) {
                    xsl = new String(FileUtil.getBytes((InputStream)is));
                    is.close();
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
        return xsl;
    }

    protected JournalTemplate updateTemplate(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
        String templateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"templateId");
        boolean autoTemplateId = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"autoTemplateId");
        String structureId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"structureId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String xsl = this.getXsl(uploadPortletRequest);
        String xslContent = JS.decodeURIComponent((String)ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"xslContent"));
        boolean formatXsl = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"formatXsl");
        if (Validator.isNull((String)xsl)) {
            xsl = xslContent;
        }
        String langType = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"langType", (String)"xsl");
        boolean cacheable = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"cacheable");
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageURL");
        File smallFile = uploadPortletRequest.getFile("smallFile");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalTemplate.class.getName(), (PortletRequest)actionRequest);
        JournalTemplate template = null;
        template = cmd.equals("add") ? JournalTemplateServiceUtil.addTemplate((long)groupId, (String)templateId, (boolean)autoTemplateId, (String)structureId, (Map)nameMap, (Map)descriptionMap, (String)xsl, (boolean)formatXsl, (String)langType, (boolean)cacheable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (ServiceContext)serviceContext) : JournalTemplateServiceUtil.updateTemplate((long)groupId, (String)templateId, (String)structureId, (Map)nameMap, (Map)descriptionMap, (String)xsl, (boolean)formatXsl, (String)langType, (boolean)cacheable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (ServiceContext)serviceContext);
        JournalUtil.addRecentTemplate((PortletRequest)actionRequest, template);
        return template;
    }
}

