/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.journal.service.permission.JournalStructurePermission;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalArticleAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = JournalArticle.class.getName();
    public static final String TYPE = "content";
    private static final boolean _LINKABLE = true;

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        JournalArticle article;
        block5: {
            article = null;
            try {
                article = JournalArticleLocalServiceUtil.getArticle((long)classPK);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                JournalArticleResource articleResource = JournalArticleResourceLocalServiceUtil.getArticleResource((long)classPK);
                boolean approvedArticleAvailable = true;
                if (type == 1) {
                    try {
                        article = JournalArticleLocalServiceUtil.getDisplayArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId());
                    }
                    catch (NoSuchArticleException noSuchArticleException2) {
                        approvedArticleAvailable = false;
                    }
                }
                if (type == 1 && approvedArticleAvailable) break block5;
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId(), (int)-1);
            }
        }
        return new JournalArticleAssetRenderer(article);
    }

    public AssetRenderer getAssetRenderer(long groupId, String urlTitle) throws PortalException, SystemException {
        JournalArticle article = JournalArticleServiceUtil.getDisplayArticleByUrlTitle((long)groupId, (String)urlTitle);
        return new JournalArticleAssetRenderer(article);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public Map<Long, String> getClassTypes(long[] groupIds, Locale locale) throws Exception {
        HashMap<Long, String> classTypes = new HashMap<Long, String>();
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            List structures = JournalStructureLocalServiceUtil.getStructures((long)groupId);
            for (JournalStructure structure : structures) {
                classTypes.put(structure.getId(), structure.getName(locale));
            }
            ++n2;
        }
        return classTypes;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException, SystemException {
        HttpServletRequest request = liferayPortletRequest.getHttpServletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (!JournalPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_ARTICLE")) {
            return null;
        }
        long classTypeId = GetterUtil.getLong((Object)liferayPortletRequest.getAttribute("ASSET_RENDERER_FACTORY_CLASS_TYPE_ID"));
        if (classTypeId > 0L && !JournalStructurePermission.contains(themeDisplay.getPermissionChecker(), classTypeId, "VIEW")) {
            return null;
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"15", (long)this.getControlPanelPlid(themeDisplay), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        return portletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return JournalArticlePermission.contains(permissionChecker, classPK, actionId);
    }

    public boolean isLinkable() {
        return true;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

