/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class JournalContentPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final boolean _ALWAYS_STAGED = true;
    private static final boolean _DATA_LOCALIZED = true;
    private static final String _NAMESPACE = "journal";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static Log _log = LogFactoryUtil.getLog(JournalContentPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _embeddedAssets = new PortletDataHandlerBoolean("journal", "embedded-assets");
    private static PortletDataHandlerBoolean _selectedArticles = new PortletDataHandlerBoolean("journal", "selected-web-content", true, true);

    public String[] getDataPortletPreferences() {
        return new String[]{"groupId", "articleId", "templateId"};
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_selectedArticles, _embeddedAssets};
    }

    public PortletDataHandlerControl[] getExportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, "web-content", true, JournalPortletDataHandlerImpl.getMetadataControls()), new PortletDataHandlerBoolean(_NAMESPACE, "folders-and-documents", true, DLPortletDataHandlerImpl.getMetadataControls())};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_selectedArticles};
    }

    public PortletDataHandlerControl[] getImportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, "web-content", true, JournalPortletDataHandlerImpl.getMetadataControls()), new PortletDataHandlerBoolean(_NAMESPACE, "folders-and-documents", true, DLPortletDataHandlerImpl.getMetadataControls())};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isAlwaysStaged() {
        return true;
    }

    public boolean isDataLocalized() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletPreferences.setValue("groupId", "");
        portletPreferences.setValue("articleId", "");
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.journal", portletDataContext.getScopeGroupId());
        String articleId = portletPreferences.getValue("articleId", null);
        if (articleId == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No article id found in preferences of portlet " + portletId));
            }
            return "";
        }
        long articleGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", ""));
        if (articleGroupId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No group id found in preferences of portlet " + portletId));
            }
            return "";
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        if (articleGroupId != portletDataContext.getScopeGroupId()) {
            portletDataContext.setScopeGroupId(articleGroupId);
        }
        JournalArticle article = null;
        try {
            article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (int)0);
        }
        catch (NoSuchArticleException noSuchArticleException) {}
        if (article == null) {
            try {
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (int)3);
            }
            catch (NoSuchArticleException noSuchArticleException) {}
        }
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("journal-content-data");
        if (article == null) {
            portletDataContext.setScopeGroupId(previousScopeGroupId);
            return document.formattedString();
        }
        String path = JournalPortletDataHandlerImpl.getArticlePath(portletDataContext, article);
        Element articleElement = rootElement.addElement("article");
        articleElement.addAttribute("path", path);
        Element dlFileEntryTypesElement = rootElement.addElement("dl-file-entry-types");
        Element dlFoldersElement = rootElement.addElement("dl-folders");
        Element dlFilesElement = rootElement.addElement("dl-file-entries");
        Element dlFileRanksElement = rootElement.addElement("dl-file-ranks");
        Element dlRepositoriesElement = rootElement.addElement("dl-repositories");
        Element dlRepositoryEntriesElement = rootElement.addElement("dl-repository-entries");
        String preferenceTemplateId = portletPreferences.getValue("templateId", null);
        JournalPortletDataHandlerImpl.exportArticle(portletDataContext, rootElement, rootElement, rootElement, dlFileEntryTypesElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, dlRepositoriesElement, dlRepositoryEntriesElement, article, preferenceTemplateId, false);
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        String articleId;
        Element articleElement;
        Element templateElement;
        portletDataContext.importPermissions("com.liferay.portlet.journal", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        if (Validator.isNull((String)data)) {
            return null;
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        long importGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", null));
        if (importGroupId == portletDataContext.getSourceGroupId()) {
            portletDataContext.setScopeGroupId(portletDataContext.getGroupId());
        }
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        JournalPortletDataHandlerImpl.importReferencedData(portletDataContext, rootElement);
        Element structureElement = rootElement.element("structure");
        if (structureElement != null) {
            JournalPortletDataHandlerImpl.importStructure(portletDataContext, structureElement);
        }
        if ((templateElement = rootElement.element("template")) != null) {
            JournalPortletDataHandlerImpl.importTemplate(portletDataContext, templateElement);
        }
        if ((articleElement = rootElement.element("article")) != null) {
            JournalPortletDataHandlerImpl.importArticle(portletDataContext, articleElement);
        }
        if (Validator.isNotNull((String)(articleId = portletPreferences.getValue("articleId", null))) && articleElement != null) {
            Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
            articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
            portletPreferences.setValue("articleId", articleId);
            String importedArticleGroupId = String.valueOf(portletDataContext.getScopeGroupId());
            if (portletDataContext.isCompanyReference(JournalArticle.class, articleId)) {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                importedArticleGroupId = String.valueOf(companyGroup.getGroupId());
            }
            portletPreferences.setValue("groupId", importedArticleGroupId);
            Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getPlid());
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)articleId, (boolean)true);
        } else {
            portletPreferences.setValue("groupId", "");
            portletPreferences.setValue("articleId", "");
        }
        String templateId = portletPreferences.getValue("templateId", null);
        if (Validator.isNotNull((String)templateId)) {
            Map templateIds = portletDataContext.getNewPrimaryKeysMap(JournalTemplate.class + ".templateId");
            templateId = MapUtil.getString((Map)templateIds, (String)templateId, (String)templateId);
            portletPreferences.setValue("templateId", templateId);
        } else {
            portletPreferences.setValue("templateId", "");
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return portletPreferences;
    }
}

