/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.base.JournalArticleServiceBaseImpl;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalArticleServiceImpl
extends JournalArticleServiceBaseImpl {
    public JournalArticle addArticle(long groupId, long classNameId, long classPK, String articleId, boolean autoArticleId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String structureId, String templateId, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_ARTICLE");
        return this.journalArticleLocalService.addArticle(this.getUserId(), groupId, classNameId, classPK, articleId, autoArticleId, 1.0, titleMap, descriptionMap, content, type, structureId, templateId, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallFile, images, articleURL, serviceContext);
    }

    public JournalArticle addArticle(long groupId, long classNameId, long classPK, String articleId, boolean autoArticleId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String structureId, String templateId, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_ARTICLE");
        return this.journalArticleLocalService.addArticle(this.getUserId(), groupId, classNameId, classPK, articleId, autoArticleId, 1.0, titleMap, descriptionMap, content, type, structureId, templateId, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, false, null, null, null, articleURL, serviceContext);
    }

    public JournalArticle copyArticle(long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_ARTICLE");
        return this.journalArticleLocalService.copyArticle(this.getUserId(), groupId, oldArticleId, newArticleId, autoArticleId, version);
    }

    public void deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "DELETE");
        this.journalArticleLocalService.deleteArticle(groupId, articleId, version, articleURL, serviceContext);
    }

    public void deleteArticle(long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "DELETE");
        this.journalArticleLocalService.deleteArticle(groupId, articleId, serviceContext);
    }

    public JournalArticle expireArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "EXPIRE");
        return this.journalArticleLocalService.expireArticle(this.getUserId(), groupId, articleId, version, articleURL, serviceContext);
    }

    public void expireArticle(long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "EXPIRE");
        this.journalArticleLocalService.expireArticle(this.getUserId(), groupId, articleId, articleURL, serviceContext);
    }

    public JournalArticle getArticle(long id) throws PortalException, SystemException {
        JournalArticle article = this.journalArticleLocalService.getArticle(id);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "VIEW");
        return article;
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticle(groupId, articleId);
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "VIEW");
        return this.journalArticleLocalService.getArticle(groupId, articleId, version);
    }

    public JournalArticle getArticle(long groupId, String className, long classPK) throws PortalException, SystemException {
        JournalArticle article = this.journalArticleLocalService.getArticle(groupId, className, classPK);
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, article.getArticleId(), article.getVersion(), "VIEW");
        return article;
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException, SystemException {
        JournalArticle article = this.journalArticleLocalService.getArticleByUrlTitle(groupId, urlTitle);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "VIEW");
        return article;
    }

    public String getArticleContent(long groupId, String articleId, double version, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "VIEW");
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, version, null, languageId, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, null, languageId, themeDisplay);
    }

    public List<JournalArticle> getArticlesByArticleId(long groupId, String articleId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticlePersistence.filterFindByG_A(groupId, articleId, start, end, obc);
    }

    public List<JournalArticle> getArticlesByLayoutUuid(long groupId, String layoutUuid) throws SystemException {
        return this.journalArticlePersistence.filterFindByG_L(groupId, layoutUuid);
    }

    public int getArticlesCountByArticleId(long groupId, String articleId) throws SystemException {
        return this.journalArticlePersistence.filterCountByG_A(groupId, articleId);
    }

    public JournalArticle getDisplayArticleByUrlTitle(long groupId, String urlTitle) throws PortalException, SystemException {
        JournalArticle article = this.journalArticleLocalService.getDisplayArticleByUrlTitle(groupId, urlTitle);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "VIEW");
        return article;
    }

    public JournalArticle getLatestArticle(long resourcePrimKey) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), resourcePrimKey, "VIEW");
        return this.journalArticleLocalService.getLatestArticle(resourcePrimKey);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId, int status) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, status, "VIEW");
        return this.journalArticleLocalService.getLatestArticle(groupId, articleId, status);
    }

    public JournalArticle getLatestArticle(long groupId, String className, long classPK) throws PortalException, SystemException {
        JournalArticle article = this.journalArticleLocalService.getLatestArticle(groupId, className, classPK);
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, article.getArticleId(), article.getVersion(), "VIEW");
        return article;
    }

    public void removeArticleLocale(long companyId, String languageId) throws PortalException, SystemException {
        for (JournalArticle article : this.journalArticlePersistence.findByCompanyId(companyId)) {
            this.removeArticleLocale(article.getGroupId(), article.getArticleId(), article.getVersion(), languageId);
        }
    }

    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.removeArticleLocale(groupId, articleId, version, languageId);
    }

    public List<JournalArticle> search(long companyId, long groupId, long classNameId, String keywords, Double version, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticleFinder.filterFindByKeywords(companyId, groupId, classNameId, keywords, version, type, structureId, templateId, displayDateGT, displayDateLT, status, reviewDate, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, long classNameId, String articleId, Double version, String title, String description, String content, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticleFinder.filterFindByC_G_C_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, classNameId, articleId, version, title, description, content, type, structureId, templateId, displayDateGT, displayDateLT, status, reviewDate, andOperator, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, long classNameId, String articleId, Double version, String title, String description, String content, String type, String[] structureIds, String[] templateIds, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalArticleFinder.filterFindByC_G_C_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, classNameId, articleId, version, title, description, content, type, structureIds, templateIds, displayDateGT, displayDateLT, status, reviewDate, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long groupId, long classNameId, String keywords, Double version, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate) throws SystemException {
        return this.journalArticleFinder.filterCountByKeywords(companyId, groupId, classNameId, keywords, version, type, structureId, templateId, displayDateGT, displayDateLT, status, reviewDate);
    }

    public int searchCount(long companyId, long groupId, long classNameId, String articleId, Double version, String title, String description, String content, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        return this.journalArticleFinder.filterCountByC_G_C_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, classNameId, articleId, version, title, description, content, type, structureId, templateId, displayDateGT, displayDateLT, status, reviewDate, andOperator);
    }

    public int searchCount(long companyId, long groupId, long classNameId, String articleId, Double version, String title, String description, String content, String type, String[] structureIds, String[] templateIds, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        return this.journalArticleFinder.filterCountByC_G_C_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, classNameId, articleId, version, title, description, content, type, structureIds, templateIds, displayDateGT, displayDateLT, status, reviewDate, andOperator);
    }

    public void subscribe(long groupId) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.journalArticleLocalService.subscribe(this.getUserId(), groupId);
    }

    public void unsubscribe(long groupId) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.journalArticleLocalService.unsubscribe(this.getUserId(), groupId);
    }

    public JournalArticle updateArticle(long userId, long groupId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String layoutUuid, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.journalArticleLocalService.updateArticle(userId, groupId, articleId, version, titleMap, descriptionMap, content, layoutUuid, serviceContext);
    }

    public JournalArticle updateArticle(long groupId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String structureId, String templateId, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateArticle(this.getUserId(), groupId, articleId, version, titleMap, descriptionMap, content, type, structureId, templateId, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallFile, images, articleURL, serviceContext);
    }

    public JournalArticle updateArticle(long groupId, String articleId, double version, String content, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateArticle(this.getUserId(), groupId, articleId, version, content, serviceContext);
    }

    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images) throws PortalException, SystemException {
        return this.updateArticleTranslation(groupId, articleId, version, locale, title, description, content, images, null);
    }

    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateArticleTranslation(groupId, articleId, version, locale, title, description, content, images, serviceContext);
    }

    public JournalArticle updateContent(long groupId, String articleId, double version, String content) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateContent(groupId, articleId, version, content);
    }

    public JournalArticle updateStatus(long groupId, String articleId, double version, int status, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, version, "UPDATE");
        return this.journalArticleLocalService.updateStatus(this.getUserId(), groupId, articleId, version, status, articleURL, serviceContext);
    }
}

