/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portlet.journal.model.JournalContentSearch;
import com.liferay.portlet.journal.service.base.JournalContentSearchLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalContentSearchLocalServiceImpl
extends JournalContentSearchLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(JournalContentSearchLocalServiceImpl.class);

    public void checkContentSearches(long companyId) throws PortalException, SystemException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Checking journal content search for " + companyId));
        }
        ArrayList layouts = new ArrayList();
        List groups = this.groupLocalService.search(companyId, null, null, null, -1, -1);
        for (Group group : groups) {
            this.deleteOwnerContentSearches(group.getGroupId(), true);
            layouts.addAll(this.layoutLocalService.getLayouts(group.getGroupId(), true));
            this.deleteOwnerContentSearches(group.getGroupId(), false);
            layouts.addAll(this.layoutLocalService.getLayouts(group.getGroupId(), false));
        }
        for (Layout layout : layouts) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            List portletIds = layoutTypePortlet.getPortletIds();
            for (String portletId : portletIds) {
                PortletPreferences preferences;
                String articleId;
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                if (!rootPortletId.equals("56") || !Validator.isNotNull((String)(articleId = (preferences = this.portletPreferencesLocalService.getPreferences(layout.getCompanyId(), 0L, 3, layout.getPlid(), portletId)).getValue("articleId", "")))) continue;
                this.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, articleId);
            }
        }
    }

    public void deleteArticleContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId, String articleId) throws PortalException, SystemException {
        JournalContentSearch contentSearch = this.journalContentSearchPersistence.findByG_P_L_P_A(groupId, privateLayout, layoutId, portletId, articleId);
        this.deleteJournalContentSearch(contentSearch);
    }

    public void deleteArticleContentSearches(long groupId, String articleId) throws SystemException {
        List contentSearches = this.journalContentSearchPersistence.findByG_A(groupId, articleId);
        for (JournalContentSearch contentSearch : contentSearches) {
            this.deleteJournalContentSearch(contentSearch);
        }
    }

    public void deleteLayoutContentSearches(long groupId, boolean privateLayout, long layoutId) throws SystemException {
        List contentSearches = this.journalContentSearchPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        for (JournalContentSearch contentSearch : contentSearches) {
            this.deleteJournalContentSearch(contentSearch);
        }
    }

    public void deleteOwnerContentSearches(long groupId, boolean privateLayout) throws SystemException {
        List contentSearches = this.journalContentSearchPersistence.findByG_P(groupId, privateLayout);
        for (JournalContentSearch contentSearch : contentSearches) {
            this.deleteJournalContentSearch(contentSearch);
        }
    }

    public List<JournalContentSearch> getArticleContentSearches() throws SystemException {
        return this.journalContentSearchPersistence.findAll();
    }

    public List<JournalContentSearch> getArticleContentSearches(long groupId, String articleId) throws SystemException {
        return this.journalContentSearchPersistence.findByG_A(groupId, articleId);
    }

    public List<JournalContentSearch> getArticleContentSearches(String articleId) throws SystemException {
        return this.journalContentSearchPersistence.findByArticleId(articleId);
    }

    public List<Long> getLayoutIds(long groupId, boolean privateLayout, String articleId) throws SystemException {
        ArrayList<Long> layoutIds = new ArrayList<Long>();
        List contentSearches = this.journalContentSearchPersistence.findByG_P_A(groupId, privateLayout, articleId);
        for (JournalContentSearch contentSearch : contentSearches) {
            layoutIds.add(contentSearch.getLayoutId());
        }
        return layoutIds;
    }

    public int getLayoutIdsCount(long groupId, boolean privateLayout, String articleId) throws SystemException {
        return this.journalContentSearchPersistence.countByG_P_A(groupId, privateLayout, articleId);
    }

    public int getLayoutIdsCount(String articleId) throws SystemException {
        return this.journalContentSearchPersistence.countByArticleId(articleId);
    }

    public JournalContentSearch updateContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId, String articleId) throws PortalException, SystemException {
        return this.updateContentSearch(groupId, privateLayout, layoutId, portletId, articleId, false);
    }

    public JournalContentSearch updateContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId, String articleId, boolean purge) throws PortalException, SystemException {
        if (purge) {
            this.journalContentSearchPersistence.removeByG_P_L_P(groupId, privateLayout, layoutId, portletId);
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        JournalContentSearch contentSearch = this.journalContentSearchPersistence.fetchByG_P_L_P_A(groupId, privateLayout, layoutId, portletId, articleId);
        if (contentSearch == null) {
            long contentSearchId = this.counterLocalService.increment();
            contentSearch = this.journalContentSearchPersistence.create(contentSearchId);
            contentSearch.setGroupId(groupId);
            contentSearch.setCompanyId(group.getCompanyId());
            contentSearch.setPrivateLayout(privateLayout);
            contentSearch.setLayoutId(layoutId);
            contentSearch.setPortletId(portletId);
            contentSearch.setArticleId(articleId);
        }
        this.journalContentSearchPersistence.update((BaseModel)contentSearch, false);
        return contentSearch;
    }

    public List<JournalContentSearch> updateContentSearch(long groupId, boolean privateLayout, long layoutId, String portletId, String[] articleIds) throws PortalException, SystemException {
        this.journalContentSearchPersistence.removeByG_P_L_P(groupId, privateLayout, layoutId, portletId);
        ArrayList<JournalContentSearch> contentSearches = new ArrayList<JournalContentSearch>();
        String[] stringArray = articleIds;
        int n = articleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String articleId = stringArray[n2];
            JournalContentSearch contentSearch = this.updateContentSearch(groupId, privateLayout, layoutId, portletId, articleId, false);
            contentSearches.add(contentSearch);
            ++n2;
        }
        return contentSearches;
    }
}

