/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.journal.DuplicateStructureElementException;
import com.liferay.portlet.journal.DuplicateStructureIdException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.RequiredStructureException;
import com.liferay.portlet.journal.StructureIdException;
import com.liferay.portlet.journal.StructureInheritanceException;
import com.liferay.portlet.journal.StructureNameException;
import com.liferay.portlet.journal.StructureXsdException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.base.JournalStructureLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.comparator.StructurePKComparator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalStructureLocalServiceImpl
extends JournalStructureLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(JournalStructureLocalServiceImpl.class);

    public JournalStructure addStructure(long userId, long groupId, String structureId, boolean autoStructureId, String parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        structureId = structureId.trim().toUpperCase();
        Date now = new Date();
        try {
            xsd = JournalUtil.processXMLAttributes(xsd);
            xsd = DDMXMLUtil.formatXML((String)xsd);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
        if (autoStructureId) {
            structureId = String.valueOf(this.counterLocalService.increment());
        }
        this.validate(groupId, structureId, autoStructureId, parentStructureId, nameMap, xsd);
        long id = this.counterLocalService.increment();
        JournalStructure structure = this.journalStructurePersistence.create(id);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setCreateDate(serviceContext.getCreateDate(now));
        structure.setModifiedDate(serviceContext.getModifiedDate(now));
        structure.setStructureId(structureId);
        structure.setParentStructureId(parentStructureId);
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setXsd(xsd);
        this.journalStructurePersistence.update((BaseModel)structure, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addStructureResources(structure, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addStructureResources(structure, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        ExpandoBridge expandoBridge = structure.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return structure;
    }

    public void addStructureResources(JournalStructure structure, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), JournalStructure.class.getName(), structure.getId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(JournalStructure structure, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), JournalStructure.class.getName(), structure.getId(), groupPermissions, guestPermissions);
    }

    public void addStructureResources(long groupId, String structureId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        this.addStructureResources(structure, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(long groupId, String structureId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        this.addStructureResources(structure, groupPermissions, guestPermissions);
    }

    public void checkNewLine(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        String xsd = structure.getXsd();
        if (xsd != null && xsd.indexOf("\\n") != -1) {
            xsd = StringUtil.replace((String)xsd, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            structure.setXsd(xsd);
            this.journalStructurePersistence.update((BaseModel)structure, false);
        }
    }

    public JournalStructure copyStructure(long userId, long groupId, String oldStructureId, String newStructureId, boolean autoStructureId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldStructureId = oldStructureId.trim().toUpperCase();
        newStructureId = newStructureId.trim().toUpperCase();
        Date now = new Date();
        JournalStructure oldStructure = this.journalStructurePersistence.findByG_S(groupId, oldStructureId);
        if (autoStructureId) {
            newStructureId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validateStructureId(newStructureId);
            JournalStructure newStructure = this.journalStructurePersistence.fetchByG_S(groupId, newStructureId);
            if (newStructure != null) {
                throw new DuplicateStructureIdException();
            }
        }
        long id = this.counterLocalService.increment();
        JournalStructure newStructure = this.journalStructurePersistence.create(id);
        newStructure.setGroupId(groupId);
        newStructure.setCompanyId(user.getCompanyId());
        newStructure.setUserId(user.getUserId());
        newStructure.setUserName(user.getFullName());
        newStructure.setCreateDate(now);
        newStructure.setModifiedDate(now);
        newStructure.setStructureId(newStructureId);
        newStructure.setNameMap(oldStructure.getNameMap());
        newStructure.setDescriptionMap(oldStructure.getDescriptionMap());
        newStructure.setXsd(oldStructure.getXsd());
        this.journalStructurePersistence.update((BaseModel)newStructure, false);
        this.addStructureResources(newStructure, true, true);
        return newStructure;
    }

    public void deleteStructure(JournalStructure structure) throws PortalException, SystemException {
        Group companyGroup = this.groupLocalService.getCompanyGroup(structure.getCompanyId());
        if (structure.getGroupId() == companyGroup.getGroupId()) {
            if (this.journalArticlePersistence.countByStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException(3);
            }
            if (this.journalStructurePersistence.countByParentStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException(1);
            }
            if (this.journalTemplatePersistence.countByStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException(2);
            }
        } else {
            if (this.journalArticlePersistence.countByG_C_S(structure.getGroupId(), 0L, structure.getStructureId()) > 0) {
                throw new RequiredStructureException(3);
            }
            if (this.journalStructurePersistence.countByG_P(structure.getGroupId(), structure.getStructureId()) > 0) {
                throw new RequiredStructureException(1);
            }
            if (this.journalTemplatePersistence.countByG_S(structure.getGroupId(), structure.getStructureId()) > 0) {
                throw new RequiredStructureException(2);
            }
        }
        this.webDAVPropsLocalService.deleteWebDAVProps(JournalStructure.class.getName(), structure.getId());
        this.expandoValueLocalService.deleteValues(JournalStructure.class.getName(), structure.getId());
        this.resourceLocalService.deleteResource(structure.getCompanyId(), JournalStructure.class.getName(), 4, structure.getId());
        try {
            long classNameId = PortalUtil.getClassNameId((String)JournalStructure.class.getName());
            List articles = this.journalArticlePersistence.findByG_C_C(structure.getGroupId(), classNameId, structure.getId());
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.deleteArticle(article, null, null);
            }
        }
        catch (NoSuchArticleException noSuchArticleException) {}
        this.journalStructurePersistence.remove((BaseModel)structure);
    }

    public void deleteStructure(long groupId, String structureId) throws PortalException, SystemException {
        structureId = structureId.trim().toUpperCase();
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        this.deleteStructure(structure);
    }

    public void deleteStructures(long groupId) throws PortalException, SystemException {
        List structures = this.journalStructurePersistence.findByGroupId(groupId, -1, -1, (OrderByComparator)new StructurePKComparator());
        for (JournalStructure structure : structures) {
            this.deleteStructure(structure);
        }
    }

    public JournalStructure getStructure(long id) throws PortalException, SystemException {
        return this.journalStructurePersistence.findByPrimaryKey(id);
    }

    public JournalStructure getStructure(long groupId, String structureId) throws PortalException, SystemException {
        return this.getStructure(groupId, structureId, false);
    }

    public JournalStructure getStructure(long groupId, String structureId, boolean includeGlobalStructures) throws PortalException, SystemException {
        structureId = structureId.trim().toUpperCase();
        if (groupId == 0L) {
            _log.error((Object)("No group id was passed for " + structureId + ". Group id is " + "required since 4.2.0. Please update all custom code and " + "data that references structures without a group id."));
            List structures = this.journalStructurePersistence.findByStructureId(structureId);
            if (!structures.isEmpty()) {
                return (JournalStructure)structures.get(0);
            }
            throw new NoSuchStructureException("No JournalStructure exists with the structure id " + structureId);
        }
        JournalStructure structure = this.journalStructurePersistence.fetchByG_S(groupId, structureId);
        if (structure != null) {
            return structure;
        }
        if (!includeGlobalStructures) {
            throw new NoSuchStructureException("No JournalStructure exists with the structure id " + structureId);
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        return this.journalStructurePersistence.findByG_S(companyGroup.getGroupId(), structureId);
    }

    public List<JournalStructure> getStructures() throws SystemException {
        return this.journalStructurePersistence.findAll();
    }

    public List<JournalStructure> getStructures(long groupId) throws SystemException {
        return this.journalStructurePersistence.findByGroupId(groupId);
    }

    public List<JournalStructure> getStructures(long groupId, int start, int end) throws SystemException {
        return this.journalStructurePersistence.findByGroupId(groupId, start, end);
    }

    public int getStructuresCount(long groupId) throws SystemException {
        return this.journalStructurePersistence.countByGroupId(groupId);
    }

    public List<JournalStructure> search(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalStructureFinder.findByKeywords(companyId, groupIds, keywords, start, end, obc);
    }

    public List<JournalStructure> search(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalStructureFinder.findByC_G_S_N_D(companyId, groupIds, structureId, name, description, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords) throws SystemException {
        return this.journalStructureFinder.countByKeywords(companyId, groupIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator) throws SystemException {
        return this.journalStructureFinder.countByC_G_S_N_D(companyId, groupIds, structureId, name, description, andOperator);
    }

    public JournalStructure updateStructure(long groupId, String structureId, String parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        structureId = structureId.trim().toUpperCase();
        try {
            xsd = JournalUtil.processXMLAttributes(xsd);
            xsd = DDMXMLUtil.formatXML((String)xsd);
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
        this.validateParentStructureId(groupId, structureId, parentStructureId);
        this.validate(groupId, parentStructureId, nameMap, xsd);
        JournalStructure structure = this.journalStructurePersistence.findByG_S(groupId, structureId);
        structure.setModifiedDate(serviceContext.getModifiedDate(null));
        structure.setParentStructureId(parentStructureId);
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setXsd(xsd);
        this.journalStructurePersistence.update((BaseModel)structure, false);
        ExpandoBridge expandoBridge = structure.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return structure;
    }

    protected void appendParentStructureElements(long groupId, String parentStructureId, List<Element> elements) throws Exception {
        if (Validator.isNull((String)parentStructureId)) {
            return;
        }
        JournalStructure parentStructure = this.getParentStructure(groupId, parentStructureId);
        this.appendParentStructureElements(groupId, parentStructure.getParentStructureId(), elements);
        Document document = SAXReaderUtil.read((String)parentStructure.getXsd());
        Element rootElement = document.getRootElement();
        elements.addAll(rootElement.elements());
    }

    protected JournalStructure getParentStructure(long groupId, String parentStructureId) throws PortalException, SystemException {
        JournalStructure parentStructure = this.journalStructurePersistence.fetchByG_S(groupId, parentStructureId);
        if (parentStructure != null) {
            return parentStructure;
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        if (groupId != companyGroup.getGroupId()) {
            parentStructure = this.journalStructurePersistence.findByG_S(companyGroup.getGroupId(), parentStructureId);
        }
        return parentStructure;
    }

    protected void validate(List<Element> elements, Set<String> elNames) throws PortalException {
        for (Element element : elements) {
            if (element.getName().equals("meta-data")) continue;
            String elName = element.attributeValue("name", "");
            String elType = element.attributeValue("type", "");
            if (Validator.isNull((String)elName) || elName.startsWith("reserved")) {
                throw new StructureXsdException();
            }
            String completePath = elName;
            Element parentElement = element.getParent();
            while (!parentElement.isRootElement()) {
                completePath = String.valueOf(parentElement.attributeValue("name", "")) + "/" + completePath;
                parentElement = parentElement.getParent();
            }
            String elNameLowerCase = completePath.toLowerCase();
            if (elNames.contains(elNameLowerCase)) {
                throw new DuplicateStructureElementException();
            }
            elNames.add(elNameLowerCase);
            if (Validator.isNull((String)elType)) {
                throw new StructureXsdException();
            }
            this.validate(element.elements(), elNames);
        }
    }

    protected void validate(long groupId, String structureId, boolean autoStructureId, String parentStructureId, Map<Locale, String> nameMap, String xsd) throws PortalException, SystemException {
        if (!autoStructureId) {
            this.validateStructureId(structureId);
            JournalStructure structure = this.journalStructurePersistence.fetchByG_S(groupId, structureId);
            if (structure != null) {
                throw new DuplicateStructureIdException();
            }
        }
        this.validateParentStructureId(groupId, structureId, parentStructureId);
        this.validate(groupId, parentStructureId, nameMap, xsd);
    }

    protected void validate(long groupId, String parentStructureId, Map<Locale, String> nameMap, String xsd) throws PortalException {
        Locale locale = LocaleUtil.getDefault();
        if (nameMap.isEmpty() || Validator.isNull((String)nameMap.get(locale))) {
            throw new StructureNameException();
        }
        if (Validator.isNull((String)xsd)) {
            throw new StructureXsdException();
        }
        try {
            ArrayList<Element> elements = new ArrayList<Element>();
            this.appendParentStructureElements(groupId, parentStructureId, elements);
            Document document = SAXReaderUtil.read((String)xsd);
            Element rootElement = document.getRootElement();
            if (rootElement.elements().isEmpty()) {
                throw new StructureXsdException();
            }
            elements.addAll(rootElement.elements());
            HashSet<String> elNames = new HashSet<String>();
            this.validate(elements, elNames);
        }
        catch (DuplicateStructureElementException dsee) {
            throw dsee;
        }
        catch (StructureXsdException sxe) {
            throw sxe;
        }
        catch (Exception exception) {
            throw new StructureXsdException();
        }
    }

    protected void validateParentStructureId(long groupId, String structureId, String parentStructureId) throws PortalException, SystemException {
        if (Validator.isNull((String)parentStructureId)) {
            return;
        }
        if (parentStructureId.equals(structureId)) {
            throw new StructureInheritanceException();
        }
        JournalStructure parentStructure = this.getParentStructure(groupId, parentStructureId);
        while (parentStructure != null) {
            if (parentStructure != null && (parentStructure.getStructureId().equals(structureId) || parentStructure.getParentStructureId().equals(structureId))) {
                throw new StructureInheritanceException();
            }
            try {
                parentStructure = this.getParentStructure(groupId, parentStructure.getParentStructureId());
            }
            catch (NoSuchStructureException noSuchStructureException) {
                break;
            }
        }
    }

    protected void validateStructureId(String structureId) throws PortalException {
        if (Validator.isNull((String)structureId) || Validator.isNumber((String)structureId) || structureId.indexOf(32) != -1) {
            throw new StructureIdException();
        }
    }
}

