/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.base.JournalStructureServiceBaseImpl;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.journal.service.permission.JournalStructurePermission;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalStructureServiceImpl
extends JournalStructureServiceBaseImpl {
    public JournalStructure addStructure(long groupId, String structureId, boolean autoStructureId, String parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_STRUCTURE");
        return this.journalStructureLocalService.addStructure(this.getUserId(), groupId, structureId, autoStructureId, parentStructureId, nameMap, descriptionMap, xsd, serviceContext);
    }

    public JournalStructure copyStructure(long groupId, String oldStructureId, String newStructureId, boolean autoStructureId) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_STRUCTURE");
        return this.journalStructureLocalService.copyStructure(this.getUserId(), groupId, oldStructureId, newStructureId, autoStructureId);
    }

    public void deleteStructure(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "DELETE");
        this.journalStructureLocalService.deleteStructure(groupId, structureId);
    }

    public JournalStructure getStructure(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "VIEW");
        return this.journalStructureLocalService.getStructure(groupId, structureId);
    }

    public List<JournalStructure> getStructures(long groupId) throws SystemException {
        return this.journalStructurePersistence.filterFindByGroupId(groupId);
    }

    public List<JournalStructure> search(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalStructureFinder.filterFindByKeywords(companyId, groupIds, keywords, start, end, obc);
    }

    public List<JournalStructure> search(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.journalStructureFinder.filterFindByC_G_S_N_D(companyId, groupIds, structureId, name, description, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords) throws SystemException {
        return this.journalStructureFinder.filterCountByKeywords(companyId, groupIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator) throws SystemException {
        return this.journalStructureFinder.filterCountByC_G_S_N_D(companyId, groupIds, structureId, name, description, andOperator);
    }

    public JournalStructure updateStructure(long groupId, String structureId, String parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "UPDATE");
        return this.journalStructureLocalService.updateStructure(groupId, structureId, parentStructureId, nameMap, descriptionMap, xsd, serviceContext);
    }
}

