/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    public static final String PORTLET_ID = "15";
    private static final String _FIELD_NAMESPACE = "web_content";
    private static final boolean _PERMISSION_AWARE = true;
    private static Log _log = LogFactoryUtil.getLog(JournalIndexer.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        String templateId;
        String structureId;
        String articleType;
        int status;
        Long classNameId = (Long)searchContext.getAttribute("classNameId");
        if (classNameId != null) {
            contextQuery.addRequiredTerm("classNameId", classNameId.toString());
        }
        if ((status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0)) != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        if (Validator.isNotNull((String)(articleType = (String)((Object)searchContext.getAttribute("articleType"))))) {
            contextQuery.addRequiredTerm("type", articleType);
        }
        if (Validator.isNotNull((String)(structureId = (String)((Object)searchContext.getAttribute("structureId"))))) {
            contextQuery.addRequiredTerm("structureId", structureId);
        }
        if (Validator.isNotNull((String)(templateId = (String)((Object)searchContext.getAttribute("templateId"))))) {
            contextQuery.addRequiredTerm("templateId", templateId);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "classPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId, double version, int status) {
        this.addReindexCriteria(dynamicQuery, companyId, status);
        Property property = PropertyFactoryUtil.forName((String)"version");
        dynamicQuery.add(property.eq((Object)version));
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId, int status) {
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        dynamicQuery.add(statusProperty.eq((Object)status));
    }

    protected void addSearchLocalizedTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        if (Validator.isNull((String)field)) {
            return;
        }
        String value = String.valueOf(searchContext.getAttribute(field));
        if (Validator.isNull((String)value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isNull((String)value)) {
            return;
        }
        field = DocumentImpl.getLocalizedName((Locale)searchContext.getLocale(), (String)field);
        if (searchContext.isAndSearch()) {
            searchQuery.addRequiredTerm(field, value, like);
        } else {
            searchQuery.addTerm(field, value, like);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        this.deleteDocument(article.getCompanyId(), article.getGroupId(), article.getArticleId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        String[] languageIds;
        JournalArticle article = (JournalArticle)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)article);
        document.addUID(PORTLET_ID, article.getGroupId(), article.getArticleId());
        Locale defaultLocale = LocaleUtil.getDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        String[] stringArray = languageIds = this.getLanguageIds(defaultLanguageId, article.getContent());
        int n = languageIds.length;
        int n2 = 0;
        while (n2 < n) {
            String languageId = stringArray[n2];
            String content = this.extractContent(article, languageId);
            if (languageId.equals(defaultLanguageId)) {
                document.addText("content", content);
            }
            document.addText("content".concat("_").concat(languageId), content);
            ++n2;
        }
        document.addLocalizedText("description", article.getDescriptionMap());
        document.addLocalizedText("title", article.getTitleMap());
        document.addKeyword("type", article.getType());
        document.addKeyword("version", article.getVersion());
        document.addKeyword("articleId", article.getArticleId());
        document.addDate("displayDate", article.getDisplayDate());
        document.addKeyword("layoutUuid", article.getLayoutUuid());
        document.addKeyword("structureId", article.getStructureId());
        document.addKeyword("templateId", article.getTemplateId());
        JournalStructure structure = null;
        if (Validator.isNotNull((String)article.getStructureId())) {
            try {
                structure = JournalStructureLocalServiceUtil.getStructure((long)article.getGroupId(), (String)article.getStructureId(), (boolean)true);
            }
            catch (NoSuchStructureException noSuchStructureException) {}
        }
        this.processStructure(structure, document, article.getContent());
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("display-date")) {
            return "displayDate";
        }
        if (orderByCol.equals("id")) {
            return "entryClassPK";
        }
        if (orderByCol.equals("modified-date")) {
            return "modified";
        }
        if (orderByCol.equals("title")) {
            return "title";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get(locale, "title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get(locale, "content"), (int)200);
        }
        String groupId = document.get("groupId");
        String articleId = document.get("articleId");
        String version = document.get("version");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("groupId", groupId);
        portletURL.setParameter("articleId", articleId);
        portletURL.setParameter("version", version);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        Document document = this.getDocument(article);
        if (!article.isIndexable() || !article.isApproved() && article.getVersion() != 1.0) {
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)article.getCompanyId(), (String)document.get("uid"));
            return;
        }
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)article.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK, (int)0);
        this.doReindex(article);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexArticles(companyId);
    }

    protected String encodeFieldName(String name) {
        return _FIELD_NAMESPACE.concat("/").concat(name);
    }

    protected String extractContent(JournalArticle article, String languageId) {
        String content = article.getContentByLocale(languageId);
        content = Validator.isNotNull((String)article.getStructureId()) ? this.extractDynamicContent(content) : this.extractStaticContent(content);
        content = HtmlUtil.extractText((String)content);
        return content;
    }

    protected String extractDynamicContent(Element rootElement) {
        StringBundler sb = new StringBundler();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            Element dynamicContentElement;
            String type = dynamicElementElement.attributeValue("type", "");
            if (!(type.equals("boolean") || type.equals("document_library") || type.equals("image") || type.equals("list") || type.equals("link_to_layout") || type.equals("multi-list") || type.equals("selection_break") || (dynamicContentElement = dynamicElementElement.element("dynamic-content")) == null)) {
                String dynamicContent = dynamicContentElement.getText();
                sb.append(dynamicContent);
                sb.append(" ");
            }
            sb.append(this.extractDynamicContent(dynamicElementElement));
        }
        return sb.toString();
    }

    protected String extractDynamicContent(String content) {
        try {
            com.liferay.portal.kernel.xml.Document document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            return this.extractDynamicContent(rootElement);
        }
        catch (DocumentException de) {
            _log.error((Throwable)de);
            return "";
        }
    }

    protected String extractStaticContent(String content) {
        content = StringUtil.replace((String)content, (String)"<![CDATA[", (String)"");
        content = StringUtil.replace((String)content, (String)"]]>", (String)"");
        content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        content = StringUtil.replace((String)content, (String)"&lt;", (String)"<");
        content = StringUtil.replace((String)content, (String)"&gt;", (String)">");
        return content;
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLocales((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected List<JournalArticle> getReindexApprovedArticles(long companyId, long startId, long endId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(JournalArticle.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"id");
        dynamicQuery.add(property.ge((Object)startId));
        dynamicQuery.add(property.lt((Object)endId));
        this.addReindexCriteria(dynamicQuery, companyId, 0);
        return JournalArticleLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
    }

    protected List<JournalArticle> getReindexDraftArticles(long companyId, long startId, long endId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(JournalArticle.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"id");
        dynamicQuery.add(property.ge((Object)startId));
        dynamicQuery.add(property.lt((Object)endId));
        this.addReindexCriteria(dynamicQuery, companyId, 1.0, 0);
        return JournalArticleLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
    }

    protected void indexField(Document document, Element element, String elType, String elIndexType) {
        if (Validator.isNull((String)elIndexType)) {
            return;
        }
        com.liferay.portal.kernel.xml.Document structureDocument = element.getDocument();
        Element rootElement = structureDocument.getRootElement();
        String defaultLocale = GetterUtil.getString((String)rootElement.attributeValue("default-locale"));
        String name = this.encodeFieldName(element.attributeValue("name"));
        List dynamicContentElements = element.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            String contentLocale = GetterUtil.getString((String)dynamicContentElement.attributeValue("language-id"));
            Object[] value = new String[]{dynamicContentElement.getText()};
            if (elType.equals("multi-list")) {
                List optionElements = dynamicContentElement.elements("option");
                value = new String[optionElements.size()];
                int i2 = 0;
                while (i2 < optionElements.size()) {
                    value[i2] = ((Element)optionElements.get(i2)).getText();
                    ++i2;
                }
            }
            if (elIndexType.equals("keyword")) {
                if (Validator.isNull((String)contentLocale)) {
                    document.addKeyword(name, (String[])value);
                    continue;
                }
                if (defaultLocale.equals(contentLocale)) {
                    document.addKeyword(name, (String[])value);
                }
                document.addKeyword(name.concat("_").concat(contentLocale), (String[])value);
                continue;
            }
            if (!elIndexType.equals("text")) continue;
            if (Validator.isNull((String)contentLocale)) {
                document.addText(name, StringUtil.merge((Object[])value, (String)" "));
                continue;
            }
            if (defaultLocale.equals(contentLocale)) {
                document.addText(name, StringUtil.merge((Object[])value, (String)" "));
            }
            document.addText(name.concat("_").concat(contentLocale), StringUtil.merge((Object[])value, (String)" "));
        }
    }

    protected void processStructure(com.liferay.portal.kernel.xml.Document structureDocument, Document document, Element rootElement) throws Exception {
        LinkedList queue = new LinkedList(rootElement.elements());
        Element element = null;
        while ((element = (Element)queue.poll()) != null) {
            String path;
            Node structureNode;
            String elName = element.attributeValue("name", "");
            String elType = element.attributeValue("type", "");
            String elIndexType = element.attributeValue("index-type", "");
            if (structureDocument != null && (structureNode = structureDocument.selectSingleNode(path = element.getPath().concat("[@name='").concat(elName).concat("']"))) != null) {
                Element structureElement = (Element)structureNode;
                elType = structureElement.attributeValue("type", "");
                elIndexType = structureElement.attributeValue("index-type", "");
            }
            if (Validator.isNotNull((String)elType)) {
                this.indexField(document, element, elType, elIndexType);
            }
            queue.addAll(element.elements());
        }
    }

    protected void processStructure(JournalStructure structure, Document document, String content) {
        try {
            com.liferay.portal.kernel.xml.Document structureDocument = null;
            if (structure != null) {
                structureDocument = SAXReaderUtil.read((String)structure.getXsd());
            }
            com.liferay.portal.kernel.xml.Document contentDocument = SAXReaderUtil.read((String)content);
            Element rootElement = contentDocument.getRootElement();
            this.processStructure(structureDocument, document, rootElement);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected void reindexArticles(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(JournalArticle.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minIdProjection = ProjectionFactoryUtil.min((String)"id");
        Projection maxIdProjection = ProjectionFactoryUtil.max((String)"id");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minIdProjection);
        projectionList.add(maxIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId, 0);
        List results = JournalArticleLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxIds = (Object[])results.get(0);
        if (minAndMaxIds[0] == null || minAndMaxIds[1] == null) {
            return;
        }
        long minId = (Long)minAndMaxIds[0];
        long maxId = (Long)minAndMaxIds[1];
        long startId = minId;
        long endId = startId + 10000L;
        while (startId <= maxId) {
            this.reindexArticles(companyId, startId, endId);
            startId = endId;
            endId += 10000L;
        }
    }

    protected void reindexArticles(long companyId, long startId, long endId) throws Exception {
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        articles.addAll(this.getReindexApprovedArticles(companyId, startId, endId));
        articles.addAll(this.getReindexDraftArticles(companyId, startId, endId));
        if (articles.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(articles.size());
        for (JournalArticle article : articles) {
            JournalArticle latestArticle;
            if (!article.isIndexable() || article.isApproved() && !(latestArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)article.getResourcePrimKey(), (int)0)).isIndexable()) continue;
            Document document = this.getDocument(article);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

