/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.List;
import java.util.Locale;

public class LocaleTransformerListener
extends BaseTransformerListener {
    private static Log _log = LogFactoryUtil.getLog(LocaleTransformerListener.class);
    private String _requestedLocale = "";

    public String onOutput(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        return s;
    }

    public String onScript(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        s = StringUtil.replace((String)s, (String)"@language_id@", (String)this._requestedLocale);
        return s;
    }

    public String onXml(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        s = this.replace(s);
        return s;
    }

    protected void replace(Element root) {
        List elements = root.elements();
        int listIndex = elements.size() - 1;
        while (listIndex >= 0) {
            Element element = (Element)elements.get(listIndex);
            String languageId = element.attributeValue("language-id", this.getLanguageId());
            if (!languageId.equalsIgnoreCase(this.getLanguageId())) {
                root.remove(element);
            } else {
                this.replace(element);
            }
            --listIndex;
        }
    }

    protected String replace(String xml) {
        if (xml == null) {
            return xml;
        }
        this._requestedLocale = this.getLanguageId();
        try {
            Document document = SAXReaderUtil.read((String)xml);
            Element rootElement = document.getRootElement();
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
            String[] availableLocales = StringUtil.split((String)rootElement.attributeValue("available-locales", defaultLanguageId));
            String defaultLocale = rootElement.attributeValue("default-locale", defaultLanguageId);
            boolean supportedLocale = false;
            String[] stringArray = availableLocales;
            int n = availableLocales.length;
            int n2 = 0;
            while (n2 < n) {
                String availableLocale = stringArray[n2];
                if (availableLocale.equalsIgnoreCase(this.getLanguageId())) {
                    supportedLocale = true;
                    break;
                }
                ++n2;
            }
            if (!supportedLocale) {
                this.setLanguageId(defaultLocale);
            }
            this.replace(rootElement);
            xml = DDMXMLUtil.formatXML((Document)document);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return xml;
    }
}

