/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class TokensTransformerListener
extends BaseTransformerListener {
    public static final String TEMP_ESCAPED_AT_CLOSE = "[$_TEMP_ESCAPED_AT_CLOSE$]";
    public static final String TEMP_ESCAPED_AT_OPEN = "[$TEMP_ESCAPED_AT_OPEN$]";
    private static Log _log = LogFactoryUtil.getLog(TokensTransformerListener.class);

    public String onOutput(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        return this.replace(s);
    }

    public String onScript(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return s;
    }

    public String onXml(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        return s;
    }

    protected String replace(String s) {
        Map tokens = this.getTokens();
        Set tokensSet = tokens.entrySet();
        if (tokensSet.size() == 0) {
            return s;
        }
        ArrayList<String> escapedKeysList = new ArrayList<String>();
        ArrayList<String> escapedValuesList = new ArrayList<String>();
        ArrayList<String> keysList = new ArrayList<String>();
        ArrayList<String> valuesList = new ArrayList<String>();
        ArrayList<String> tempEscapedKeysList = new ArrayList<String>();
        ArrayList<String> tempEscapedValuesList = new ArrayList<String>();
        for (Map.Entry entry : tokensSet) {
            String key = (String)entry.getKey();
            String value = GetterUtil.getString((String)((String)entry.getValue()));
            if (!Validator.isNotNull((String)key)) continue;
            String escapedKey = "@@" + key + "@" + "@";
            String actualKey = "@" + key + "@";
            String tempEscapedKey = TEMP_ESCAPED_AT_OPEN + key + TEMP_ESCAPED_AT_CLOSE;
            escapedKeysList.add(escapedKey);
            escapedValuesList.add(tempEscapedKey);
            keysList.add(actualKey);
            valuesList.add(value);
            tempEscapedKeysList.add(tempEscapedKey);
            tempEscapedValuesList.add(actualKey);
        }
        s = StringUtil.replace((String)s, (String[])escapedKeysList.toArray(new String[escapedKeysList.size()]), (String[])escapedValuesList.toArray(new String[escapedValuesList.size()]));
        s = StringUtil.replace((String)s, (String[])keysList.toArray(new String[keysList.size()]), (String[])valuesList.toArray(new String[valuesList.size()]));
        s = StringUtil.replace((String)s, (String[])tempEscapedKeysList.toArray(new String[tempEscapedKeysList.size()]), (String[])tempEscapedValuesList.toArray(new String[tempEscapedValuesList.size()]));
        return s;
    }
}

