/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import java.io.Reader;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIResolver
implements javax.xml.transform.URIResolver {
    private static final String _GET_TEMPLATE_PATH = "/c/journal/get_template?template_id=";
    private static Log _log = LogFactoryUtil.getLog(URIResolver.class);
    private String _languageId;
    private Map<String, String> _tokens;

    public URIResolver(Map<String, String> tokens, String languageId) {
        this._tokens = tokens;
        this._languageId = languageId;
    }

    @Override
    public Source resolve(String href, String base) {
        try {
            String content = null;
            int templatePathIndex = href.indexOf(_GET_TEMPLATE_PATH);
            if (templatePathIndex >= 0) {
                int templateIdIndex = templatePathIndex + _GET_TEMPLATE_PATH.length();
                long groupId = GetterUtil.getLong((String)this._tokens.get("group_id"));
                String templateId = href.substring(templateIdIndex);
                content = JournalUtil.getTemplateScript(groupId, templateId, this._tokens, this._languageId);
            } else {
                content = HttpUtil.URLtoString((String)href);
            }
            return new StreamSource((Reader)new UnsyncStringReader(content));
        }
        catch (Exception exception) {
            _log.error((Object)(String.valueOf(href) + " does not reference a valid template"));
            return null;
        }
    }
}

