/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.templateparser.BaseTemplateParser;
import com.liferay.portal.kernel.templateparser.TemplateContext;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ContentUtil;
import com.liferay.util.PwdGenerator;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.VelocityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTemplateParser
extends BaseTemplateParser {
    protected String getErrorTemplateContent() {
        return ContentUtil.get((String)PropsValues.JOURNAL_ERROR_TEMPLATE_VELOCITY);
    }

    protected String getErrorTemplateId() {
        return PropsValues.JOURNAL_ERROR_TEMPLATE_VELOCITY;
    }

    protected String getJournalTemplatesPath() {
        StringBundler sb = new StringBundler(5);
        sb.append("_JOURNAL_CONTEXT_");
        sb.append("/");
        sb.append(this.getCompanyId());
        sb.append("/");
        sb.append(this.getGroupId());
        return sb.toString();
    }

    protected TemplateContext getTemplateContext() throws Exception {
        return VelocityEngineUtil.getWrappedRestrictedToolsContext();
    }

    protected List<TemplateNode> getTemplateNodes(Element element) throws Exception {
        ArrayList<TemplateNode> templateNodes = new ArrayList<TemplateNode>();
        HashMap<String, TemplateNode> prototypeTemplateNodes = new HashMap<String, TemplateNode>();
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            String name;
            Element dynamicContentElement = dynamicElementElement.element("dynamic-content");
            String data = "";
            if (dynamicContentElement != null) {
                data = dynamicContentElement.getText();
            }
            if ((name = dynamicElementElement.attributeValue("name", "")).length() == 0) {
                throw new TransformException("Element missing \"name\" attribute");
            }
            String type = dynamicElementElement.attributeValue("type", "");
            TemplateNode templateNode = new TemplateNode(this.getThemeDisplay(), name, this.stripCDATA(data), type);
            if (dynamicElementElement.element("dynamic-element") != null) {
                templateNode.appendChildren(this.getTemplateNodes(dynamicElementElement));
            } else if (dynamicContentElement != null && dynamicContentElement.element("option") != null) {
                List optionElements = dynamicContentElement.elements("option");
                for (Element optionElement : optionElements) {
                    templateNode.appendOption(this.stripCDATA(optionElement.getText()));
                }
            }
            TemplateNode prototypeTemplateNode = (TemplateNode)prototypeTemplateNodes.get(name);
            if (prototypeTemplateNode == null) {
                prototypeTemplateNode = templateNode;
                prototypeTemplateNodes.put(name, prototypeTemplateNode);
                templateNodes.add(templateNode);
            }
            prototypeTemplateNode.appendSibling(templateNode);
        }
        return templateNodes;
    }

    protected boolean mergeTemplate(TemplateContext templateContext, UnsyncStringWriter unsyncStringWriter) throws Exception {
        VelocityContext velocityContext = (VelocityContext)templateContext;
        try {
            return VelocityEngineUtil.mergeTemplate((String)this.getTemplateId(), (String)this.getScript(), (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
        }
        catch (VelocityException ve) {
            String errorTemplateId = this.getErrorTemplateId();
            String errorTemplateContent = this.getErrorTemplateContent();
            velocityContext.put("exception", (Object)ve.getMessage());
            velocityContext.put("script", (Object)this.getScript());
            if (ve instanceof ParseErrorException) {
                ParseErrorException pee = (ParseErrorException)ve;
                velocityContext.put("column", (Object)pee.getColumnNumber());
                velocityContext.put("line", (Object)pee.getLineNumber());
            }
            unsyncStringWriter.reset();
            return VelocityEngineUtil.mergeTemplate((String)errorTemplateId, (String)errorTemplateContent, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
        }
    }

    protected void populateTemplateContext(TemplateContext templateContext) throws Exception {
        super.populateTemplateContext(templateContext);
        templateContext.put("journalTemplatesPath", (Object)this.getJournalTemplatesPath());
        String randomNamespace = String.valueOf(PwdGenerator.getPassword((String)"abcdefghijklmnopqrstuvwxyz", (int)4)) + "_";
        templateContext.put("randomNamespace", (Object)randomNamespace);
    }

    protected String stripCDATA(String s) {
        if (s.startsWith("<![CDATA[") && s.endsWith("]]>")) {
            s = s.substring("<![CDATA[".length(), s.length() - "]]>".length());
        }
        return s;
    }
}

