/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.templateparser.TemplateContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.util.URIResolver;
import com.liferay.portlet.journal.util.VelocityTemplateParser;
import com.liferay.portlet.journal.util.XSLContext;
import com.liferay.portlet.journal.util.XSLErrorListener;
import com.liferay.util.ContentUtil;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTemplateParser
extends VelocityTemplateParser {
    private TransformerFactory _transformerFactory;
    private XSLErrorListener _xslErrorListener;

    protected String getErrorTemplateContent() {
        return ContentUtil.get((String)PropsValues.JOURNAL_ERROR_TEMPLATE_XSL);
    }

    protected TemplateContext getTemplateContext() throws Exception {
        return this._getTemplateContext(this.getScript());
    }

    protected boolean mergeTemplate(TemplateContext templateContext, UnsyncStringWriter unsyncStringWriter) throws Exception {
        StreamSource xmlSource = new StreamSource((Reader)new UnsyncStringReader(this.getXML()));
        XSLContext xslContext = (XSLContext)templateContext;
        Transformer transformer = xslContext.getTransformer();
        try {
            transformer.transform(xmlSource, new StreamResult((Writer)unsyncStringWriter));
        }
        catch (Exception exception) {
            String errorTemplateContent = this.getErrorTemplateContent();
            XSLContext errorXSLContext = (XSLContext)this._getTemplateContext(errorTemplateContent);
            this.populateTemplateContext(errorXSLContext);
            Transformer errorTransformer = errorXSLContext.getTransformer();
            XSLErrorListener xslErrorListener = this._getXSLErrorListener();
            errorTransformer.setParameter("exception", xslErrorListener.getMessageAndLocation());
            errorTransformer.setParameter("script", this.getScript());
            if (xslErrorListener.getLocation() != null) {
                errorTransformer.setParameter("column", new Integer(xslErrorListener.getColumnNumber()));
                errorTransformer.setParameter("line", new Integer(xslErrorListener.getLineNumber()));
            }
            unsyncStringWriter.reset();
            errorTransformer.transform(xmlSource, new StreamResult((Writer)unsyncStringWriter));
        }
        return true;
    }

    private TemplateContext _getTemplateContext(String script) throws Exception {
        TransformerFactory transformerFactory = this._getTransformerFactory();
        StreamSource scriptSource = new StreamSource((Reader)new UnsyncStringReader(script));
        return new XSLContext(transformerFactory.newTransformer(scriptSource));
    }

    private TransformerFactory _getTransformerFactory() {
        if (this._transformerFactory == null) {
            this._transformerFactory = TransformerFactory.newInstance();
            this._transformerFactory.setErrorListener(this._getXSLErrorListener());
            this._transformerFactory.setURIResolver(new URIResolver(this.getTokens(), this.getLanguageId()));
        }
        return this._transformerFactory;
    }

    private XSLErrorListener _getXSLErrorListener() {
        if (this._xslErrorListener == null) {
            Locale locale = LocaleUtil.fromLanguageId((String)this.getLanguageId());
            this._xslErrorListener = new XSLErrorListener(locale);
        }
        return this._xslErrorListener;
    }
}

