/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent.action;

import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String[] extensions = actionRequest.getParameterValues("extensions");
        this.setPreference((PortletRequest)actionRequest, "extensions", extensions);
        super.processAction(portletConfig, actionRequest, actionResponse);
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            this.updateContentSearch((PortletRequest)actionRequest);
            this.updateLayout((PortletRequest)actionRequest);
        }
    }

    protected String getArticleId(PortletRequest portletRequest) {
        String articleId = this.getParameter(portletRequest, "articleId");
        return articleId.toUpperCase();
    }

    protected String getRuntimePortletId(String xml) throws Exception {
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        String instanceId = rootElement.attributeValue("instance");
        String portletId = rootElement.attributeValue("name");
        if (Validator.isNotNull((String)instanceId)) {
            portletId = String.valueOf(portletId) + "_INSTANCE_" + instanceId;
        }
        return portletId;
    }

    protected String getRuntimePortletIds(String content) throws Exception {
        StringBundler sb = new StringBundler();
        int index = 0;
        while ((index = content.indexOf("<runtime-portlet", index)) != -1) {
            int close1 = content.indexOf("</runtime-portlet>", index);
            int close2 = content.indexOf("/>", index);
            int closeIndex = -1;
            closeIndex = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + "</runtime-portlet>".length() : close2 + "/>".length();
            if (closeIndex == -1) break;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getRuntimePortletId(content.substring(index, closeIndex)));
            index = closeIndex;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    protected String getRuntimePortletIds(ThemeDisplay themeDisplay, String articleId) throws Exception {
        JournalArticle journalArticle = null;
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)themeDisplay.getCompanyId());
        try {
            journalArticle = JournalArticleLocalServiceUtil.getDisplayArticle((long)themeDisplay.getScopeGroupId(), (String)articleId);
        }
        catch (NoSuchArticleException noSuchArticleException) {}
        if (journalArticle == null) {
            try {
                journalArticle = JournalArticleLocalServiceUtil.getDisplayArticle((long)companyGroup.getGroupId(), (String)articleId);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                return null;
            }
        }
        String portletIds = this.getRuntimePortletIds(journalArticle.getContent());
        if (Validator.isNotNull((String)journalArticle.getTemplateId())) {
            JournalTemplate journalTemplate = null;
            try {
                journalTemplate = JournalTemplateLocalServiceUtil.getTemplate((long)themeDisplay.getScopeGroupId(), (String)journalArticle.getTemplateId());
            }
            catch (NoSuchTemplateException noSuchTemplateException) {
                journalTemplate = JournalTemplateLocalServiceUtil.getTemplate((long)companyGroup.getGroupId(), (String)journalArticle.getTemplateId());
            }
            portletIds = StringUtil.add((String)portletIds, (String)this.getRuntimePortletIds(journalTemplate.getXsl()));
        }
        return portletIds;
    }

    protected void updateContentSearch(PortletRequest portletRequest) throws Exception {
        String articleId = this.getArticleId(portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        String portletResource = ParamUtil.getString((PortletRequest)portletRequest, (String)"portletResource");
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletResource, (String)articleId, (boolean)true);
    }

    protected void updateLayout(PortletRequest portletRequest) throws Exception {
        String articleId = this.getArticleId(portletRequest);
        if (Validator.isNull((String)articleId)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        String portletResource = ParamUtil.getString((PortletRequest)portletRequest, (String)"portletResource");
        layoutTypePortlet.setPortletIds("runtime-column-" + portletResource, this.getRuntimePortletIds(themeDisplay, articleId));
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }
}

