/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent.action;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class ExportArticleAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(ExportArticleAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
            String targetExtension = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetExtension");
            PortletPreferences preferences = actionRequest.getPreferences();
            String[] allowedExtensions = preferences.getValues("extensions", null);
            String languageId = LanguageUtil.getLanguageId((PortletRequest)actionRequest);
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            this.getFile(groupId, articleId, targetExtension, allowedExtensions, languageId, themeDisplay, request, response);
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    protected void getFile(long groupId, String articleId, String targetExtension, String[] allowedExtensions, String languageId, ThemeDisplay themeDisplay, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String id;
            File convertedFile;
            JournalArticleDisplay articleDisplay = JournalContentUtil.getDisplay((long)groupId, (String)articleId, null, (String)languageId, (ThemeDisplay)themeDisplay);
            int pages = articleDisplay.getNumberOfPages();
            StringBundler sb = new StringBundler(pages + 12);
            sb.append("<html>");
            sb.append("<head>");
            sb.append("<meta content=\"");
            sb.append("text/html; charset=UTF-8");
            sb.append("\" http-equiv=\"content-type\" />");
            sb.append("<base href=\"");
            sb.append(themeDisplay.getPortalURL());
            sb.append("\" />");
            sb.append("</head>");
            sb.append("<body>");
            sb.append(articleDisplay.getContent());
            int i2 = 2;
            while (i2 <= pages) {
                articleDisplay = JournalContentUtil.getDisplay((long)groupId, (String)articleId, (String)"export", (String)languageId, (ThemeDisplay)themeDisplay, (int)i2);
                sb.append(articleDisplay.getContent());
                ++i2;
            }
            sb.append("</body>");
            sb.append("</html>");
            Object is = new UnsyncByteArrayInputStream(sb.toString().getBytes("UTF-8"));
            String title = articleDisplay.getTitle();
            String sourceExtension = "html";
            String fileName = title.concat(".").concat(sourceExtension);
            if (Validator.isNotNull((String)targetExtension) && ArrayUtil.contains((Object[])allowedExtensions, (Object)targetExtension) && (convertedFile = DocumentConversionUtil.convert(id = DLUtil.getTempFileId((long)articleDisplay.getId(), (String)String.valueOf(articleDisplay.getVersion()), (String)languageId), (InputStream)is, sourceExtension, targetExtension)) != null) {
                fileName = title.concat(".").concat(targetExtension);
                is = new FileInputStream(convertedFile);
            }
            String contentType = MimeTypesUtil.getContentType((String)fileName);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (String)contentType);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }
}

