/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UpdateArticleFieldAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(UpdateArticleFieldAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.updateArticleField(request, response);
            return null;
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected void updateArticleField(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path;
        Node node;
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        String articleId = ParamUtil.getString((HttpServletRequest)request, (String)"articleId");
        double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version");
        String containerId = ParamUtil.getString((HttpServletRequest)request, (String)"containerId");
        if (Validator.isNotNull((String)containerId)) {
            int x = containerId.indexOf("_");
            int y = containerId.lastIndexOf("_");
            if (x != -1 && y != -1) {
                groupId = GetterUtil.getLong((String)containerId.substring(0, x));
                articleId = containerId.substring(x + 1, y);
                version = GetterUtil.getDouble((String)containerId.substring(y));
            }
        }
        String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
        String fieldName = ParamUtil.getString((HttpServletRequest)request, (String)"fieldName");
        String fieldData = ParamUtil.getString((HttpServletRequest)request, (String)"fieldData");
        if (fieldName.startsWith("journal-content-field-name-")) {
            fieldName = fieldName.substring(27);
        }
        JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
        String content = article.getContent();
        Document doc = SAXReaderUtil.read((String)content);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Before\n" + content));
        }
        if ((node = doc.selectSingleNode(path = "/root/dynamic-element[@name='" + fieldName + "']/dynamic-content[@language-id='" + languageId + "']")) == null) {
            path = "/root/dynamic-element[@name='" + fieldName + "']/dynamic-content";
            node = doc.selectSingleNode(path);
        }
        node.setText(fieldData);
        content = DDMXMLUtil.formatXML((Document)doc);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("After\n" + content));
        }
        JournalArticleServiceUtil.updateContent((long)groupId, (String)articleId, (double)version, (String)content);
        ServletResponseUtil.write((HttpServletResponse)response, (String)fieldData);
    }
}

