/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PipingPageContext;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.kernel.velocity.VelocityVariablesUtil;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.PortletDisplayFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.layoutconfiguration.util.RuntimePortlet;
import com.liferay.portlet.layoutconfiguration.util.RuntimePortletUtil;
import com.liferay.portlet.layoutconfiguration.util.velocity.CustomizationSettingsProcessor;
import com.liferay.portlet.layoutconfiguration.util.velocity.TemplateProcessor;
import com.liferay.portlet.layoutconfiguration.util.xml.ActionURLLogic;
import com.liferay.portlet.layoutconfiguration.util.xml.PortletLogic;
import com.liferay.portlet.layoutconfiguration.util.xml.RenderURLLogic;
import com.liferay.portlet.layoutconfiguration.util.xml.RuntimeLogic;
import com.liferay.taglib.util.VelocityTaglib;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class RuntimePortletImpl
implements RuntimePortlet {
    private static Log _log = LogFactoryUtil.getLog(RuntimePortletUtil.class);

    public String processCustomizationSettings(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, String velocityTemplateId, String velocityTemplateContent) throws Exception {
        return this.doDispatch(servletContext, request, response, pageContext, null, null, velocityTemplateId, velocityTemplateContent, false);
    }

    public String processPortlet(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Portlet portlet, String queryString, String columnId, Integer columnPos, Integer columnCount, String path, boolean writeOutput) throws Exception {
        return this.processPortlet(servletContext, request, response, null, null, portlet, portlet.getPortletId(), queryString, columnId, columnPos, columnCount, path, writeOutput);
    }

    public String processPortlet(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, RenderRequest renderRequest, RenderResponse renderResponse, Portlet portlet, String portletId, String queryString, String columnId, Integer columnPos, Integer columnCount, String path, boolean writeOutput) throws Exception {
        String instanceId;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (portlet == null) {
            portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        }
        if (!(portlet == null || !portlet.isInstanceable() || portlet.isAddDefaultResource() || Validator.isNotNull((String)(instanceId = portlet.getInstanceId())) && Validator.isPassword((String)instanceId) && instanceId.length() >= 4)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Portlet " + portlet.getPortletId() + " is instanceable but does not have a " + "valid instance id"));
            }
            portlet = null;
        }
        if (portlet == null) {
            return "";
        }
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        PortletDisplay portletDisplayClone = PortletDisplayFactory.create();
        portletDisplay.copyTo(portletDisplayClone);
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        String lifecycle = (String)request.getAttribute("javax.portlet.lifecycle_phase");
        try {
            String string = PortalUtil.renderPortlet((ServletContext)servletContext, (HttpServletRequest)request, (HttpServletResponse)response, (Portlet)portlet, (String)queryString, (String)columnId, (Integer)columnPos, (Integer)columnCount, (String)path, (boolean)writeOutput);
            return string;
        }
        finally {
            portletDisplay.copyFrom(portletDisplayClone);
            portletDisplayClone.recycle();
            RuntimePortletImpl._defineObjects(request, portletConfig, renderRequest, renderResponse);
            if (lifecycle != null) {
                request.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
            }
        }
    }

    public String processPortlet(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, RenderRequest renderRequest, RenderResponse renderResponse, String portletId, String queryString, boolean writeOutput) throws Exception {
        return this.processPortlet(servletContext, request, response, renderRequest, renderResponse, portletId, queryString, null, null, null, writeOutput);
    }

    public String processPortlet(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, RenderRequest renderRequest, RenderResponse renderResponse, String portletId, String queryString, String columnId, Integer columnPos, Integer columnCount, boolean writeOutput) throws Exception {
        return this.processPortlet(servletContext, request, response, renderRequest, renderResponse, null, portletId, queryString, columnId, columnPos, columnCount, null, writeOutput);
    }

    public void processTemplate(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, JspWriter jspWriter, String velocityTemplateId, String velocityTemplateContent) throws Exception {
        this.processTemplate(servletContext, request, response, pageContext, jspWriter, null, velocityTemplateId, velocityTemplateContent);
    }

    public void processTemplate(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, JspWriter jspWriter, String portletId, String velocityTemplateId, String velocityTemplateContent) throws Exception {
        this.doDispatch(servletContext, request, response, pageContext, jspWriter, portletId, velocityTemplateId, velocityTemplateContent, true);
    }

    public String processXML(HttpServletRequest request, String content, RuntimeLogic runtimeLogic) throws Exception {
        if (Validator.isNull((String)content)) {
            return "";
        }
        int index = content.indexOf(runtimeLogic.getOpenTag());
        if (index == -1) {
            return content;
        }
        Portlet renderPortlet = (Portlet)request.getAttribute("RENDER_PORTLET");
        Boolean renderPortletResource = (Boolean)request.getAttribute("RENDER_PORTLET_RESOURCE");
        String outerPortletId = (String)request.getAttribute("OUTER_PORTLET_ID");
        if (outerPortletId == null) {
            request.setAttribute("OUTER_PORTLET_ID", (Object)renderPortlet.getPortletId());
        }
        try {
            request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
            StringBundler sb = new StringBundler();
            int x = 0;
            int y = index;
            while (y != -1) {
                sb.append(content.substring(x, y));
                int close1 = content.indexOf(runtimeLogic.getClose1Tag(), y);
                int close2 = content.indexOf(runtimeLogic.getClose2Tag(), y);
                x = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + runtimeLogic.getClose1Tag().length() : close2 + runtimeLogic.getClose2Tag().length();
                sb.append(runtimeLogic.processXML(content.substring(y, x)));
                y = content.indexOf(runtimeLogic.getOpenTag(), x);
            }
            if (y == -1) {
                sb.append(content.substring(x));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (outerPortletId == null) {
                request.removeAttribute("OUTER_PORTLET_ID");
            }
            request.setAttribute("RENDER_PORTLET", (Object)renderPortlet);
            if (renderPortletResource == null) {
                request.removeAttribute("RENDER_PORTLET_RESOURCE");
            } else {
                request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)renderPortletResource);
            }
        }
    }

    public String processXML(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, RenderRequest renderRequest, RenderResponse renderResponse, String content) throws Exception {
        PortletLogic portletLogic = new PortletLogic(servletContext, request, response, renderRequest, renderResponse);
        ActionURLLogic actionURLLogic = new ActionURLLogic(renderResponse);
        RenderURLLogic renderURLLogic = new RenderURLLogic(renderResponse);
        content = RuntimePortletUtil.processXML((HttpServletRequest)request, (String)content, (RuntimeLogic)portletLogic);
        content = RuntimePortletUtil.processXML((HttpServletRequest)request, (String)content, (RuntimeLogic)actionURLLogic);
        content = RuntimePortletUtil.processXML((HttpServletRequest)request, (String)content, (RuntimeLogic)renderURLLogic);
        return content;
    }

    protected Object buildVelocityTaglib(HttpServletRequest request, HttpServletResponse response, PageContext pageContext) throws Exception {
        Class<?> clazz = Class.forName(VelocityTaglib.class.getName());
        Constructor<?> constructor = clazz.getConstructor(ServletContext.class, HttpServletRequest.class, HttpServletResponse.class, PageContext.class);
        return constructor.newInstance(pageContext.getServletContext(), request, response, pageContext);
    }

    protected String doDispatch(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, JspWriter jspWriter, String portletId, String velocityTemplateId, String velocityTemplateContent, boolean processTemplate) throws Exception {
        if (Validator.isNull((String)velocityTemplateContent)) {
            return null;
        }
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(velocityTemplateId);
        String pluginServletContextName = GetterUtil.getString((String)layoutTemplate.getServletContextName());
        ServletContext pluginServletContext = ServletContextPool.get((String)pluginServletContextName);
        ClassLoader pluginClassLoader = null;
        if (pluginServletContext != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        PACLPolicy contextClassLoaderPACLPolicy = PACLPolicyManager.getPACLPolicy(contextClassLoader);
        PACLPolicy pluginClassLoaderPACLPolicy = PACLPolicyManager.getPACLPolicy(pluginClassLoader);
        try {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                PACLClassLoaderUtil.setContextClassLoader(pluginClassLoader);
                PortalSecurityManagerThreadLocal.setPACLPolicy(pluginClassLoaderPACLPolicy);
            }
            if (processTemplate) {
                this.doProcessTemplate(servletContext, request, response, pageContext, jspWriter, portletId, velocityTemplateId, velocityTemplateContent);
            } else {
                String string = this.doProcessCustomizationSettings(servletContext, request, response, pageContext, velocityTemplateId, velocityTemplateContent);
                return string;
            }
            return null;
        }
        finally {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                PortalSecurityManagerThreadLocal.setPACLPolicy(contextClassLoaderPACLPolicy);
                PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected String doProcessCustomizationSettings(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, String velocityTemplateId, String velocityTemplateContent) throws Exception {
        if (Validator.isNull((String)velocityTemplateContent)) {
            return "";
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        CustomizationSettingsProcessor processor = new CustomizationSettingsProcessor(request, (PageContext)new PipingPageContext(pageContext, (Writer)unsyncStringWriter), (Writer)unsyncStringWriter);
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedClassLoaderToolsContext();
        velocityContext.put("processor", (Object)processor);
        VelocityVariablesUtil.insertVariables((VelocityContext)velocityContext, (HttpServletRequest)request);
        Object velocityTaglib = this.buildVelocityTaglib(request, response, pageContext);
        velocityContext.put("taglibLiferay", velocityTaglib);
        velocityContext.put("theme", velocityTaglib);
        try {
            VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, (String)velocityTemplateContent, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw e2;
        }
        return unsyncStringWriter.toString();
    }

    protected void doProcessTemplate(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, JspWriter jspWriter, String portletId, String velocityTemplateId, String velocityTemplateContent) throws Exception {
        if (Validator.isNull((String)velocityTemplateContent)) {
            return;
        }
        TemplateProcessor processor = new TemplateProcessor(servletContext, request, response, portletId);
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedClassLoaderToolsContext();
        velocityContext.put("processor", (Object)processor);
        VelocityVariablesUtil.insertVariables((VelocityContext)velocityContext, (HttpServletRequest)request);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Object velocityTaglib = this.buildVelocityTaglib(request, response, pageContext);
        velocityContext.put("taglibLiferay", velocityTaglib);
        velocityContext.put("theme", velocityTaglib);
        try {
            VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, (String)velocityTemplateContent, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw e2;
        }
        String output = unsyncStringWriter.toString();
        Map<Portlet, Object[]> portletsMap = processor.getPortletsMap();
        HashMap<String, StringBundler> contentsMap = new HashMap<String, StringBundler>(portletsMap.size());
        for (Map.Entry<Portlet, Object[]> entry : portletsMap.entrySet()) {
            Portlet portlet = entry.getKey();
            Object[] value = entry.getValue();
            String queryString = (String)value[0];
            String columnId = (String)value[1];
            Integer columnPos = (Integer)value[2];
            Integer columnCount = (Integer)value[3];
            UnsyncStringWriter portletUnsyncStringWriter = new UnsyncStringWriter();
            PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)portletUnsyncStringWriter);
            this.processPortlet(servletContext, request, (HttpServletResponse)pipingServletResponse, portlet, queryString, columnId, columnPos, columnCount, null, true);
            contentsMap.put(portlet.getPortletId(), portletUnsyncStringWriter.getStringBundler());
        }
        StringBundler sb = StringUtil.replaceWithStringBundler((String)output, (String)"[$TEMPLATE_PORTLET_", (String)"$]", contentsMap);
        sb.writeTo((Writer)jspWriter);
    }

    protected LayoutTemplate getLayoutTemplate(String velocityTemplateId) {
        String separator = "_CUSTOM_";
        boolean standard = false;
        if (velocityTemplateId.contains("_STANDARD_")) {
            separator = "_STANDARD_";
            standard = true;
        }
        String layoutTemplateId = null;
        String themeId = null;
        int pos = velocityTemplateId.indexOf(separator);
        if (pos != -1) {
            layoutTemplateId = velocityTemplateId.substring(pos + separator.length());
            themeId = velocityTemplateId.substring(0, pos);
        }
        if ((pos = layoutTemplateId.indexOf("_INSTANCE_")) != -1) {
            layoutTemplateId = layoutTemplateId.substring(pos + "_INSTANCE_".length() + 1);
            pos = layoutTemplateId.indexOf("_");
            layoutTemplateId = layoutTemplateId.substring(pos + 1);
        }
        return LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)standard, themeId);
    }

    private static void _defineObjects(HttpServletRequest request, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) {
        if (portletConfig != null) {
            request.setAttribute("javax.portlet.config", (Object)portletConfig);
        }
        if (renderRequest != null) {
            request.setAttribute("javax.portlet.request", (Object)renderRequest);
        }
        if (renderResponse != null) {
            request.setAttribute("javax.portlet.response", (Object)renderResponse);
        }
    }
}

