/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.CustomizedPages;
import com.liferay.portal.model.Layout;
import com.liferay.portlet.layoutconfiguration.util.velocity.ColumnProcessor;
import com.liferay.portlet.sites.util.SitesUtil;
import com.liferay.taglib.aui.InputTag;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class CustomizationSettingsProcessor
implements ColumnProcessor {
    private boolean _customizationEnabled;
    private UnicodeProperties _layoutTypeSettings;
    private PageContext _pageContext;
    private HttpServletRequest _request;
    private Writer _writer;

    public CustomizationSettingsProcessor(HttpServletRequest request, PageContext pageContext, Writer writer) {
        this._pageContext = pageContext;
        this._request = request;
        this._writer = writer;
        Layout selLayout = (Layout)this._request.getAttribute("edit_pages.jsp-selLayout");
        this._layoutTypeSettings = selLayout.getTypeSettingsProperties();
        this._customizationEnabled = true;
        if (!SitesUtil.isLayoutUpdateable(selLayout)) {
            this._customizationEnabled = false;
        }
        if (selLayout.isLayoutPrototypeLinkActive()) {
            this._customizationEnabled = false;
        }
    }

    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    public String processColumn(String columnId, String classNames) throws Exception {
        String customizableKey = CustomizedPages.namespaceColumnId((String)columnId);
        boolean customizable = false;
        if (this._customizationEnabled) {
            customizable = GetterUtil.getBoolean((String)this._layoutTypeSettings.getProperty(customizableKey, String.valueOf(false)));
        }
        this._writer.append("<div class=\"");
        this._writer.append(classNames);
        this._writer.append("\">");
        this._writer.append("<h1>");
        this._writer.append(columnId);
        this._writer.append("</h1>");
        InputTag inputTag = new InputTag();
        inputTag.setDisabled(!this._customizationEnabled);
        inputTag.setLabel("customizable");
        inputTag.setName("TypeSettingsProperties--".concat(customizableKey).concat("--"));
        inputTag.setPageContext(this._pageContext);
        inputTag.setType("checkbox");
        inputTag.setValue((Object)customizable);
        int result = inputTag.doStartTag();
        if (result == 1) {
            inputTag.doEndTag();
        }
        this._writer.append("</div>");
        return "";
    }

    public String processMax() throws Exception {
        return this.processMax("");
    }

    public String processMax(String classNames) throws Exception {
        return "";
    }

    public String processPortlet(String portletId) throws Exception {
        this._writer.append("<div class=\"portlet\">");
        this._writer.append(portletId);
        this._writer.append("</div>");
        return "";
    }
}

