/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.PortletRenderWeightComparator;
import com.liferay.portlet.layoutconfiguration.util.RuntimePortletUtil;
import com.liferay.portlet.layoutconfiguration.util.velocity.ColumnProcessor;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProcessor
implements ColumnProcessor {
    private static Log _log = LogFactoryUtil.getLog(TemplateProcessor.class);
    private String _portletId;
    private Map<Portlet, Object[]> _portletsMap;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private ServletContext _servletContext;

    public TemplateProcessor(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String portletId) {
        this._servletContext = servletContext;
        this._request = request;
        this._response = response;
        this._portletId = portletId;
        this._portletsMap = new TreeMap<Portlet, Object[]>((Comparator<Portlet>)new PortletRenderWeightComparator());
    }

    public Map<Portlet, Object[]> getPortletsMap() {
        return this._portletsMap;
    }

    @Override
    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    @Override
    public String processColumn(String columnId, String classNames) throws Exception {
        boolean parallelRenderEnable = PropsValues.LAYOUT_PARALLEL_RENDER_ENABLE;
        if (parallelRenderEnable) {
            Boolean portletParallelRender;
            if (PropsValues.SESSION_DISABLED && _log.isWarnEnabled()) {
                _log.warn((Object)"Parallel rendering should be disabled if sessions are disabled");
            }
            if (Boolean.FALSE.equals(portletParallelRender = (Boolean)this._request.getAttribute("PORTLET_PARALLEL_RENDER"))) {
                parallelRenderEnable = false;
            }
        } else {
            this._request.removeAttribute("PORTLET_PARALLEL_RENDER");
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("THEME_DISPLAY");
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        List portlets = layoutTypePortlet.getAllPortlets(columnId);
        StringBundler sb = new StringBundler(portlets.size() + 11);
        sb.append("<div class=\"");
        sb.append("portlet-dropzone");
        if (layoutTypePortlet.isCustomizable() && layoutTypePortlet.isColumnDisabled(columnId)) {
            sb.append(" portlet-dropzone-disabled");
        }
        if (layoutTypePortlet.isColumnCustomizable(columnId)) {
            sb.append(" customizable");
        }
        if (portlets.isEmpty()) {
            sb.append(" empty");
        }
        if (Validator.isNotNull((String)classNames)) {
            sb.append(" ");
            sb.append(classNames);
        }
        sb.append("\" id=\"layout-column_");
        sb.append(columnId);
        sb.append("\">");
        int i2 = 0;
        while (i2 < portlets.size()) {
            Portlet portlet = (Portlet)portlets.get(i2);
            String queryString = null;
            Integer columnPos = new Integer(i2);
            Integer columnCount = new Integer(portlets.size());
            String path = null;
            if (parallelRenderEnable) {
                path = "/html/portal/load_render_portlet.jsp";
                if (portlet.getRenderWeight() >= 1) {
                    this._portletsMap.put(portlet, new Object[]{queryString, columnId, columnPos, columnCount});
                }
            }
            String content = RuntimePortletUtil.processPortlet((ServletContext)this._servletContext, (HttpServletRequest)this._request, (HttpServletResponse)this._response, (Portlet)portlet, queryString, (String)columnId, (Integer)columnPos, (Integer)columnCount, (String)path, (boolean)false);
            sb.append(content);
            ++i2;
        }
        sb.append("</div>");
        return sb.toString();
    }

    @Override
    public String processMax() throws Exception {
        return this.processMax("");
    }

    @Override
    public String processMax(String classNames) throws Exception {
        return RuntimePortletUtil.processPortlet((ServletContext)this._servletContext, (HttpServletRequest)this._request, (HttpServletResponse)this._response, null, null, (String)this._portletId, null, (boolean)false);
    }

    @Override
    public String processPortlet(String portletId) throws Exception {
        try {
            this._request.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
            String string = RuntimePortletUtil.processPortlet((ServletContext)this._servletContext, (HttpServletRequest)this._request, (HttpServletResponse)this._response, null, null, (String)this._portletId, null, (boolean)false);
            return string;
        }
        finally {
            this._request.removeAttribute("RENDER_PORTLET_RESOURCE");
        }
    }
}

