/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.ImageTypeException;
import com.liferay.portal.LayoutFriendlyURLException;
import com.liferay.portal.LayoutHiddenException;
import com.liferay.portal.LayoutNameException;
import com.liferay.portal.LayoutParentLayoutIdException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LayoutSetVirtualHostException;
import com.liferay.portal.LayoutTypeException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.RemoteOptionsException;
import com.liferay.portal.RequiredLayoutException;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.ThemeSetting;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ThemeImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.LayoutSettings;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.sites.action.ActionUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditLayoutsAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(EditLayoutsAction.class);

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            Object[] returnValue;
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
            Layout layout = null;
            String oldFriendlyURL = "";
            if (cmd.equals("add") || cmd.equals("update")) {
                returnValue = this.updateLayout(actionRequest, actionResponse);
                layout = (Layout)returnValue[0];
                oldFriendlyURL = (String)returnValue[1];
                redirect = this.updateCloseRedirect(redirect, null, layout, oldFriendlyURL);
                closeRedirect = this.updateCloseRedirect(closeRedirect, null, layout, oldFriendlyURL);
            } else if (cmd.equals("delete")) {
                returnValue = SitesUtil.deleteLayout(actionRequest, actionResponse);
                Group group = (Group)returnValue[0];
                oldFriendlyURL = (String)returnValue[1];
                long newRefererPlid = (Long)returnValue[2];
                redirect = this.updateCloseRedirect(redirect, group, null, oldFriendlyURL);
                redirect = HttpUtil.setParameter((String)redirect, (String)"refererPlid", (long)newRefererPlid);
                closeRedirect = this.updateCloseRedirect(closeRedirect, group, null, oldFriendlyURL);
            } else if (cmd.equals("copy_from_live")) {
                StagingUtil.copyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("display_order")) {
                this.updateDisplayOrder(actionRequest);
            } else if (cmd.equals("delete_layout_revision")) {
                this.deleteLayoutRevision(actionRequest);
            } else if (cmd.equals("enable")) {
                this.enableLayout(actionRequest);
            } else if (cmd.equals("publish_to_live")) {
                StagingUtil.publishToLive((PortletRequest)actionRequest);
            } else if (cmd.equals("publish_to_remote")) {
                StagingUtil.publishToRemote((PortletRequest)actionRequest);
            } else if (cmd.equals("reset_customized_view")) {
                LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
                if (layoutTypePortlet != null && layoutTypePortlet.isCustomizable() && layoutTypePortlet.isCustomizedView()) {
                    layoutTypePortlet.resetUserPreferences();
                }
            } else if (cmd.equals("reset_prototype")) {
                SitesUtil.resetPrototype(themeDisplay.getLayout());
            } else if (cmd.equals("schedule_copy_from_live")) {
                StagingUtil.scheduleCopyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("schedule_publish_to_live")) {
                StagingUtil.schedulePublishToLive((PortletRequest)actionRequest);
            } else if (cmd.equals("schedule_publish_to_remote")) {
                StagingUtil.schedulePublishToRemote((PortletRequest)actionRequest);
            } else if (cmd.equals("select_layout_set_branch")) {
                this.selectLayoutSetBranch(actionRequest);
            } else if (cmd.equals("select_layout_branch")) {
                this.selectLayoutBranch(actionRequest);
            } else if (cmd.equals("unschedule_copy_from_live")) {
                StagingUtil.unscheduleCopyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("unschedule_publish_to_live")) {
                StagingUtil.unschedulePublishToLive((PortletRequest)actionRequest);
            } else if (cmd.equals("unschedule_publish_to_remote")) {
                StagingUtil.unschedulePublishToRemote((PortletRequest)actionRequest);
            } else if (cmd.equals("update_layout_revision")) {
                this.updateLayoutRevision(actionRequest, themeDisplay);
            }
            if (Validator.isNotNull((String)closeRedirect)) {
                LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".closeRedirect"), (Object)closeRedirect);
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchLayoutException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.layouts_admin.error");
            }
            if (e2 instanceof ImageTypeException || e2 instanceof LayoutFriendlyURLException || e2 instanceof LayoutHiddenException || e2 instanceof LayoutNameException || e2 instanceof LayoutParentLayoutIdException || e2 instanceof LayoutSetVirtualHostException || e2 instanceof LayoutTypeException || e2 instanceof RequiredLayoutException || e2 instanceof UploadException) {
                if (e2 instanceof LayoutFriendlyURLException) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)LayoutFriendlyURLException.class.getName(), (Object)e2);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                }
            }
            if (e2 instanceof DuplicateLockException || e2 instanceof LayoutPrototypeException || e2 instanceof RemoteExportException || e2 instanceof RemoteOptionsException || e2 instanceof SystemException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.layouts_admin.error");
        }
        try {
            this.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.layouts_admin.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.edit_layouts"));
    }

    @Override
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = null;
        if (cmd.equals("PUBLISH_STAGING")) {
            portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/scheduled_publishing_events.jsp");
        } else if (cmd.equals("VIEW_TREE")) {
            this.getGroup((PortletRequest)resourceRequest);
            portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/tree_js.jsp");
        } else {
            this.getGroup((PortletRequest)resourceRequest);
            portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/view_resources.jsp");
        }
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void checkPermissions(PortletRequest portletRequest) throws Exception {
        Group group = this.getGroup(portletRequest);
        if (group == null) {
            throw new PrincipalException();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Layout layout = themeDisplay.getLayout();
        String cmd = ParamUtil.getString((PortletRequest)portletRequest, (String)"cmd");
        long selPlid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"selPlid");
        if (selPlid > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)selPlid);
        }
        if (cmd.equals("add")) {
            long parentPlid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"parentPlid");
            if (parentPlid == 0L) {
                if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"ADD_LAYOUT")) {
                    throw new PrincipalException();
                }
                return;
            }
            layout = LayoutLocalServiceUtil.getLayout((long)parentPlid);
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"ADD_LAYOUT")) {
                throw new PrincipalException();
            }
            return;
        }
        if (cmd.equals("delete")) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"DELETE")) {
                throw new PrincipalException();
            }
            return;
        }
        if (cmd.equals("reset_customized_view")) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE")) {
                throw new PrincipalException();
            }
            return;
        }
        if (cmd.equals("reset_prototype")) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE") || !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (String)"UPDATE")) {
                throw new PrincipalException();
            }
            return;
        }
        boolean hasUpdateLayoutPermission = false;
        if (layout != null) {
            hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
        }
        boolean hasPermission = true;
        if (cmd.equals("publish_to_live")) {
            boolean publishToLive;
            if (group.isSite()) {
                publishToLive = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"PUBLISH_STAGING");
                if (!hasUpdateLayoutPermission && !publishToLive) {
                    hasPermission = false;
                }
            } else if (group.isOrganization()) {
                publishToLive = OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getOrganizationId(), (String)"PUBLISH_STAGING");
                if (!hasUpdateLayoutPermission && !publishToLive) {
                    hasPermission = false;
                }
            }
        }
        if (group.isCompany()) {
            if (!permissionChecker.isCompanyAdmin()) {
                hasPermission = false;
            }
        } else if (group.isLayoutPrototype()) {
            LayoutPrototypePermissionUtil.check((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        } else if (group.isLayoutSetPrototype()) {
            LayoutSetPrototypePermissionUtil.check((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        } else if (group.isUser()) {
            long groupUserId = group.getClassPK();
            User groupUser = UserLocalServiceUtil.getUserById((long)groupUserId);
            long[] organizationIds = groupUser.getOrganizationIds();
            UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupUserId, (long[])organizationIds, (String)"UPDATE");
        }
        if (!hasPermission) {
            throw new PrincipalException();
        }
    }

    protected void deleteLayoutRevision(ActionRequest actionRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        long layoutRevisionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutRevisionId");
        LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
        LayoutRevisionLocalServiceUtil.deleteLayoutRevision((LayoutRevision)layoutRevision);
        boolean updateRecentLayoutRevisionId = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"updateRecentLayoutRevisionId");
        if (updateRecentLayoutRevisionId) {
            StagingUtil.setRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid(), (long)layoutRevision.getParentLayoutRevisionId());
        }
    }

    protected void deleteThemeSettingsProperties(UnicodeProperties typeSettingsProperties, String device) {
        String keyPrefix = ThemeSettingImpl.namespaceProperty(device);
        Set keys = typeSettingsProperties.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(keyPrefix)) continue;
            itr.remove();
        }
    }

    protected void enableLayout(ActionRequest actionRequest) throws Exception {
        long incompleteLayoutRevisionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"incompleteLayoutRevisionId");
        LayoutRevision incompleteLayoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)incompleteLayoutRevisionId);
        long layoutBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutBranchId", (long)incompleteLayoutRevision.getLayoutBranchId());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        serviceContext.setWorkflowAction(2);
        LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)incompleteLayoutRevision.getLayoutRevisionId(), (long)layoutBranchId, (String)incompleteLayoutRevision.getName(), (String)incompleteLayoutRevision.getTitle(), (String)incompleteLayoutRevision.getDescription(), (String)incompleteLayoutRevision.getKeywords(), (String)incompleteLayoutRevision.getRobots(), (String)incompleteLayoutRevision.getTypeSettings(), (boolean)incompleteLayoutRevision.getIconImage(), (long)incompleteLayoutRevision.getIconImageId(), (String)incompleteLayoutRevision.getThemeId(), (String)incompleteLayoutRevision.getColorSchemeId(), (String)incompleteLayoutRevision.getWapThemeId(), (String)incompleteLayoutRevision.getWapColorSchemeId(), (String)incompleteLayoutRevision.getCss(), (ServiceContext)serviceContext);
    }

    protected String getColorSchemeId(long companyId, String themeId, String colorSchemeId, boolean wapTheme) throws Exception {
        Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)wapTheme);
        if (!theme.hasColorSchemes()) {
            colorSchemeId = "";
        }
        if (Validator.isNull((String)colorSchemeId)) {
            ColorScheme colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)themeId, (String)colorSchemeId, (boolean)wapTheme);
            colorSchemeId = colorScheme.getColorSchemeId();
        }
        return colorSchemeId;
    }

    protected Group getGroup(PortletRequest portletRequest) throws Exception {
        return ActionUtil.getGroup(portletRequest);
    }

    protected byte[] getIconBytes(UploadPortletRequest uploadPortletRequest, String iconFileName) {
        block3: {
            InputStream inputStream = null;
            try {
                inputStream = uploadPortletRequest.getFileAsStream(iconFileName);
                if (inputStream != null) {
                    return FileUtil.getBytes((InputStream)inputStream);
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to retrieve icon", (Throwable)ioe);
            }
        }
        return new byte[0];
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void selectLayoutBranch(ActionRequest actionRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long layoutSetBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetBranchId");
        long layoutBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutBranchId");
        StagingUtil.setRecentLayoutBranchId((HttpServletRequest)request, (long)layoutSetBranchId, (long)themeDisplay.getPlid(), (long)layoutBranchId);
    }

    protected void selectLayoutSetBranch(ActionRequest actionRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long layoutSetBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetBranchId");
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)layoutSetBranchId);
        StagingUtil.setRecentLayoutSetBranchId((HttpServletRequest)request, (long)layoutSet.getLayoutSetId(), (long)layoutSetBranch.getLayoutSetBranchId());
    }

    protected void setThemeSettingProperties(ActionRequest actionRequest, UnicodeProperties typeSettingsProperties, String device, Map<String, ThemeSetting> themeSettings) throws PortalException, SystemException {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        LayoutSet layoutSet = layout.getLayoutSet();
        for (String key : themeSettings.keySet()) {
            ThemeSetting themeSetting = themeSettings.get(key);
            String type = GetterUtil.getString((String)themeSetting.getType(), (String)"text");
            String property = String.valueOf(device) + "ThemeSettingsProperties--" + key + "--";
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)property);
            if (type.equals("checkbox")) {
                value = String.valueOf(GetterUtil.getBoolean((String)value));
            }
            if (value.equals(layoutSet.getThemeSetting(key, device))) continue;
            typeSettingsProperties.setProperty(ThemeSettingImpl.namespaceProperty(device, key), value);
        }
    }

    protected String updateCloseRedirect(String closeRedirect, Group group, Layout layout, String oldLayoutFriendlyURL) {
        if (Validator.isNull((String)closeRedirect) || Validator.isNull((String)oldLayoutFriendlyURL)) {
            return closeRedirect;
        }
        if (layout != null) {
            String oldPath = oldLayoutFriendlyURL;
            String newPath = layout.getFriendlyURL();
            return PortalUtil.updateRedirect((String)closeRedirect, (String)oldPath, (String)newPath);
        }
        if (group != null) {
            String oldPath = String.valueOf(group.getFriendlyURL()) + oldLayoutFriendlyURL;
            String newPath = group.getFriendlyURL();
            return PortalUtil.updateRedirect((String)closeRedirect, (String)oldPath, (String)newPath);
        }
        return closeRedirect;
    }

    protected void updateDisplayOrder(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentLayoutId");
        long[] layoutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"layoutIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        LayoutServiceUtil.setLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (long[])layoutIds, (ServiceContext)serviceContext);
    }

    protected Object[] updateLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"parentLayoutId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        Map keywordsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"keywords");
        Map robotsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"robots");
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        boolean hidden = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"hidden");
        String friendlyURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"friendlyURL");
        boolean iconImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"iconImage");
        byte[] iconBytes = this.getIconBytes(uploadPortletRequest, "iconFileName");
        long layoutPrototypeId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"layoutPrototypeId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        Layout layout = null;
        UnicodeProperties layoutTypeSettingsProperties = null;
        String oldFriendlyURL = "";
        if (cmd.equals("add")) {
            boolean inheritFromParentLayoutId = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"inheritFromParentLayoutId");
            if (inheritFromParentLayoutId && parentLayoutId > 0L) {
                Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
                layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)nameMap, (Map)titleMap, (Map)descriptionMap, (Map)keywordsMap, (Map)robotsMap, (String)parentLayout.getType(), (boolean)hidden, (String)friendlyURL, (ServiceContext)serviceContext);
                LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)parentLayout.getTypeSettings());
                if (parentLayout.isTypePortlet()) {
                    ActionUtil.copyPreferences((PortletRequest)actionRequest, layout, parentLayout);
                    SitesUtil.copyLookAndFeel(layout, parentLayout);
                }
            } else if (layoutPrototypeId > 0L) {
                LayoutPrototype layoutPrototype = LayoutPrototypeServiceUtil.getLayoutPrototype((long)layoutPrototypeId);
                String layoutPrototypeLinkEnabled = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutPrototypeLinkEnabled");
                if (Validator.isNotNull((String)layoutPrototypeLinkEnabled)) {
                    serviceContext.setAttribute("layoutPrototypeLinkEnabled", (Serializable)((Object)layoutPrototypeLinkEnabled));
                }
                serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
                layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)nameMap, (Map)titleMap, (Map)descriptionMap, (Map)keywordsMap, (Map)robotsMap, (String)"portlet", (boolean)hidden, (String)friendlyURL, (ServiceContext)serviceContext);
            } else {
                layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (Map)nameMap, (Map)titleMap, (Map)descriptionMap, (Map)keywordsMap, (Map)robotsMap, (String)type, (boolean)hidden, (String)friendlyURL, (ServiceContext)serviceContext);
            }
            layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
        } else {
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            oldFriendlyURL = layout.getFriendlyURL();
            layout = LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (long)layout.getParentLayoutId(), (Map)nameMap, (Map)titleMap, (Map)descriptionMap, (Map)keywordsMap, (Map)robotsMap, (String)type, (boolean)hidden, (String)friendlyURL, (Boolean)iconImage, (byte[])iconBytes, (ServiceContext)serviceContext);
            layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
            if (oldFriendlyURL.equals(layout.getFriendlyURL())) {
                oldFriendlyURL = "";
            }
            UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
            if (type.equals("portlet")) {
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                String layoutTemplateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutTemplateId", (String)PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
                layoutTypePortlet.setLayoutTemplateId(themeDisplay.getUserId(), layoutTemplateId);
                long copyLayoutId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"copyLayoutId");
                if (copyLayoutId > 0L && copyLayoutId != layout.getLayoutId()) {
                    try {
                        Layout copyLayout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)copyLayoutId);
                        if (copyLayout.isTypePortlet()) {
                            layoutTypeSettingsProperties = copyLayout.getTypeSettingsProperties();
                            ActionUtil.copyPreferences((PortletRequest)actionRequest, layout, copyLayout);
                            SitesUtil.copyLookAndFeel(layout, copyLayout);
                        }
                    }
                    catch (NoSuchLayoutException noSuchLayoutException) {}
                } else {
                    layoutTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
                    LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)layout.getTypeSettings());
                }
            } else {
                layout.setTypeSettingsProperties(formTypeSettingsProperties);
                layoutTypeSettingsProperties.putAll((Map)layout.getTypeSettingsProperties());
                LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)layout.getTypeSettings());
            }
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            LayoutSettings layoutSettings = LayoutSettings.getInstance(layout);
            EventsProcessorUtil.process("layout.configuration.action.update", layoutSettings.getConfigurationActionUpdate(), (HttpServletRequest)uploadPortletRequest, response);
        }
        this.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layout.getLayoutId(), layoutTypeSettingsProperties);
        return new Object[]{layout, oldFriendlyURL};
    }

    protected void updateLayoutRevision(ActionRequest actionRequest, ThemeDisplay themeDisplay) throws Exception {
        LayoutRevision lastLayoutRevision;
        long layoutRevisionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutRevisionId");
        LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        LayoutRevision enableLayoutRevision = LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevisionId, (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getWapThemeId(), (String)layoutRevision.getWapColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        if (layoutRevision.getStatus() == 6 && (lastLayoutRevision = LayoutRevisionLocalServiceUtil.fetchLastLayoutRevision((long)enableLayoutRevision.getPlid(), (boolean)true)) != null) {
            LayoutRevision newLayoutRevision = LayoutRevisionLocalServiceUtil.addLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getLayoutBranchId(), (long)enableLayoutRevision.getLayoutRevisionId(), (boolean)false, (long)layoutRevision.getPlid(), (long)lastLayoutRevision.getLayoutRevisionId(), (boolean)lastLayoutRevision.getPrivateLayout(), (String)lastLayoutRevision.getName(), (String)lastLayoutRevision.getTitle(), (String)lastLayoutRevision.getDescription(), (String)lastLayoutRevision.getKeywords(), (String)lastLayoutRevision.getRobots(), (String)lastLayoutRevision.getTypeSettings(), (boolean)lastLayoutRevision.isIconImage(), (long)lastLayoutRevision.getIconImageId(), (String)lastLayoutRevision.getThemeId(), (String)lastLayoutRevision.getColorSchemeId(), (String)lastLayoutRevision.getWapThemeId(), (String)lastLayoutRevision.getWapColorSchemeId(), (String)lastLayoutRevision.getCss(), (ServiceContext)serviceContext);
            StagingUtil.setRecentLayoutRevisionId((User)themeDisplay.getUser(), (long)newLayoutRevision.getLayoutSetBranchId(), (long)newLayoutRevision.getPlid(), (long)newLayoutRevision.getLayoutRevisionId());
        }
    }

    protected void updateLookAndFeel(ActionRequest actionRequest, long companyId, long liveGroupId, long stagingGroupId, boolean privateLayout, long layoutId, UnicodeProperties typeSettingsProperties) throws Exception {
        String[] devices;
        String[] stringArray = devices = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"devices"));
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            String device = stringArray[n2];
            String themeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(String.valueOf(device) + "ThemeId"));
            String colorSchemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(String.valueOf(device) + "ColorSchemeId"));
            String css = ParamUtil.getString((PortletRequest)actionRequest, (String)(String.valueOf(device) + "Css"));
            boolean wapTheme = device.equals("wap");
            boolean inheritLookAndFeel = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)(String.valueOf(device) + "InheritLookAndFeel"));
            if (inheritLookAndFeel) {
                themeId = ThemeImpl.getDefaultRegularThemeId(companyId);
                colorSchemeId = "";
                this.deleteThemeSettingsProperties(typeSettingsProperties, device);
            } else if (Validator.isNotNull((String)themeId)) {
                colorSchemeId = this.getColorSchemeId(companyId, themeId, colorSchemeId, wapTheme);
                this.updateThemeSettingsProperties(actionRequest, companyId, typeSettingsProperties, device, themeId, wapTheme);
            }
            long groupId = liveGroupId;
            if (stagingGroupId > 0L) {
                groupId = stagingGroupId;
            }
            LayoutServiceUtil.updateLayout((long)groupId, (boolean)privateLayout, (long)layoutId, (String)typeSettingsProperties.toString());
            LayoutServiceUtil.updateLookAndFeel((long)groupId, (boolean)privateLayout, (long)layoutId, (String)themeId, (String)colorSchemeId, (String)css, (boolean)wapTheme);
            ++n2;
        }
    }

    protected UnicodeProperties updateThemeSettingsProperties(ActionRequest actionRequest, long companyId, UnicodeProperties typeSettingsProperties, String device, String themeId, boolean wapTheme) throws Exception {
        Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)wapTheme);
        this.deleteThemeSettingsProperties(typeSettingsProperties, device);
        Map themeSettings = theme.getConfigurableSettings();
        if (themeSettings.isEmpty()) {
            return typeSettingsProperties;
        }
        this.setThemeSettingProperties(actionRequest, typeSettingsProperties, device, themeSettings);
        return typeSettingsProperties;
    }
}

