/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.sites.action.ActionUtil;
import java.io.File;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ImportLayoutsAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(ImportLayoutsAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
            long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"privateLayout");
            File file = uploadPortletRequest.getFile("importFileName");
            if (!file.exists()) {
                throw new LARFileException("Import file does not exist");
            }
            LayoutServiceUtil.importLayouts((long)groupId, (boolean)privateLayout, (Map)actionRequest.getParameterMap(), (File)file);
            this.addSuccessMessage(actionRequest, actionResponse);
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e2) {
            if (e2 instanceof LARFileException || e2 instanceof LARTypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof LayoutPrototypeException || e2 instanceof LocaleException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            _log.error((Object)e2, (Throwable)e2);
            SessionErrors.add((PortletRequest)actionRequest, (String)LayoutImportException.class.getName());
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.layouts_admin.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.export_layouts"));
    }
}

