/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.layoutsadmin.util.Sitemap;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SitemapImpl
implements Sitemap {
    public String encodeXML(String input) {
        return StringUtil.replace((String)input, (String[])new String[]{"&", "<", ">", "'", "\""}, (String[])new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"});
    }

    public String getSitemap(long groupId, boolean privateLayout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Document document = SAXReaderUtil.createDocument();
        document.setXMLEncoding("UTF-8");
        Element rootElement = document.addElement("urlset", "http://www.google.com/schemas/sitemap/0.84");
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)0L);
        this.visitLayouts(rootElement, layouts, themeDisplay);
        return document.asXML();
    }

    protected void addURLElement(Element element, String url, UnicodeProperties typeSettingsProperties, Date modifiedDate) {
        Element urlElement = element.addElement("url");
        Element locElement = urlElement.addElement("loc");
        locElement.addText(this.encodeXML(url));
        if (typeSettingsProperties == null) {
            if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY)) {
                Element changefreqElement = urlElement.addElement("changefreq");
                changefreqElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY);
            }
            if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY)) {
                Element priorityElement = urlElement.addElement("priority");
                priorityElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY);
            }
        } else {
            Element changefreqElement;
            String changefreq = typeSettingsProperties.getProperty("sitemap-changefreq");
            if (Validator.isNotNull((String)changefreq)) {
                changefreqElement = urlElement.addElement("changefreq");
                changefreqElement.addText(changefreq);
            } else if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY)) {
                changefreqElement = urlElement.addElement("changefreq");
                changefreqElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_CHANGE_FREQUENCY);
            }
            String priority = typeSettingsProperties.getProperty("sitemap-priority");
            if (Validator.isNotNull((String)priority)) {
                Element priorityElement = urlElement.addElement("priority");
                priorityElement.addText(priority);
            } else if (Validator.isNotNull((String)PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY)) {
                Element priorityElement = urlElement.addElement("priority");
                priorityElement.addText(PropsValues.SITES_SITEMAP_DEFAULT_PRIORITY);
            }
        }
        if (modifiedDate != null) {
            Element modifiedDateElement = urlElement.addElement("lastmod");
            DateFormat iso8601DateFormat = DateUtil.getISO8601Format();
            modifiedDateElement.addText(iso8601DateFormat.format(modifiedDate));
        }
    }

    protected void visitArticles(Element element, Layout layout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        List journalArticles = JournalArticleServiceUtil.getArticlesByLayoutUuid((long)layout.getGroupId(), (String)layout.getUuid());
        if (journalArticles.isEmpty()) {
            return;
        }
        ArrayList<String> processedArticleIds = new ArrayList<String>();
        for (JournalArticle journalArticle : journalArticles) {
            if (processedArticleIds.contains(journalArticle.getArticleId()) || journalArticle.getStatus() != 0) continue;
            String portalURL = PortalUtil.getPortalURL((Layout)layout, (ThemeDisplay)themeDisplay);
            String groupFriendlyURL = PortalUtil.getGroupFriendlyURL((Group)GroupLocalServiceUtil.getGroup((long)journalArticle.getGroupId()), (boolean)false, (ThemeDisplay)themeDisplay);
            StringBundler sb = new StringBundler(4);
            if (!groupFriendlyURL.startsWith(portalURL)) {
                sb.append(portalURL);
            }
            sb.append(groupFriendlyURL);
            sb.append("/-/");
            sb.append(journalArticle.getUrlTitle());
            String articleURL = PortalUtil.getCanonicalURL((String)sb.toString(), (ThemeDisplay)themeDisplay, (Layout)layout);
            this.addURLElement(element, articleURL, null, journalArticle.getModifiedDate());
            Locale[] availableLocales = LanguageUtil.getAvailableLocales();
            if (availableLocales.length > 1) {
                Locale defaultLocale = LocaleUtil.getDefault();
                Locale[] localeArray = availableLocales;
                int n = availableLocales.length;
                int n2 = 0;
                while (n2 < n) {
                    Locale availableLocale = localeArray[n2];
                    if (!availableLocale.equals(defaultLocale)) {
                        String alternateURL = PortalUtil.getAlternateURL((String)articleURL, (ThemeDisplay)themeDisplay, (Locale)availableLocale);
                        this.addURLElement(element, alternateURL, null, journalArticle.getModifiedDate());
                    }
                    ++n2;
                }
            }
            processedArticleIds.add(journalArticle.getArticleId());
        }
    }

    protected void visitLayout(Element element, Layout layout, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        if (layout.isHidden() || !PortalUtil.isLayoutSitemapable((Layout)layout) || !GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("sitemap-include"), (boolean)true)) {
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)themeDisplay);
        layoutFullURL = PortalUtil.getCanonicalURL((String)layoutFullURL, (ThemeDisplay)themeDisplay, (Layout)layout);
        this.addURLElement(element, layoutFullURL, typeSettingsProperties, layout.getModifiedDate());
        Locale[] availableLocales = LanguageUtil.getAvailableLocales();
        if (availableLocales.length > 1) {
            Locale defaultLocale = LocaleUtil.getDefault();
            Locale[] localeArray = availableLocales;
            int n = availableLocales.length;
            int n2 = 0;
            while (n2 < n) {
                Locale availableLocale = localeArray[n2];
                if (!availableLocale.equals(defaultLocale)) {
                    String alternateURL = PortalUtil.getAlternateURL((String)layoutFullURL, (ThemeDisplay)themeDisplay, (Locale)availableLocale);
                    this.addURLElement(element, alternateURL, typeSettingsProperties, layout.getModifiedDate());
                }
                ++n2;
            }
        }
        this.visitArticles(element, layout, themeDisplay);
        this.visitLayouts(element, layout.getChildren(), themeDisplay);
    }

    protected void visitLayouts(Element element, List<Layout> layouts, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        for (Layout layout : layouts) {
            this.visitLayout(element, layout, themeDisplay);
        }
    }
}

