/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.CompanyMaxUsersException;
import com.liferay.portal.ContactFirstNameException;
import com.liferay.portal.ContactFullNameException;
import com.liferay.portal.ContactLastNameException;
import com.liferay.portal.DuplicateUserEmailAddressException;
import com.liferay.portal.EmailAddressException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.ReservedUserEmailAddressException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLFactoryUtil;
import java.io.Serializable;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CreateAnonymousAccountAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(CreateAnonymousAccountAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        if (!company.isStrangers()) {
            throw new PrincipalException();
        }
        if (actionRequest.getRemoteUser() != null) {
            actionResponse.sendRedirect(themeDisplay.getPathMain());
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"58", (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        portletURL.setParameter("struts_action", "/login/login_redirect");
        portletURL.setParameter("emailAddress", emailAddress);
        portletURL.setParameter("anonymousUser", Boolean.TRUE.toString());
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            if (cmd.equals("add")) {
                this.addAnonymousUser(actionRequest, actionResponse);
                this.sendRedirect(actionRequest, actionResponse, portletURL.toString());
            } else if (cmd.equals("update")) {
                jsonObject = this.updateIncompleteUser(actionRequest, actionResponse);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
            }
        }
        catch (Exception e2) {
            if (cmd.equals("update")) {
                jsonObject.putException(e2);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
            }
            if (e2 instanceof DuplicateUserEmailAddressException) {
                User user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)emailAddress);
                if (user.getStatus() != 6) {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                } else {
                    this.sendRedirect(actionRequest, actionResponse, portletURL.toString());
                }
            }
            if (e2 instanceof CaptchaTextException || e2 instanceof CompanyMaxUsersException || e2 instanceof ContactFirstNameException || e2 instanceof ContactFullNameException || e2 instanceof ContactLastNameException || e2 instanceof EmailAddressException || e2 instanceof GroupFriendlyURLException || e2 instanceof ReservedUserEmailAddressException || e2 instanceof UserEmailAddressException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            _log.error((Object)"Unable to create anonymous account", (Throwable)e2);
            PortalUtil.sendError((Exception)e2, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        if (!company.isStrangers()) {
            return mapping.findForward("portlet.login.login");
        }
        renderResponse.setTitle(themeDisplay.translate("anonymous-account"));
        return mapping.findForward("portlet.login.create_anonymous_account");
    }

    protected void addAnonymousUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = true;
        String screenName = null;
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        long facebookId = 0L;
        String openId = "";
        String firstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"firstName");
        String lastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"lastName");
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = null;
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        serviceContext.setAttribute("anonymousUser", (Serializable)Boolean.valueOf(true));
        if (PropsValues.CAPTCHA_CHECK_PORTAL_CREATE_ACCOUNT) {
            CaptchaUtil.check((PortletRequest)actionRequest);
        }
        User user = UserServiceUtil.addUser((long)themeDisplay.getCompanyId(), (boolean)autoPassword, password1, password2, (boolean)autoScreenName, screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)themeDisplay.getLocale(), (String)firstName, null, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        UserLocalServiceUtil.updateStatus((long)user.getUserId(), (int)6);
        SessionMessages.add((HttpServletRequest)request, (String)"user_added", (Object)user.getEmailAddress());
        SessionMessages.add((HttpServletRequest)request, (String)"user_added_password", (Object)user.getPasswordUnencrypted());
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        String portletId = (String)actionRequest.getAttribute("PORTLET_ID");
        if (!portletId.equals("164")) {
            super.addSuccessMessage(actionRequest, actionResponse);
        }
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected JSONObject updateIncompleteUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        String screenName = null;
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        long facebookId = 0L;
        String openId = null;
        String firstName = null;
        String middleName = null;
        String lastName = null;
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = null;
        boolean updateUserInformation = false;
        boolean sendEmail = true;
        User user = UserServiceUtil.updateIncompleteUser((long)themeDisplay.getCompanyId(), (boolean)autoPassword, password1, password2, (boolean)autoScreenName, screenName, (String)emailAddress, (long)facebookId, openId, (Locale)themeDisplay.getLocale(), firstName, middleName, lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, jobTitle, (boolean)updateUserInformation, (boolean)sendEmail, (ServiceContext)serviceContext);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (user.getStatus() == 0) {
            jsonObject.put("userStatus", "user_added");
        } else {
            jsonObject.put("userStatus", "user_pending");
        }
        return jsonObject;
    }
}

