/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.RequiredReminderQueryException;
import com.liferay.portal.SendPasswordException;
import com.liferay.portal.UserActiveException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserReminderQueryException;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.login.util.LoginUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ForgotPasswordAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        if (!company.isSendPassword() && !company.isSendPasswordResetLink()) {
            throw new PrincipalException();
        }
        try {
            if (PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
                this.checkReminderQueries(actionRequest, actionResponse);
            } else {
                this.checkCaptcha(actionRequest);
                this.sendPassword(actionRequest, actionResponse);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof CaptchaTextException || e2 instanceof NoSuchUserException || e2 instanceof RequiredReminderQueryException || e2 instanceof SendPasswordException || e2 instanceof UserActiveException || e2 instanceof UserEmailAddressException || e2 instanceof UserReminderQueryException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            PortalUtil.sendError((Exception)e2, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        if (!company.isSendPassword() && !company.isSendPasswordResetLink()) {
            return mapping.findForward("portlet.login.login");
        }
        renderResponse.setTitle(themeDisplay.translate("forgot-password"));
        return mapping.findForward("portlet.login.forgot_password");
    }

    protected void checkCaptcha(ActionRequest actionRequest) throws CaptchaException {
        if (PropsValues.CAPTCHA_CHECK_PORTAL_SEND_PASSWORD) {
            CaptchaUtil.check((PortletRequest)actionRequest);
        }
    }

    protected void checkReminderQueries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        PortletSession portletSession = actionRequest.getPortletSession();
        int step = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"step");
        if (step == 1) {
            this.checkCaptcha(actionRequest);
            portletSession.removeAttribute("FORGOT_PASSWORD_REMINDER_ATTEMPTS");
            portletSession.removeAttribute("FORGOT_PASSWORD_REMINDER_USER_EMAIL_ADDRESS");
        }
        User user = this.getUser(actionRequest);
        portletSession.setAttribute("FORGOT_PASSWORD_REMINDER_USER_EMAIL_ADDRESS", (Object)user.getEmailAddress());
        actionRequest.setAttribute("FORGOT_PASSWORD_REMINDER_USER", (Object)user);
        if (step == 2) {
            Integer reminderAttempts = (Integer)portletSession.getAttribute("FORGOT_PASSWORD_REMINDER_ATTEMPTS");
            if (reminderAttempts == null) {
                reminderAttempts = 0;
            } else if (reminderAttempts > 2) {
                this.checkCaptcha(actionRequest);
            }
            reminderAttempts = reminderAttempts + 1;
            portletSession.setAttribute("FORGOT_PASSWORD_REMINDER_ATTEMPTS", (Object)reminderAttempts);
            this.sendPassword(actionRequest, actionResponse);
        }
    }

    protected User getUser(ActionRequest actionRequest) throws Exception {
        PortletSession portletSession = actionRequest.getPortletSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String sessionEmailAddress = (String)portletSession.getAttribute("FORGOT_PASSWORD_REMINDER_USER_EMAIL_ADDRESS");
        User user = null;
        if (Validator.isNotNull((String)sessionEmailAddress)) {
            user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)sessionEmailAddress);
        } else {
            long userId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userId");
            String screenName = ParamUtil.getString((PortletRequest)actionRequest, (String)"screenName");
            String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
            if (Validator.isNotNull((String)emailAddress)) {
                user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)emailAddress);
            } else if (Validator.isNotNull((String)screenName)) {
                user = UserLocalServiceUtil.getUserByScreenName((long)themeDisplay.getCompanyId(), (String)screenName);
            } else if (userId > 0L) {
                user = UserLocalServiceUtil.getUserById((long)userId);
            } else {
                throw new NoSuchUserException();
            }
        }
        if (!user.isActive()) {
            throw new UserActiveException();
        }
        return user;
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void sendPassword(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        User user = this.getUser(actionRequest);
        if (PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
            if (PropsValues.USERS_REMINDER_QUERIES_REQUIRED && !user.hasReminderQuery()) {
                throw new RequiredReminderQueryException("No reminder query or answer is defined for user " + user.getUserId());
            }
            String answer = ParamUtil.getString((PortletRequest)actionRequest, (String)"answer");
            if (!user.getReminderQueryAnswer().equals(answer)) {
                throw new UserReminderQueryException();
            }
        }
        PortletPreferences preferences = actionRequest.getPreferences();
        String languageId = LanguageUtil.getLanguageId((PortletRequest)actionRequest);
        String emailFromName = preferences.getValue("emailFromName", null);
        String emailFromAddress = preferences.getValue("emailFromAddress", null);
        String emailToAddress = user.getEmailAddress();
        String emailParam = "emailPasswordSent";
        if (company.isSendPasswordResetLink()) {
            emailParam = "emailPasswordReset";
        }
        String subject = preferences.getValue(String.valueOf(emailParam) + "Subject_" + languageId, null);
        String body = preferences.getValue(String.valueOf(emailParam) + "Body_" + languageId, null);
        LoginUtil.sendPassword(actionRequest, emailFromName, emailFromAddress, emailToAddress, subject, body);
        this.sendRedirect(actionRequest, actionResponse);
    }
}

