/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.NoSuchThreadException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadServiceUtil;
import java.util.Collections;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class MoveThreadAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.moveThread(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException || e2 instanceof RequiredMessageException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            if (e2 instanceof MessageBodyException || e2 instanceof MessageSubjectException || e2 instanceof NoSuchThreadException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getThreadMessage((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchMessageException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.message_boards.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.move_thread"));
    }

    protected void moveThread(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        PortletPreferences preferences = actionRequest.getPreferences();
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)threadId);
        MBThreadServiceUtil.moveThread((long)categoryId, (long)threadId);
        boolean addExplanationPost = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"addExplanationPost");
        if (addExplanationPost) {
            String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
            String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
            String format = GetterUtil.getString((String)preferences.getValue("messageFormat", null), (String)MBMessageConstants.DEFAULT_FORMAT);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
            MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (long)threadId, (long)thread.getRootMessageId(), (String)subject, (String)body, (String)format, Collections.emptyList(), (boolean)false, (double)-1.0, (boolean)false, (ServiceContext)serviceContext);
        }
        PortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(thread.getRootMessageId()));
        actionResponse.sendRedirect(portletURL.toString());
    }
}

