/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.messageboards.CategoryNameException;
import com.liferay.portlet.messageboards.NoSuchMailingListException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.base.MBCategoryLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBCategoryLocalServiceImpl
extends MBCategoryLocalServiceBaseImpl {
    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean mailingListActive, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentCategoryId = this.getParentCategoryId(groupId, parentCategoryId);
        Date now = new Date();
        this.validate(name);
        long categoryId = this.counterLocalService.increment();
        MBCategory category = this.mbCategoryPersistence.create(categoryId);
        category.setUuid(serviceContext.getUuid());
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setCreateDate(serviceContext.getCreateDate(now));
        category.setModifiedDate(serviceContext.getModifiedDate(now));
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        category.setDisplayStyle(displayStyle);
        this.mbCategoryPersistence.update((BaseModel)category, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.mbMailingListLocalService.addMailingList(userId, groupId, category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        ExpandoBridge expandoBridge = category.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return category;
    }

    public void addCategoryResources(long categoryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(long categoryId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, groupPermissions, guestPermissions);
    }

    public void addCategoryResources(MBCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(MBCategory category, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), groupPermissions, guestPermissions);
    }

    public void deleteCategories(long groupId) throws PortalException, SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(groupId, 0L);
        for (MBCategory category : categories) {
            this.deleteCategory(category);
        }
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.deleteCategory(category);
    }

    public void deleteCategory(MBCategory category) throws PortalException, SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(category.getGroupId(), category.getCategoryId());
        for (MBCategory curCategory : categories) {
            this.deleteCategory(curCategory);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        indexer.delete((Object)category);
        this.mbThreadLocalService.deleteThreads(category.getGroupId(), category.getCategoryId());
        try {
            this.mbMailingListLocalService.deleteCategoryMailingList(category.getGroupId(), category.getCategoryId());
        }
        catch (NoSuchMailingListException noSuchMailingListException) {}
        this.subscriptionLocalService.deleteSubscriptions(category.getCompanyId(), MBCategory.class.getName(), category.getCategoryId());
        this.expandoValueLocalService.deleteValues(MBCategory.class.getName(), category.getCategoryId());
        this.resourceLocalService.deleteResource(category.getCompanyId(), MBCategory.class.getName(), 4, category.getCategoryId());
        this.mbCategoryPersistence.remove((BaseModel)category);
    }

    public List<MBCategory> getCategories(long groupId) throws SystemException {
        return this.mbCategoryPersistence.findByGroupId(groupId);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryIds, start, end);
    }

    public int getCategoriesCount(long groupId) throws SystemException {
        return this.mbCategoryPersistence.countByGroupId(groupId);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) throws SystemException {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryId);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds) throws SystemException {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryIds);
    }

    public MBCategory getCategory(long categoryId) throws PortalException, SystemException {
        MBCategoryImpl category = null;
        if (categoryId != 0L && categoryId != -1L) {
            category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        } else {
            category = new MBCategoryImpl();
            category.setCategoryId(categoryId);
            category.setParentCategoryId(categoryId);
        }
        return category;
    }

    public List<MBCategory> getCompanyCategories(long companyId, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyCategoriesCount(long companyId) throws SystemException {
        return this.mbCategoryPersistence.countByCompanyId(companyId);
    }

    public List<Long> getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) throws SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(groupId, categoryId);
        for (MBCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
        return categoryIds;
    }

    public List<MBCategory> getSubscribedCategories(long groupId, long userId, int start, int end) throws SystemException {
        return this.mbCategoryFinder.findByS_G_U_P(groupId, userId, null, start, end);
    }

    public int getSubscribedCategoriesCount(long groupId, long userId) throws SystemException {
        return this.mbCategoryFinder.countByS_G_U_P(groupId, userId, null);
    }

    public void subscribeCategory(long userId, long groupId, long categoryId) throws PortalException, SystemException {
        if (categoryId == 0L) {
            categoryId = groupId;
        }
        this.subscriptionLocalService.addSubscription(userId, groupId, MBCategory.class.getName(), categoryId);
    }

    public void unsubscribeCategory(long userId, long groupId, long categoryId) throws PortalException, SystemException {
        if (categoryId == 0L) {
            categoryId = groupId;
        }
        this.subscriptionLocalService.deleteSubscription(userId, MBCategory.class.getName(), categoryId);
    }

    public MBCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean mailingListActive, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException, SystemException {
        if (categoryId == 0L || categoryId == -1L) {
            return null;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this.getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L && parentCategoryId != -1L) {
            this.mergeCategories(category, parentCategoryId);
            return category;
        }
        this.validate(name);
        category.setModifiedDate(serviceContext.getModifiedDate(null));
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        category.setDisplayStyle(displayStyle);
        this.mbCategoryPersistence.update((BaseModel)category, false);
        MBMailingList mailingList = this.mbMailingListPersistence.fetchByG_C(category.getGroupId(), category.getCategoryId());
        if (mailingList != null) {
            this.mbMailingListLocalService.updateMailingList(mailingList.getMailingListId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        } else {
            this.mbMailingListLocalService.addMailingList(category.getUserId(), category.getGroupId(), category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        }
        ExpandoBridge expandoBridge = category.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return category;
    }

    protected long getParentCategoryId(long groupId, long parentCategoryId) throws SystemException {
        MBCategory parentCategory;
        if (parentCategoryId != 0L && parentCategoryId != -1L && ((parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId)) == null || groupId != parentCategory.getGroupId())) {
            parentCategoryId = 0L;
        }
        return parentCategoryId;
    }

    protected long getParentCategoryId(MBCategory category, long parentCategoryId) throws SystemException {
        if (parentCategoryId == 0L || parentCategoryId == -1L) {
            return parentCategoryId;
        }
        if (category.getCategoryId() == parentCategoryId) {
            return category.getParentCategoryId();
        }
        MBCategory parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentCategory == null || category.getGroupId() != parentCategory.getGroupId()) {
            return category.getParentCategoryId();
        }
        ArrayList<Long> subcategoryIds = new ArrayList<Long>();
        this.getSubcategoryIds(subcategoryIds, category.getGroupId(), category.getCategoryId());
        if (subcategoryIds.contains(parentCategoryId)) {
            return category.getParentCategoryId();
        }
        return parentCategoryId;
    }

    protected void mergeCategories(MBCategory fromCategory, long toCategoryId) throws PortalException, SystemException {
        if (toCategoryId == 0L || toCategoryId == -1L) {
            return;
        }
        List categories = this.mbCategoryPersistence.findByG_P(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (MBCategory category : categories) {
            this.mergeCategories(category, toCategoryId);
        }
        List threads = this.mbThreadPersistence.findByG_C(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (MBThread thread : threads) {
            thread.setCategoryId(toCategoryId);
            this.mbThreadPersistence.update((BaseModel)thread, false);
            List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
            for (MBMessage message : messages) {
                message.setCategoryId(toCategoryId);
                this.mbMessagePersistence.update((BaseModel)message, false);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.reindex((Object)message);
            }
        }
        MBCategory toCategory = this.mbCategoryPersistence.findByPrimaryKey(toCategoryId);
        toCategory.setThreadCount(fromCategory.getThreadCount() + toCategory.getThreadCount());
        toCategory.setMessageCount(fromCategory.getMessageCount() + toCategory.getMessageCount());
        this.mbCategoryPersistence.update((BaseModel)toCategory, false);
        this.deleteCategory(fromCategory);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CategoryNameException();
        }
    }
}

