/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.base.MBCategoryServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBCategoryServiceImpl
extends MBCategoryServiceBaseImpl {
    public MBCategory addCategory(long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, boolean allowAnonymousEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.mbCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, name, description, displayStyle, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive, allowAnonymousEmail, serviceContext);
    }

    public void deleteCategory(long groupId, long categoryId) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "DELETE");
        this.mbCategoryLocalService.deleteCategory(categoryId);
    }

    public List<MBCategory> getCategories(long groupId) throws SystemException {
        return this.mbCategoryPersistence.filterFindByGroupId(groupId);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.filterFindByG_P(groupId, parentCategoryId, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.filterFindByG_P(groupId, parentCategoryIds, start, end);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) throws SystemException {
        return this.mbCategoryPersistence.filterCountByG_P(groupId, parentCategoryId);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds) throws SystemException {
        return this.mbCategoryPersistence.filterCountByG_P(groupId, parentCategoryIds);
    }

    public MBCategory getCategory(long categoryId) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryLocalService.getCategory(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "VIEW");
        return category;
    }

    public long[] getCategoryIds(long groupId, long categoryId) throws SystemException {
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(categoryId);
        this.getSubcategoryIds(categoryIds, groupId, categoryId);
        return ArrayUtil.toArray((Long[])categoryIds.toArray(new Long[categoryIds.size()]));
    }

    public List<Long> getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) throws SystemException {
        List categories = this.mbCategoryPersistence.filterFindByG_P(groupId, categoryId);
        for (MBCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
        return categoryIds;
    }

    public List<MBCategory> getSubscribedCategories(long groupId, long userId, int start, int end) throws SystemException {
        long[] categoryIds = this.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        return this.mbCategoryFinder.filterFindByS_G_U_P(groupId, userId, categoryIds, start, end);
    }

    public int getSubscribedCategoriesCount(long groupId, long userId) throws SystemException {
        long[] categoryIds = this.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        return this.mbCategoryFinder.filterCountByS_G_U_P(groupId, userId, categoryIds);
    }

    public void subscribeCategory(long groupId, long categoryId) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "SUBSCRIBE");
        this.mbCategoryLocalService.subscribeCategory(this.getUserId(), groupId, categoryId);
    }

    public void unsubscribeCategory(long groupId, long categoryId) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), groupId, categoryId, "SUBSCRIBE");
        this.mbCategoryLocalService.unsubscribeCategory(this.getUserId(), groupId, categoryId);
    }

    public MBCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, boolean allowAnonymousEmail, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryLocalService.getCategory(categoryId);
        MBCategoryPermission.check(this.getPermissionChecker(), category, "UPDATE");
        return this.mbCategoryLocalService.updateCategory(categoryId, parentCategoryId, name, description, displayStyle, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive, allowAnonymousEmail, mergeWithParentCategory, serviceContext);
    }
}

