/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.scheduler.CronText;
import com.liferay.portal.kernel.scheduler.CronTrigger;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.MailingListEmailAddressException;
import com.liferay.portlet.messageboards.MailingListInServerNameException;
import com.liferay.portlet.messageboards.MailingListInUserNameException;
import com.liferay.portlet.messageboards.MailingListOutEmailAddressException;
import com.liferay.portlet.messageboards.MailingListOutServerNameException;
import com.liferay.portlet.messageboards.MailingListOutUserNameException;
import com.liferay.portlet.messageboards.messaging.MailingListRequest;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.service.base.MBMailingListLocalServiceBaseImpl;
import java.util.Calendar;
import java.util.Date;

public class MBMailingListLocalServiceImpl
extends MBMailingListLocalServiceBaseImpl {
    public MBMailingList addMailingList(long userId, long groupId, long categoryId, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(emailAddress, inServerName, inUserName, outEmailAddress, outCustom, outServerName, outUserName, active);
        long mailingListId = this.counterLocalService.increment();
        MBMailingList mailingList = this.mbMailingListPersistence.create(mailingListId);
        mailingList.setUuid(serviceContext.getUuid());
        mailingList.setGroupId(groupId);
        mailingList.setCompanyId(user.getCompanyId());
        mailingList.setUserId(user.getUserId());
        mailingList.setUserName(user.getFullName());
        mailingList.setCreateDate(serviceContext.getCreateDate(now));
        mailingList.setModifiedDate(serviceContext.getModifiedDate(now));
        mailingList.setCategoryId(categoryId);
        mailingList.setEmailAddress(emailAddress);
        mailingList.setInProtocol(inUseSSL ? String.valueOf(inProtocol) + "s" : inProtocol);
        mailingList.setInServerName(inServerName);
        mailingList.setInServerPort(inServerPort);
        mailingList.setInUseSSL(inUseSSL);
        mailingList.setInUserName(inUserName);
        mailingList.setInPassword(inPassword);
        mailingList.setInReadInterval(inReadInterval);
        mailingList.setOutEmailAddress(outEmailAddress);
        mailingList.setOutCustom(outCustom);
        mailingList.setOutServerName(outServerName);
        mailingList.setOutServerPort(outServerPort);
        mailingList.setOutUseSSL(outUseSSL);
        mailingList.setOutUserName(outUserName);
        mailingList.setOutPassword(outPassword);
        mailingList.setAllowAnonymous(allowAnonymous);
        mailingList.setActive(active);
        this.mbMailingListPersistence.update((BaseModel)mailingList, false);
        if (active) {
            this.scheduleMailingList(mailingList);
        }
        return mailingList;
    }

    public void deleteCategoryMailingList(long groupId, long categoryId) throws PortalException, SystemException {
        MBMailingList mailingList = this.mbMailingListPersistence.findByG_C(groupId, categoryId);
        this.deleteMailingList(mailingList);
    }

    public void deleteMailingList(long mailingListId) throws PortalException, SystemException {
        MBMailingList mailingList = this.mbMailingListPersistence.findByPrimaryKey(mailingListId);
        this.deleteMailingList(mailingList);
    }

    public void deleteMailingList(MBMailingList mailingList) throws PortalException, SystemException {
        this.unscheduleMailingList(mailingList);
        this.mbMailingListPersistence.remove((BaseModel)mailingList);
    }

    public MBMailingList getCategoryMailingList(long groupId, long categoryId) throws PortalException, SystemException {
        return this.mbMailingListPersistence.findByG_C(groupId, categoryId);
    }

    public MBMailingList updateMailingList(long mailingListId, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        this.validate(emailAddress, inServerName, inUserName, outEmailAddress, outCustom, outServerName, outUserName, active);
        MBMailingList mailingList = this.mbMailingListPersistence.findByPrimaryKey(mailingListId);
        mailingList.setModifiedDate(serviceContext.getModifiedDate(null));
        mailingList.setEmailAddress(emailAddress);
        mailingList.setInProtocol(inUseSSL ? String.valueOf(inProtocol) + "s" : inProtocol);
        mailingList.setInServerName(inServerName);
        mailingList.setInServerPort(inServerPort);
        mailingList.setInUseSSL(inUseSSL);
        mailingList.setInUserName(inUserName);
        mailingList.setInPassword(inPassword);
        mailingList.setInReadInterval(inReadInterval);
        mailingList.setOutEmailAddress(outEmailAddress);
        mailingList.setOutCustom(outCustom);
        mailingList.setOutServerName(outServerName);
        mailingList.setOutServerPort(outServerPort);
        mailingList.setOutUseSSL(outUseSSL);
        mailingList.setOutUserName(outUserName);
        mailingList.setOutPassword(outPassword);
        mailingList.setAllowAnonymous(allowAnonymous);
        mailingList.setActive(active);
        this.mbMailingListPersistence.update((BaseModel)mailingList, false);
        if (active) {
            this.scheduleMailingList(mailingList);
        }
        return mailingList;
    }

    protected String getSchedulerGroupName(MBMailingList mailingList) {
        return "liferay/message_boards_mailing_list".concat("/").concat(String.valueOf(mailingList.getMailingListId()));
    }

    protected void scheduleMailingList(MBMailingList mailingList) throws PortalException {
        String groupName = this.getSchedulerGroupName(mailingList);
        Calendar startDate = CalendarFactoryUtil.getCalendar();
        CronText cronText = new CronText(startDate, 2, mailingList.getInReadInterval());
        CronTrigger trigger = new CronTrigger(groupName, groupName, startDate.getTime(), null, cronText.toString());
        MailingListRequest mailingListRequest = new MailingListRequest();
        mailingListRequest.setCompanyId(mailingList.getCompanyId());
        mailingListRequest.setUserId(mailingList.getUserId());
        mailingListRequest.setGroupId(mailingList.getGroupId());
        mailingListRequest.setCategoryId(mailingList.getCategoryId());
        mailingListRequest.setInProtocol(mailingList.getInProtocol());
        mailingListRequest.setInServerName(mailingList.getInServerName());
        mailingListRequest.setInServerPort(mailingList.getInServerPort());
        mailingListRequest.setInUseSSL(mailingList.getInUseSSL());
        mailingListRequest.setInUserName(mailingList.getInUserName());
        mailingListRequest.setInPassword(mailingList.getInPassword());
        mailingListRequest.setAllowAnonymous(mailingList.getAllowAnonymous());
        SchedulerEngineUtil.schedule((Trigger)trigger, (StorageType)StorageType.MEMORY_CLUSTERED, null, (String)"liferay/message_boards_mailing_list", (Object)mailingListRequest, (int)0);
    }

    protected void unscheduleMailingList(MBMailingList mailingList) throws PortalException {
        String groupName = this.getSchedulerGroupName(mailingList);
        SchedulerEngineUtil.unschedule((String)groupName, (StorageType)StorageType.MEMORY_CLUSTERED);
    }

    protected void validate(String emailAddress, String inServerName, String inUserName, String outEmailAddress, boolean outCustom, String outServerName, String outUserName, boolean active) throws PortalException {
        if (!active) {
            return;
        }
        if (!Validator.isEmailAddress((String)emailAddress)) {
            throw new MailingListEmailAddressException();
        }
        if (Validator.isNull((String)inServerName)) {
            throw new MailingListInServerNameException();
        }
        if (Validator.isNull((String)inUserName)) {
            throw new MailingListInUserNameException();
        }
        if (Validator.isNull((String)outEmailAddress)) {
            throw new MailingListOutEmailAddressException();
        }
        if (outCustom) {
            if (Validator.isNull((String)outServerName)) {
                throw new MailingListOutServerNameException();
            }
            if (Validator.isNull((String)outUserName)) {
                throw new MailingListOutUserNameException();
            }
        }
    }
}

