/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.service.base.MBStatsUserLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBStatsUserLocalServiceImpl
extends MBStatsUserLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBStatsUserLocalServiceImpl.class);

    public MBStatsUser addStatsUser(long groupId, long userId) throws SystemException {
        MBStatsUser statsUser;
        block3: {
            long statsUserId = this.counterLocalService.increment();
            statsUser = this.mbStatsUserPersistence.create(statsUserId);
            statsUser.setGroupId(groupId);
            statsUser.setUserId(userId);
            try {
                this.mbStatsUserPersistence.update((BaseModel)statsUser, false);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {groupId=" + groupId + ", userId=" + userId + "}"));
                }
                if ((statsUser = this.mbStatsUserPersistence.fetchByG_U(groupId, userId, false)) != null) break block3;
                throw se;
            }
        }
        return statsUser;
    }

    public void deleteStatsUser(long statsUserId) throws PortalException, SystemException {
        MBStatsUser statsUser = this.mbStatsUserPersistence.findByPrimaryKey(statsUserId);
        this.deleteStatsUser(statsUser);
    }

    public void deleteStatsUser(MBStatsUser statsUser) throws SystemException {
        this.mbStatsUserPersistence.remove((BaseModel)statsUser);
    }

    public void deleteStatsUsersByGroupId(long groupId) throws SystemException {
        List statsUsers = this.mbStatsUserPersistence.findByGroupId(groupId);
        for (MBStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public void deleteStatsUsersByUserId(long userId) throws SystemException {
        List statsUsers = this.mbStatsUserPersistence.findByUserId(userId);
        for (MBStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public long getMessageCountByUserId(long userId) throws SystemException {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(MBStatsUser.class, (String)"MBStatsUser", (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        dynamicQuery.setProjection(ProjectionFactoryUtil.sum((String)"messageCount"));
        dynamicQuery.add(PropertyFactoryUtil.forName((String)"userId").eq((Object)userId));
        List results = this.mbStatsUserLocalService.dynamicQuery(dynamicQuery);
        if (results.isEmpty()) {
            return 0L;
        }
        return (Long)results.get(0);
    }

    public MBStatsUser getStatsUser(long groupId, long userId) throws SystemException {
        MBStatsUser statsUser = this.mbStatsUserPersistence.fetchByG_U(groupId, userId);
        if (statsUser == null) {
            statsUser = this.mbStatsUserLocalService.addStatsUser(groupId, userId);
        }
        return statsUser;
    }

    public List<MBStatsUser> getStatsUsersByGroupId(long groupId, int start, int end) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        return this.mbStatsUserPersistence.findByG_NotU_NotM(groupId, defaultUserId, 0, start, end);
    }

    public int getStatsUsersByGroupIdCount(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        return this.mbStatsUserPersistence.countByG_NotU_NotM(groupId, defaultUserId, 0);
    }

    public List<MBStatsUser> getStatsUsersByUserId(long userId) throws SystemException {
        return this.mbStatsUserPersistence.findByUserId(userId);
    }

    public MBStatsUser updateStatsUser(long groupId, long userId) throws SystemException {
        return this.updateStatsUser(groupId, userId, null);
    }

    public MBStatsUser updateStatsUser(long groupId, long userId, Date lastPostDate) throws SystemException {
        int messageCount = this.mbMessagePersistence.countByG_U(groupId, userId);
        MBStatsUser statsUser = this.getStatsUser(groupId, userId);
        statsUser.setMessageCount(messageCount);
        if (lastPostDate != null) {
            statsUser.setLastPostDate(lastPostDate);
        }
        this.mbStatsUserPersistence.update((BaseModel)statsUser, false);
        return statsUser;
    }
}

