/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.messageboards.SplitThreadException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.MBTreeWalker;
import com.liferay.portlet.messageboards.service.base.MBThreadLocalServiceBaseImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBThreadLocalServiceImpl
extends MBThreadLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBThreadLocalServiceImpl.class);

    public MBThread addThread(long categoryId, MBMessage message) throws PortalException, SystemException {
        long threadId = message.getThreadId();
        if (!message.isRoot() || threadId <= 0L) {
            threadId = this.counterLocalService.increment();
        }
        MBThread thread = this.mbThreadPersistence.create(threadId);
        thread.setGroupId(message.getGroupId());
        thread.setCompanyId(message.getCompanyId());
        thread.setCategoryId(categoryId);
        thread.setRootMessageId(message.getMessageId());
        thread.setRootMessageUserId(message.getUserId());
        if (message.isAnonymous()) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(message.getUserId());
        }
        thread.setLastPostDate(message.getCreateDate());
        if (message.getPriority() != -1.0) {
            thread.setPriority(message.getPriority());
        }
        thread.setStatus(message.getStatus());
        thread.setStatusByUserId(message.getStatusByUserId());
        thread.setStatusByUserName(message.getStatusByUserName());
        thread.setStatusDate(message.getStatusDate());
        this.mbThreadPersistence.update((BaseModel)thread, false);
        if (categoryId >= 0L) {
            this.assetEntryLocalService.updateEntry(message.getUserId(), message.getGroupId(), MBThread.class.getName(), thread.getThreadId(), null, 0L, new long[0], new String[0], false, null, null, null, null, null, String.valueOf(thread.getRootMessageId()), null, null, null, null, 0, 0, null, false);
        }
        return thread;
    }

    public void deleteThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        this.deleteThread(thread);
    }

    public void deleteThread(MBThread thread) throws PortalException, SystemException {
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        indexer.delete((Object)thread);
        long companyId = rootMessage.getCompanyId();
        long repositoryId = 0L;
        String dirName = thread.getAttachmentsDir();
        try {
            DLStoreUtil.deleteDirectory((long)companyId, (long)repositoryId, (String)dirName);
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {}
        this.subscriptionLocalService.deleteSubscriptions(thread.getCompanyId(), MBThread.class.getName(), thread.getThreadId());
        this.mbThreadFlagPersistence.removeByThreadId(thread.getThreadId());
        List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
        for (MBMessage message : messages) {
            this.ratingsStatsLocalService.deleteStats(message.getWorkflowClassName(), message.getMessageId());
            this.assetEntryLocalService.deleteEntry(message.getWorkflowClassName(), message.getMessageId());
            if (!message.isDiscussion()) {
                this.resourceLocalService.deleteResource(message.getCompanyId(), message.getWorkflowClassName(), 4, message.getMessageId());
            }
            this.mbMessagePersistence.remove((BaseModel)message);
            if (!message.isDiscussion()) {
                this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
            }
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
        }
        if (rootMessage.getCategoryId() != 0L && rootMessage.getCategoryId() != -1L) {
            MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(thread.getCategoryId());
            category.setThreadCount(category.getThreadCount() - 1);
            category.setMessageCount(category.getMessageCount() - thread.getMessageCount());
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        this.assetEntryLocalService.deleteEntry(MBThread.class.getName(), thread.getThreadId());
        this.mbThreadPersistence.remove((BaseModel)thread);
    }

    public void deleteThreads(long groupId, long categoryId) throws PortalException, SystemException {
        List threads = this.mbThreadPersistence.findByG_C(groupId, categoryId);
        for (MBThread thread : threads) {
            this.deleteThread(thread);
        }
    }

    public MBThread fetchThread(long threadId) throws SystemException {
        return this.mbThreadPersistence.fetchByPrimaryKey(threadId);
    }

    public int getCategoryThreadsCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBThread> getGroupThreads(long groupId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.findByG_NotC(groupId, -1L, start, end);
        }
        return this.mbThreadPersistence.findByG_NotC_S(groupId, -1L, status, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) throws PortalException, SystemException {
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.findByG_NotC(groupId, -1L, start, end);
            }
            return this.mbThreadPersistence.findByG_NotC_S(groupId, -1L, status, start, end);
        }
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U_C_S(groupId, userId, null, status, start, end);
        }
        List threadIds = null;
        threadIds = includeAnonymous ? this.mbMessageFinder.findByG_U_C_S(groupId, userId, null, status, start, end) : this.mbMessageFinder.findByG_U_C_A_S(groupId, userId, null, false, status, start, end);
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator iterator = threadIds.iterator();
        while (iterator.hasNext()) {
            long threadId = (Long)iterator.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, status, subscribed, true, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, status, false, start, end);
    }

    public int getGroupThreadsCount(long groupId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_NotC(groupId, -1L);
        }
        return this.mbThreadPersistence.countByG_NotC_S(groupId, -1L, status);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, status, false);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, status, subscribed, true);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) throws SystemException {
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.countByG_NotC(groupId, -1L);
            }
            return this.mbThreadPersistence.countByG_NotC_S(groupId, -1L, status);
        }
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U_C_S(groupId, userId, null, status);
        }
        if (includeAnonymous) {
            return this.mbMessageFinder.countByG_U_C_S(groupId, userId, null, status);
        }
        return this.mbMessageFinder.countByG_U_C_A_S(groupId, userId, null, false, status);
    }

    public List<MBThread> getNoAssetThreads() throws SystemException {
        return this.mbThreadFinder.findByNoAssets();
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority) throws PortalException, SystemException {
        return this.getPriorityThreads(categoryId, priority, false);
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority, boolean inherit) throws PortalException, SystemException {
        if (!inherit) {
            return this.mbThreadPersistence.findByC_P(categoryId, priority);
        }
        ArrayList<MBThread> threads = new ArrayList<MBThread>();
        while (categoryId != 0L && categoryId != -1L) {
            threads.addAll(0, this.mbThreadPersistence.findByC_P(categoryId, priority));
            MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
            categoryId = category.getParentCategoryId();
        }
        return threads;
    }

    public MBThread getThread(long threadId) throws PortalException, SystemException {
        return this.mbThreadPersistence.findByPrimaryKey(threadId);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbThreadPersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public boolean hasAnswerMessage(long threadId) throws SystemException {
        int count = this.mbMessagePersistence.countByT_A(threadId, true);
        return count > 0;
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    public MBThread incrementViewCounter(long threadId, int increment) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        thread.setViewCount(thread.getViewCount() + increment);
        this.mbThreadPersistence.update((BaseModel)thread, false);
        return thread;
    }

    public MBThread moveThread(long groupId, long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        long oldCategoryId = thread.getCategoryId();
        MBCategory oldCategory = null;
        if (oldCategoryId != 0L) {
            oldCategory = this.mbCategoryPersistence.findByPrimaryKey(oldCategoryId);
        }
        MBCategory category = null;
        if (categoryId != 0L) {
            category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        }
        List messages = this.mbMessagePersistence.findByG_C_T(groupId, oldCategoryId, thread.getThreadId());
        for (MBMessage message : messages) {
            message.setCategoryId(categoryId);
            this.mbMessagePersistence.update((BaseModel)message, false);
            if (message.isDiscussion()) continue;
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        thread.setCategoryId(categoryId);
        this.mbThreadPersistence.update((BaseModel)thread, false);
        if (oldCategory != null && categoryId != oldCategoryId) {
            oldCategory.setThreadCount(oldCategory.getThreadCount() - 1);
            oldCategory.setMessageCount(oldCategory.getMessageCount() - thread.getMessageCount());
            this.mbCategoryPersistence.update((BaseModel)oldCategory, false);
        }
        if (category != null && categoryId != oldCategoryId) {
            category.setThreadCount(category.getThreadCount() + 1);
            category.setMessageCount(category.getMessageCount() + thread.getMessageCount());
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        return thread;
    }

    public MBThread splitThread(long messageId, String subject, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        if (message.isRoot()) {
            throw new SplitThreadException();
        }
        MBCategory category = message.getCategory();
        MBThread oldThread = message.getThread();
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(oldThread.getRootMessageId());
        String oldAttachmentsDir = message.getAttachmentsDir();
        this.mbMessageLocalService.updateAnswer(message, false, true);
        MBThread thread = this.addThread(message.getCategoryId(), message);
        if (Validator.isNotNull((String)subject)) {
            MBMessageDisplay messageDisplay = this.mbMessageService.getMessageDisplay(messageId, -1, "tree", false);
            MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
            List messages = treeWalker.getMessages();
            int[] range = treeWalker.getChildrenRange(message);
            int i2 = range[0];
            while (i2 < range[1]) {
                MBMessage curMessage = (MBMessage)messages.get(i2);
                String oldSubject = message.getSubject();
                String curSubject = curMessage.getSubject();
                curSubject = oldSubject.startsWith("RE: ") ? StringUtil.replace((String)curSubject, (String)rootMessage.getSubject(), (String)subject) : StringUtil.replace((String)curSubject, (String)oldSubject, (String)subject);
                curMessage.setSubject(curSubject);
                this.mbMessagePersistence.update((BaseModel)curMessage, false);
                ++i2;
            }
            message.setSubject(subject);
        }
        message.setThreadId(thread.getThreadId());
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(0L);
        message.setAttachmentsDir(null);
        this.mbMessagePersistence.update((BaseModel)message, false);
        this.moveAttachmentsFromOldThread(message, oldAttachmentsDir);
        if (!message.isDiscussion()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        int messagesMoved = 1;
        thread.setMessageCount(messagesMoved += this.moveChildrenMessages(message, category, oldThread.getThreadId()));
        this.mbThreadPersistence.update((BaseModel)thread, false);
        oldThread.setMessageCount(oldThread.getMessageCount() - messagesMoved);
        this.mbThreadPersistence.update((BaseModel)oldThread, false);
        if (message.getCategoryId() != 0L && message.getCategoryId() != -1L) {
            category.setThreadCount(category.getThreadCount() + 1);
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        return thread;
    }

    public void updateQuestion(long threadId, boolean question) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        if (thread.isQuestion() == question) {
            return;
        }
        thread.setQuestion(question);
        this.mbThreadPersistence.update((BaseModel)thread, false);
        if (!question) {
            MBMessage message = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
            this.mbMessageLocalService.updateAnswer(message, false, true);
        }
    }

    public MBThread updateThread(long threadId, int viewCount) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        thread.setViewCount(viewCount);
        this.mbThreadPersistence.update((BaseModel)thread, false);
        return thread;
    }

    protected void moveAttachmentFromOldThread(long companyId, String fileName, String newAttachmentsDir) throws PortalException, SystemException {
        long repositoryId = 0L;
        StringBundler sb = new StringBundler(4);
        sb.append(newAttachmentsDir);
        sb.append("/");
        sb.append(StringUtil.extractLast((String)fileName, (char)'/'));
        String newFileName = sb.toString();
        try {
            File file = DLStoreUtil.getFile((long)companyId, (long)repositoryId, (String)fileName);
            DLStoreUtil.addFile((long)companyId, (long)repositoryId, (String)newFileName, (boolean)false, (File)file);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InputStream is = DLStoreUtil.getFileAsStream((long)companyId, (long)repositoryId, (String)fileName);
            try {
                DLStoreUtil.addFile((long)companyId, (long)repositoryId, (String)newFileName, (boolean)false, (InputStream)is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    _log.error((Throwable)ioe);
                }
            }
        }
        DLStoreUtil.deleteFile((long)companyId, (long)repositoryId, (String)fileName);
    }

    protected void moveAttachmentsFromOldThread(MBMessage message, String oldAttachmentsDir) throws PortalException, SystemException {
        String[] fileNames;
        if (!message.getAttachments()) {
            return;
        }
        long companyId = message.getCompanyId();
        long repositoryId = 0L;
        String newAttachmentsDir = message.getAttachmentsDir();
        try {
            DLStoreUtil.addDirectory((long)companyId, (long)repositoryId, (String)newAttachmentsDir);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        String[] stringArray = fileNames = DLStoreUtil.getFileNames((long)companyId, (long)repositoryId, (String)oldAttachmentsDir);
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.moveAttachmentFromOldThread(companyId, fileName, newAttachmentsDir);
            ++n2;
        }
        try {
            DLStoreUtil.deleteDirectory((long)companyId, (long)repositoryId, (String)oldAttachmentsDir);
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {}
    }

    protected int moveChildrenMessages(MBMessage parentMessage, MBCategory category, long oldThreadId) throws PortalException, SystemException {
        int messagesMoved = 0;
        List messages = this.mbMessagePersistence.findByT_P(oldThreadId, parentMessage.getMessageId());
        for (MBMessage message : messages) {
            String oldAttachmentsDir = message.getAttachmentsDir();
            message.setCategoryId(parentMessage.getCategoryId());
            message.setThreadId(parentMessage.getThreadId());
            message.setRootMessageId(parentMessage.getRootMessageId());
            message.setAttachmentsDir(null);
            this.mbMessagePersistence.update((BaseModel)message, false);
            this.moveAttachmentsFromOldThread(message, oldAttachmentsDir);
            if (!message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.reindex((Object)message);
            }
            ++messagesMoved;
            messagesMoved += this.moveChildrenMessages(message, category, oldThreadId);
        }
        return messagesMoved;
    }
}

